/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.sp;

import com.sun.xml.rpc.sp.SimpleHashtable;

final class ContentModel {
    public char type;
    public Object content;
    public ContentModel next;
    private SimpleHashtable cache = new SimpleHashtable();

    public ContentModel(String element) {
        this.type = '\u0000';
        this.content = element;
    }

    public ContentModel(char type, ContentModel content) {
        this.type = type;
        this.content = content;
    }

    public boolean empty() {
        switch (this.type) {
            case '*': 
            case '?': {
                return true;
            }
            case '\u0000': 
            case '+': {
                return false;
            }
            case '|': {
                if (this.content instanceof ContentModel && ((ContentModel)this.content).empty()) {
                    return true;
                }
                ContentModel m = this.next;
                while (m != null) {
                    if (m.empty()) {
                        return true;
                    }
                    m = m.next;
                }
                return false;
            }
            case ',': {
                if (this.content instanceof ContentModel) {
                    if (!((ContentModel)this.content).empty()) {
                        return false;
                    }
                } else {
                    return false;
                }
                ContentModel m = this.next;
                while (m != null) {
                    if (!m.empty()) {
                        return false;
                    }
                    m = m.next;
                }
                return true;
            }
        }
        throw new InternalError();
    }

    public boolean first(String token) {
        boolean retval;
        Boolean b = (Boolean)this.cache.get(token);
        if (b != null) {
            return b;
        }
        switch (this.type) {
            case '\u0000': 
            case '*': 
            case '+': 
            case '?': {
                if (this.content instanceof String) {
                    retval = this.content == token;
                    break;
                }
                retval = ((ContentModel)this.content).first(token);
                break;
            }
            case ',': {
                if (this.content instanceof String) {
                    retval = this.content == token;
                    break;
                }
                if (((ContentModel)this.content).first(token)) {
                    retval = true;
                    break;
                }
                if (!((ContentModel)this.content).empty()) {
                    retval = false;
                    break;
                }
                if (this.next != null) {
                    retval = this.next.first(token);
                    break;
                }
                retval = false;
                break;
            }
            case '|': {
                if (this.content instanceof String && this.content == token) {
                    retval = true;
                    break;
                }
                if (((ContentModel)this.content).first(token)) {
                    retval = true;
                    break;
                }
                if (this.next != null) {
                    retval = this.next.first(token);
                    break;
                }
                retval = false;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (retval) {
            this.cache.put(token, Boolean.TRUE);
        } else {
            this.cache.put(token, Boolean.FALSE);
        }
        return retval;
    }
}

