/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.tube;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.tx.at.WSATException;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.common.TransactionManagerImpl;
import com.sun.xml.ws.tx.at.internal.ForeignRecoveryContext;
import com.sun.xml.ws.tx.at.internal.ForeignRecoveryContextManager;
import com.sun.xml.ws.tx.at.internal.XidImpl;
import com.sun.xml.ws.tx.at.localization.LocalizationMessages;
import com.sun.xml.ws.tx.at.runtime.TransactionIdHelper;
import com.sun.xml.ws.tx.at.tube.TransactionalAttribute;
import com.sun.xml.ws.tx.at.tube.WSATServer;
import com.sun.xml.ws.tx.coord.common.CoordinationContextBuilder;
import com.sun.xml.ws.tx.coord.common.RegistrationIF;
import com.sun.xml.ws.tx.coord.common.WSCBuilderFactory;
import com.sun.xml.ws.tx.coord.common.client.RegistrationMessageBuilder;
import com.sun.xml.ws.tx.coord.common.client.RegistrationProxyBuilder;
import com.sun.xml.ws.tx.coord.common.types.BaseRegisterResponseType;
import com.sun.xml.ws.tx.coord.common.types.BaseRegisterType;
import com.sun.xml.ws.tx.coord.common.types.CoordinationContextIF;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;

public class WSATServerHelper
implements WSATServer {
    private static final Logger LOGGER = Logger.getLogger(WSATServerHelper.class);

    public void doHandleRequest(HeaderList headers, TransactionalAttribute tx) {
        CoordinationContextBuilder ccBuilder;
        if (WSATHelper.isDebugEnabled()) {
            this.debug("processRequest HeaderList:" + headers + " TransactionalAttribute:" + tx + " isEnabled:" + tx.isEnabled());
        }
        if ((ccBuilder = CoordinationContextBuilder.headers(headers, tx.getVersion())) != null) {
            this.processIncomingTransaction(ccBuilder);
        } else if (tx.isRequired()) {
            throw new WebServiceException("transaction context is required to be inflowed");
        }
    }

    public void doHandleResponse(TransactionalAttribute transactionalAttribute) {
        if (transactionalAttribute == null || transactionalAttribute.isEnabled()) {
            // empty if block
        }
    }

    public void doHandleException(Throwable throwable) {
    }

    private void processIncomingTransaction(CoordinationContextBuilder builder) {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("in processingIncomingTransaction");
        }
        CoordinationContextIF cc = builder.buildFromHeader();
        long timeout = cc.getExpires().getValue();
        String tid = cc.getIdentifier().getValue().replace("urn:", "").replaceAll("uuid:", "");
        boolean isRegistered = false;
        try {
            Xid foreignXid = WSATHelper.getTransactionServices().importTransaction((int)timeout, tid.getBytes());
            if (foreignXid != null) {
                isRegistered = true;
            }
            if (!isRegistered) {
                foreignXid = new XidImpl(tid.getBytes());
                this.register(builder, cc, foreignXid, timeout);
            }
        }
        catch (WSATException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private void register(CoordinationContextBuilder builder, CoordinationContextIF cc, Xid foreignXid, long timeout) {
        String participantId = TransactionIdHelper.getInstance().xid2wsatid(foreignXid);
        Transactional.Version version = builder.getVersion();
        WSCBuilderFactory factory = WSCBuilderFactory.newInstance(version);
        RegistrationMessageBuilder rrBuilder = factory.newWSATRegistrationRequestBuilder();
        BaseRegisterType registerType = rrBuilder.durable(true).txId(participantId).routing().build();
        RegistrationProxyBuilder proxyBuilder = factory.newRegistrationProxyBuilder();
        proxyBuilder.to((EndpointReference)cc.getRegistrationService()).txIdForReference(participantId).timeout(timeout);
        RegistrationIF proxyIF = proxyBuilder.build();
        BaseRegisterResponseType registerResponseType = proxyIF.registerOperation(registerType);
        if (WSATHelper.isDebugEnabled()) {
            this.debug("Return from registerOperation call:" + registerResponseType);
        }
        if (registerResponseType == null) {
            this.log("Sending fault. Context refused registerResponseType is null");
            throw new WebServiceException("Sending fault. Context refused registerResponseType is null");
        }
        Object epr = registerResponseType.getCoordinatorProtocolService();
        ForeignRecoveryContext frc = ForeignRecoveryContextManager.getInstance().addAndGetForeignRecoveryContextForTidByteArray(foreignXid);
        frc.setEndpointReference((EndpointReference)epr, builder.getVersion());
        TransactionManagerImpl.getInstance().putResource("com.sun.xml.ws.tx.foreignContext", frc);
    }

    public void log(String message) {
        LOGGER.info(LocalizationMessages.WSAT_4612_WSAT_SERVERHELPER(message));
    }

    private void debug(String message) {
        WSATHelper.getInstance().debug("WSATServerInterceptor:" + message);
    }
}

