/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.commons.ha.StickyKey;
import com.sun.xml.ws.rx.ha.ReplicationManager;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import java.io.Serializable;
import java.util.logging.Level;
import org.glassfish.ha.store.api.BackingStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UnackedMessageReplicationManager
implements ReplicationManager<String, ApplicationMessage> {
    private static final Logger LOGGER = Logger.getLogger(UnackedMessageReplicationManager.class);
    private BackingStore<StickyKey, JaxwsApplicationMessage.JaxwsApplicationMessageState> unackedMesagesBs;
    private final String loggerProlog;

    public UnackedMessageReplicationManager(String uniqueEndpointId) {
        this.loggerProlog = "[" + uniqueEndpointId + "_UNACKED_MESSAGES_MANAGER]: ";
        this.unackedMesagesBs = HighAvailabilityProvider.INSTANCE.createBackingStore(HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY), uniqueEndpointId + "_UNACKED_MESSAGES_BS", StickyKey.class, JaxwsApplicationMessage.JaxwsApplicationMessageState.class);
    }

    @Override
    public ApplicationMessage load(String key) {
        JaxwsApplicationMessage.JaxwsApplicationMessageState state = HighAvailabilityProvider.loadFrom(this.unackedMesagesBs, new StickyKey((Serializable)((Object)key)), null);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Message state loaded from unacked message backing store for key [" + key + "]: " + (state == null ? null : state.toString()));
        }
        JaxwsApplicationMessage message = state.toMessage();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Message state converted to a unacked message: " + (message == null ? null : message.toString()));
        }
        return message;
    }

    @Override
    public void save(String key, ApplicationMessage _value, boolean isNew) {
        HaInfo haInfo;
        if (!(_value instanceof JaxwsApplicationMessage)) {
            throw new IllegalArgumentException("Unsupported application message type: " + _value.getClass().getName());
        }
        JaxwsApplicationMessage.JaxwsApplicationMessageState value = ((JaxwsApplicationMessage)_value).getState();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Sending for replication unacked message with a key [" + key + "]: " + value.toString() + ", isNew=" + isNew);
        }
        if ((haInfo = HaContext.currentHaInfo()) != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "Existing HaInfo found, using it for unacked message state replication: " + HaContext.asString(haInfo));
            }
            HighAvailabilityProvider.saveTo(this.unackedMesagesBs, new StickyKey((Serializable)((Object)key), haInfo.getKey()), value, isNew);
        } else {
            StickyKey stickyKey = new StickyKey((Serializable)((Object)key));
            String replicaId = HighAvailabilityProvider.saveTo(this.unackedMesagesBs, stickyKey, value, isNew);
            haInfo = new HaInfo(stickyKey.getHashKey(), replicaId, false);
            HaContext.updateHaInfo(haInfo);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this.loggerProlog + "No HaInfo found, created new after unacked message state replication: " + HaContext.asString(haInfo));
            }
        }
    }

    @Override
    public void remove(String key) {
        HighAvailabilityProvider.removeFrom(this.unackedMesagesBs, new StickyKey((Serializable)((Object)key)));
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Removed unacked message from the backing store for key [" + key + "]");
        }
    }

    @Override
    public void close() {
        HighAvailabilityProvider.close(this.unackedMesagesBs);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Closed unacked message backing store");
        }
    }

    @Override
    public void destroy() {
        HighAvailabilityProvider.destroy(this.unackedMesagesBs);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this.loggerProlog + "Destroyed unacked message backing store");
        }
    }
}

