/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.xml.ws.encoding.ContentType;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlDataContentHandler
implements DataContentHandler {
    private final DataFlavor[] flavors = new DataFlavor[2];

    public XmlDataContentHandler() throws ClassNotFoundException {
        this.flavors[0] = new ActivationDataFlavor(StreamSource.class, "text/xml", "XML");
        this.flavors[1] = new ActivationDataFlavor(StreamSource.class, "application/xml", "XML");
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public Object getTransferData(DataFlavor df, DataSource ds) throws IOException {
        for (DataFlavor aFlavor : this.flavors) {
            if (!aFlavor.equals(df)) continue;
            return this.getContent(ds);
        }
        return null;
    }

    public Object getContent(DataSource dataSource) throws IOException {
        return new StreamSource(dataSource.getInputStream());
    }

    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (!this.isXmlType(mimeType)) {
            throw new IOException("Invalid content type \"" + mimeType + "\" for XmlDCH");
        }
        if (!(obj instanceof DataSource) && !(obj instanceof Source)) {
            throw new IOException("Invalid Object type = " + obj.getClass() + ". XmlDCH can only convert DataSource or Source to XML.");
        }
        try {
            Transformer transformer = XmlUtil.newTransformer();
            StreamResult result = new StreamResult(os);
            if (obj instanceof DataSource) {
                transformer.transform((Source)this.getContent((DataSource)obj), result);
            } else {
                transformer.transform((Source)obj, result);
            }
        }
        catch (Exception ex) {
            throw new IOException("Unable to run the JAXP transformer on a stream " + ex.getMessage());
        }
    }

    private boolean isXmlType(String type) {
        try {
            ContentType ct = new ContentType(type);
            return ct.getSubType().equals("xml") && (ct.getPrimaryType().equals("text") || ct.getPrimaryType().equals("application"));
        }
        catch (Exception ex) {
            return false;
        }
    }
}

