/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.streaming;

import com.ctc.wstx.stax.WstxInputFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;

public class XMLInputFactoryPropertiesConfig {
    private static final Logger LOGGER = Logger.getLogger(XMLInputFactoryPropertiesConfig.class.getName());
    public static final String PROPERTY_MAX_ATTRIBUTES_PER_ELEMENT = "xml.ws.maximum.AttributesPerElement";
    public static final String PROPERTY_MAX_ATTRIBUTE_SIZE = "xml.ws.maximum.AttributeSize";
    public static final String PROPERTY_MAX_CHILDREN_PER_ELEMENT = "xml.ws.maximum.ChildrenPerElement";
    public static final String PROPERTY_MAX_ELEMENT_COUNT = "xml.ws.maximum.ElementCount";
    public static final String PROPERTY_MAX_ELEMENT_DEPTH = "xml.ws.maximum.ElementDepth";
    public static final String PROPERTY_MAX_CHARACTERS = "xml.ws.maximum.Characters";
    private static final int DEFAULT_MAX_ATTRIBUTES_PER_ELEMENT = 500;
    private static final int DEFAULT_MAX_ATTRIBUTE_SIZE = 524288;
    private static final int DEFAULT_MAX_CHILDREN_PER_ELEMENT = Integer.MAX_VALUE;
    private static final int DEFAULT_MAX_ELEMENT_DEPTH = 500;
    private static final long DEFAULT_MAX_ELEMENT_COUNT = Integer.MAX_VALUE;
    private static final long DEFAULT_MAX_CHARACTERS = Long.MAX_VALUE;
    private int maxAttributesPerElement = 500;
    private int maxAttributeSize = 524288;
    private int maxChildrenPerElement = Integer.MAX_VALUE;
    private int maxElementDepth = 500;
    private long maxElementCount = Integer.MAX_VALUE;
    private long maxCharacters = Long.MAX_VALUE;

    public static void configXMLInputFactory(XMLInputFactory xif) {
        if (xif instanceof WstxInputFactory) {
            XMLInputFactoryPropertiesConfig.configWstxInputFactory((WstxInputFactory)xif);
        }
    }

    private static void configWstxInputFactory(WstxInputFactory xif) {
        XMLInputFactoryPropertiesConfig propertiesConfig = XMLInputFactoryPropertiesConfig.builder().build();
        Integer maxAttributesPerElement = propertiesConfig.getMaxAttributesPerElement();
        xif.setProperty("com.ctc.wstx.maxAttributesPerElement", (Object)maxAttributesPerElement);
        Integer maxAttributeSize = propertiesConfig.getMaxAttributeSize();
        xif.setProperty("com.ctc.wstx.maxAttributeSize", (Object)maxAttributeSize);
        Integer maxChildrenPerElement = propertiesConfig.getMaxChildrenPerElement();
        xif.setProperty("com.ctc.wstx.maxChildrenPerElement", (Object)maxChildrenPerElement);
        Integer maxElementDepth = propertiesConfig.getMaxElementDepth();
        xif.setProperty("com.ctc.wstx.maxElementDepth", (Object)maxElementDepth);
        Long maxElementCount = propertiesConfig.getMaxElementCount();
        xif.setProperty("com.ctc.wstx.maxElementCount", (Object)maxElementCount);
        Long maxCharacters = propertiesConfig.getMaxCharacters();
        xif.setProperty("com.ctc.wstx.maxCharacters", (Object)maxCharacters);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "com.ctc.wstx.maxAttributesPerElement is " + maxAttributesPerElement);
            LOGGER.log(Level.FINE, "com.ctc.wstx.maxAttributeSize is " + maxAttributeSize);
            LOGGER.log(Level.FINE, "com.ctc.wstx.maxChildrenPerElement is " + maxChildrenPerElement);
            LOGGER.log(Level.FINE, "com.ctc.wstx.maxElementDepth is " + maxElementDepth);
            LOGGER.log(Level.FINE, "com.ctc.wstx.maxElementCount is " + maxElementCount);
            LOGGER.log(Level.FINE, "com.ctc.wstx.maxCharacters is " + maxCharacters);
        }
    }

    private int getMaxAttributesPerElement() {
        return this.maxAttributesPerElement;
    }

    private int getMaxAttributeSize() {
        return this.maxAttributeSize;
    }

    private int getMaxChildrenPerElement() {
        return this.maxChildrenPerElement;
    }

    private int getMaxElementDepth() {
        return this.maxElementDepth;
    }

    private long getMaxElementCount() {
        return this.maxElementCount;
    }

    private long getMaxCharacters() {
        return this.maxCharacters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private XMLInputFactoryPropertiesConfig configValues = null;

        Builder() {
            this.buildXMLInputFactoryPropertiesConfig();
        }

        public XMLInputFactoryPropertiesConfig build() {
            if (this.configValues == null) {
                this.buildXMLInputFactoryPropertiesConfig();
            }
            return this.configValues;
        }

        private void buildXMLInputFactoryPropertiesConfig() {
            this.configValues = new XMLInputFactoryPropertiesConfig();
            this.buildMaxAttributesPerElement();
            this.buildMaxAttributeSize();
            this.buildMaxCharacters();
            this.buildMaxChildrenPerElement();
            this.buildMaxElementCount();
            this.buildMaxElementDepth();
        }

        private void buildMaxAttributesPerElement() {
            this.configValues.maxAttributesPerElement = this.buildIntegerValue(XMLInputFactoryPropertiesConfig.PROPERTY_MAX_ATTRIBUTES_PER_ELEMENT, 500);
        }

        private void buildMaxAttributeSize() {
            this.configValues.maxAttributeSize = this.buildIntegerValue(XMLInputFactoryPropertiesConfig.PROPERTY_MAX_ATTRIBUTE_SIZE, 524288);
        }

        private void buildMaxChildrenPerElement() {
            this.configValues.maxChildrenPerElement = this.buildIntegerValue(XMLInputFactoryPropertiesConfig.PROPERTY_MAX_CHILDREN_PER_ELEMENT, Integer.MAX_VALUE);
        }

        private void buildMaxElementDepth() {
            this.configValues.maxElementDepth = this.buildIntegerValue(XMLInputFactoryPropertiesConfig.PROPERTY_MAX_ELEMENT_DEPTH, 500);
        }

        private void buildMaxElementCount() {
            this.configValues.maxElementCount = this.buildLongValue(XMLInputFactoryPropertiesConfig.PROPERTY_MAX_ELEMENT_COUNT, Integer.MAX_VALUE);
        }

        private void buildMaxCharacters() {
            this.configValues.maxCharacters = this.buildLongValue(XMLInputFactoryPropertiesConfig.PROPERTY_MAX_CHARACTERS, Long.MAX_VALUE);
        }

        private int buildIntegerValue(String propertyName, int defaultValue) {
            block4: {
                String propVal = System.getProperty(propertyName);
                if (propVal != null && propVal.length() > 0) {
                    try {
                        Integer value = Integer.parseInt(propVal);
                        if (value > 0) {
                            return value;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                        LOGGER.log(Level.WARNING, "Ignoring error when building integer value", nfe);
                    }
                }
            }
            return defaultValue;
        }

        private long buildLongValue(String propertyName, long defaultValue) {
            block4: {
                String propVal = System.getProperty(propertyName);
                if (propVal != null && propVal.length() > 0) {
                    try {
                        long value = Long.parseLong(propVal);
                        if (value > 0L) {
                            return value;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                        LOGGER.log(Level.WARNING, "Ignoring error when building long value", nfe);
                    }
                }
            }
            return defaultValue;
        }
    }
}

