/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.common.client;

import com.sun.xml.ws.api.addressing.OneWayFeature;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.tx.at.common.WSATVersion;
import com.sun.xml.ws.tx.coord.common.WSCUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseProxyBuilder<T, B extends BaseProxyBuilder<T, B>> {
    protected WSATVersion<T> version;
    protected EndpointReference to;
    protected EndpointReference replyTo;
    protected List<WebServiceFeature> features;

    protected BaseProxyBuilder(WSATVersion<T> version) {
        this.version = version;
        this.feature(version.newAddressingFeature());
    }

    public void feature(WebServiceFeature feature) {
        if (feature == null) {
            return;
        }
        if (this.features == null) {
            this.features = new ArrayList<WebServiceFeature>();
        }
        this.features.add(feature);
    }

    public B to(EndpointReference to) {
        this.to = to;
        return (B)this;
    }

    public B replyTo(EndpointReference replyTo) {
        this.replyTo = replyTo;
        if (replyTo != null) {
            this.feature(new OneWayFeature(true, WSEndpointReference.create(replyTo)));
        }
        return (B)this;
    }

    public B txIdForReference(String txId, String bqual) {
        Object endpointReference = this.version.newEndpointReferenceBuilder().address(this.getDefaultCallbackAddress()).referenceParameter(WSCUtil.referenceElementTxId(txId), WSCUtil.referenceElementBranchQual(bqual), WSCUtil.referenceElementRoutingInfo()).build();
        this.replyTo((EndpointReference)endpointReference);
        return (B)this;
    }

    protected WebServiceFeature[] getEnabledFeatures() {
        return this.features.toArray(new WebServiceFeature[0]);
    }

    protected abstract String getDefaultCallbackAddress();
}

