/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.jmx;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.metro.api.config.management.ReconfigNotifier;
import java.util.logging.Level;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

public class ReconfigNotification
implements ReconfigNotifier {
    public static final String NOTIFICATION_SUCCESS = "sun.metro.config.reconfig.success";
    private static final Logger LOGGER = Logger.getLogger(ReconfigNotification.class);
    private final NotificationBroadcasterSupport support;
    private final ObjectName source;
    private volatile long sequenceNumber = 0L;

    public ReconfigNotification(NotificationBroadcasterSupport support, ObjectName source) {
        this.support = support;
        this.source = source;
    }

    public String[] getNotificationTypes() {
        String[] types = new String[]{NOTIFICATION_SUCCESS};
        return types;
    }

    public String getName() {
        return ReconfigNotification.class.getName();
    }

    public String getDescription() {
        return ManagementMessages.RECONFIG_NOTIFICATION_DESCRIPTION();
    }

    public void sendNotification() {
        LOGGER.entering();
        Notification notification = new Notification(NOTIFICATION_SUCCESS, this.source, this.sequenceNumber++, System.currentTimeMillis(), ManagementMessages.RECONFIG_NOTIFICATION_MESSAGE());
        this.support.sendNotification(notification);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(ManagementMessages.WSM_5098_NOTIFICATION_SENT(notification));
        }
        LOGGER.exiting();
    }
}

