/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseReason;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.ICloseType;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.StandaloneProcessorSelector;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncReadQueueRecord;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;
import org.glassfish.grizzly.asyncqueue.PushBackHandler;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.monitoring.DefaultMonitoringConfig;
import org.glassfish.grizzly.monitoring.MonitoringConfig;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.utils.CompletionHandlerAdapter;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.grizzly.utils.NullaryFunction;

public abstract class NIOConnection
implements Connection<SocketAddress> {
    private static final AtomicLong CONNECTION_ID_GENERATOR = new AtomicLong(0L);
    protected static final Object NOTIFICATION_INITIALIZED = Boolean.TRUE;
    protected static final Object NOTIFICATION_CLOSED_COMPLETE = Boolean.FALSE;
    private static final boolean WIN32 = "\\".equals(System.getProperty("file.separator"));
    private static final Logger LOGGER = Grizzly.logger(NIOConnection.class);
    private static final short MAX_ZERO_READ_COUNT = 100;
    private final long id = CONNECTION_ID_GENERATOR.incrementAndGet();
    private boolean isInitialReadRequired = true;
    protected final NIOTransport transport;
    protected volatile int maxAsyncWriteQueueSize;
    protected volatile long readTimeoutMillis = 30000L;
    protected volatile long writeTimeoutMillis = 30000L;
    protected volatile SelectableChannel channel;
    protected volatile SelectionKey selectionKey;
    protected volatile SelectorRunner selectorRunner;
    protected volatile Processor processor;
    protected volatile ProcessorSelector processorSelector;
    protected final AttributeHolder attributes;
    private volatile TaskQueue<AsyncReadQueueRecord> asyncReadQueue;
    private final TaskQueue<AsyncWriteQueueRecord> asyncWriteQueue;
    protected static final AtomicReferenceFieldUpdater<NIOConnection, Object> connectCloseSemaphoreUpdater = AtomicReferenceFieldUpdater.newUpdater(NIOConnection.class, Object.class, "connectCloseSemaphore");
    private volatile Object connectCloseSemaphore;
    private final AtomicBoolean isCloseScheduled = new AtomicBoolean();
    private static final AtomicReferenceFieldUpdater<NIOConnection, CloseReason> closeReasonUpdater = AtomicReferenceFieldUpdater.newUpdater(NIOConnection.class, CloseReason.class, "closeReason");
    private volatile CloseReason closeReason;
    private volatile GrizzlyFuture<CloseReason> closeFuture;
    protected volatile boolean isBlocking;
    protected volatile boolean isStandalone;
    protected short zeroByteReadCount;
    private final List<CloseListener> closeListeners = Collections.synchronizedList(new LinkedList());
    private final ProcessorStatesMap processorStateStorage = new ProcessorStatesMap();
    protected final DefaultMonitoringConfig<ConnectionProbe> monitoringConfig = new DefaultMonitoringConfig<ConnectionProbe>(ConnectionProbe.class);
    private final SelectorHandler.Task writeSimulatorRunnable = new SelectorHandler.Task(){

        @Override
        public boolean run() throws IOException {
            return NIOConnection.this.transport.getIOStrategy().executeIoEvent(NIOConnection.this, IOEvent.WRITE, false);
        }
    };
    private final SelectorHandler.Task readSimulatorRunnable = new SelectorHandler.Task(){

        @Override
        public boolean run() throws IOException {
            return NIOConnection.this.transport.getIOStrategy().executeIoEvent(NIOConnection.this, IOEvent.READ, false);
        }
    };

    public NIOConnection(NIOTransport transport) {
        this.transport = transport;
        this.asyncWriteQueue = TaskQueue.createTaskQueue(new TaskQueue.MutableMaxQueueSize(){

            @Override
            public int getMaxQueueSize() {
                return NIOConnection.this.maxAsyncWriteQueueSize;
            }
        });
        this.attributes = transport.getAttributeBuilder().createSafeAttributeHolder();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void configureBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    @Override
    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Override
    public MemoryManager<?> getMemoryManager() {
        return this.transport.getMemoryManager();
    }

    @Override
    public synchronized void configureStandalone(boolean isStandalone) {
        if (this.isStandalone != isStandalone) {
            this.isStandalone = isStandalone;
            if (isStandalone) {
                this.processor = StandaloneProcessor.INSTANCE;
                this.processorSelector = StandaloneProcessorSelector.INSTANCE;
            } else {
                this.processor = this.transport.getProcessor();
                this.processorSelector = this.transport.getProcessorSelector();
            }
        }
    }

    @Override
    public boolean isStandalone() {
        return this.isStandalone;
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public int getMaxAsyncWriteQueueSize() {
        return this.maxAsyncWriteQueueSize;
    }

    @Override
    public void setMaxAsyncWriteQueueSize(int maxAsyncWriteQueueSize) {
        this.maxAsyncWriteQueueSize = maxAsyncWriteQueueSize;
    }

    @Override
    public long getReadTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setReadTimeout(long timeout, TimeUnit timeUnit) {
        this.readTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    @Override
    public long getWriteTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.writeTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setWriteTimeout(long timeout, TimeUnit timeUnit) {
        this.writeTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    public SelectorRunner getSelectorRunner() {
        return this.selectorRunner;
    }

    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        this.selectorRunner = selectorRunner;
    }

    public void attachToSelectorRunner(SelectorRunner selectorRunner) throws IOException {
        this.detachSelectorRunner();
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        FutureImpl future = Futures.createSafeFuture();
        selectorHandler.registerChannelAsync(selectorRunner, this.channel, 0, this, Futures.toCompletionHandler(future));
        try {
            RegisterChannelResult result = (RegisterChannelResult)future.get(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
            this.selectorRunner = selectorRunner;
            this.selectionKey = result.getSelectionKey();
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IOException("", e);
        }
        catch (ExecutionException e) {
            throw new IOException("", e.getCause());
        }
    }

    public void detachSelectorRunner() throws IOException {
        SelectorRunner selectorRunnerLocal = this.selectorRunner;
        this.selectionKey = null;
        this.selectorRunner = null;
        if (selectorRunnerLocal != null) {
            this.transport.getSelectorHandler().deregisterChannel(selectorRunnerLocal, this.channel);
        }
    }

    public SelectableChannel getChannel() {
        return this.channel;
    }

    protected void setChannel(SelectableChannel channel) {
        this.channel = channel;
    }

    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    protected void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
        this.setChannel(selectionKey.channel());
    }

    @Override
    public Processor obtainProcessor(IOEvent ioEvent) {
        Processor selectedProcessor;
        if (this.processor == null && this.processorSelector == null) {
            return this.transport.obtainProcessor(ioEvent, this);
        }
        if (this.processor != null && this.processor.isInterested(ioEvent)) {
            return this.processor;
        }
        if (this.processorSelector != null && (selectedProcessor = this.processorSelector.select(ioEvent, this)) != null) {
            return selectedProcessor;
        }
        return null;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void setProcessor(Processor preferableProcessor) {
        this.processor = preferableProcessor;
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        return this.processorSelector;
    }

    @Override
    public void setProcessorSelector(ProcessorSelector preferableProcessorSelector) {
        this.processorSelector = preferableProcessorSelector;
    }

    @Override
    public <E> E obtainProcessorState(Processor processor, NullaryFunction<E> factory) {
        return this.processorStateStorage.getState(processor, factory);
    }

    @Override
    public void executeInEventThread(IOEvent event, final Runnable runnable) {
        Executor threadPool = this.transport.getIOStrategy().getThreadPoolFor(this, event);
        if (threadPool == null) {
            this.transport.getSelectorHandler().enque(this.selectorRunner, new SelectorHandler.Task(){

                @Override
                public boolean run() throws Exception {
                    runnable.run();
                    return true;
                }
            }, null);
        } else {
            threadPool.execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskQueue<AsyncReadQueueRecord> getAsyncReadQueue() {
        if (this.asyncReadQueue == null) {
            NIOConnection nIOConnection = this;
            synchronized (nIOConnection) {
                if (this.asyncReadQueue == null) {
                    this.asyncReadQueue = TaskQueue.createTaskQueue(null);
                }
            }
        }
        return this.asyncReadQueue;
    }

    public TaskQueue<AsyncWriteQueueRecord> getAsyncWriteQueue() {
        return this.asyncWriteQueue;
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    @Override
    public <M> GrizzlyFuture<ReadResult<M, SocketAddress>> read() {
        FutureImpl<ReadResult<M, SocketAddress>> future = Futures.createSafeFuture();
        this.read(Futures.toCompletionHandler(future));
        return future;
    }

    @Override
    public <M> void read(CompletionHandler<ReadResult<M, SocketAddress>> completionHandler) {
        Processor obtainedProcessor = this.obtainProcessor(IOEvent.READ);
        obtainedProcessor.read(this, completionHandler);
    }

    @Override
    public <M> GrizzlyFuture<WriteResult<M, SocketAddress>> write(M message) {
        FutureImpl<WriteResult<M, SocketAddress>> future = Futures.createSafeFuture();
        this.write(null, message, Futures.toCompletionHandler(future), null);
        return future;
    }

    @Override
    public <M> void write(M message, CompletionHandler<WriteResult<M, SocketAddress>> completionHandler) {
        this.write(null, message, completionHandler, null);
    }

    @Override
    @Deprecated
    public <M> void write(M message, CompletionHandler<WriteResult<M, SocketAddress>> completionHandler, PushBackHandler pushbackHandler) {
        this.write(null, message, completionHandler, pushbackHandler);
    }

    @Override
    public <M> void write(SocketAddress dstAddress, M message, CompletionHandler<WriteResult<M, SocketAddress>> completionHandler) {
        this.write(dstAddress, message, completionHandler, (PushBackHandler)null);
    }

    @Override
    @Deprecated
    public <M> void write(SocketAddress dstAddress, M message, CompletionHandler<WriteResult<M, SocketAddress>> completionHandler, PushBackHandler pushbackHandler) {
        Processor obtainedProcessor = this.obtainProcessor(IOEvent.WRITE);
        obtainedProcessor.write((Connection)this, (Object)dstAddress, message, completionHandler, pushbackHandler);
    }

    @Override
    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen() && this.closeReason == null;
    }

    @Override
    public void assertOpen() throws IOException {
        CloseReason reason = this.getCloseReason();
        if (reason != null) {
            throw new IOException("Connection is closed", reason.getCause());
        }
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public CloseReason getCloseReason() {
        CloseReason cr = this.closeReason;
        if (cr != null) {
            return cr;
        }
        if (this.channel == null || !this.channel.isOpen()) {
            return CloseReason.LOCALLY_CLOSED_REASON;
        }
        return null;
    }

    @Override
    public void terminateSilently() {
        this.terminate0(null, CloseReason.LOCALLY_CLOSED_REASON);
    }

    @Override
    public GrizzlyFuture<Closeable> terminate() {
        FutureImpl<Closeable> future = Futures.createSafeFuture();
        this.terminate0(Futures.toCompletionHandler(future), CloseReason.LOCALLY_CLOSED_REASON);
        return future;
    }

    @Override
    public void terminateWithReason(IOException reason) {
        this.terminate0(null, new CloseReason(CloseType.LOCALLY, reason));
    }

    @Override
    public GrizzlyFuture<Closeable> close() {
        FutureImpl<Closeable> future = Futures.createSafeFuture();
        this.closeGracefully0(Futures.toCompletionHandler(future), CloseReason.LOCALLY_CLOSED_REASON);
        return future;
    }

    @Override
    @Deprecated
    public void close(CompletionHandler<Closeable> completionHandler) {
        this.closeGracefully0(completionHandler, CloseReason.LOCALLY_CLOSED_REASON);
    }

    @Override
    public final void closeSilently() {
        this.closeGracefully0(null, CloseReason.LOCALLY_CLOSED_REASON);
    }

    @Override
    public void closeWithReason(IOException reason) {
        this.closeGracefully0(null, new CloseReason(CloseType.LOCALLY, reason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GrizzlyFuture<CloseReason> closeFuture() {
        if (this.closeFuture == null) {
            NIOConnection nIOConnection = this;
            synchronized (nIOConnection) {
                if (this.closeFuture == null) {
                    CloseReason cr = this.closeReason;
                    if (cr == null) {
                        final FutureImpl<CloseReason> f = Futures.createSafeFuture();
                        this.addCloseListener(new CloseListener(){

                            public void onClosed(Closeable closeable, ICloseType type) throws IOException {
                                CloseReason cr = NIOConnection.this.closeReason;
                                assert (cr != null);
                                f.result(cr);
                            }
                        });
                        this.closeFuture = f;
                    } else {
                        this.closeFuture = Futures.createReadyFuture(cr);
                    }
                }
            }
        }
        return this.closeFuture;
    }

    protected void closeGracefully0(final CompletionHandler<Closeable> completionHandler, CloseReason closeReason) {
        if (this.isCloseScheduled.compareAndSet(false, true)) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                closeReason = new CloseReason(closeReason.getType(), new IOException("Connection is closed at", closeReason.getCause()));
            }
            final CloseReason finalReason = closeReason;
            this.transport.getWriter(this).write(this, Buffers.EMPTY_BUFFER, new EmptyCompletionHandler<WriteResult<Buffer, SocketAddress>>(){

                @Override
                public void completed(WriteResult<Buffer, SocketAddress> result) {
                    NIOConnection.this.terminate0(completionHandler, finalReason);
                }

                @Override
                public void failed(Throwable throwable) {
                    NIOConnection.this.terminate0(completionHandler, finalReason);
                }
            });
        } else if (completionHandler != null) {
            this.addCloseListener(new CloseListener(){

                public void onClosed(Closeable closeable, ICloseType type) throws IOException {
                    completionHandler.completed(NIOConnection.this);
                }
            });
        }
    }

    protected void terminate0(CompletionHandler<Closeable> completionHandler, CloseReason reason) {
        this.isCloseScheduled.set(true);
        if (closeReasonUpdater.compareAndSet(this, null, reason)) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                this.closeReason = new CloseReason(reason.getType(), new IOException("Connection is closed at", reason.getCause()));
            }
            this.preClose();
            this.notifyCloseListeners(reason);
            NIOConnection.notifyProbesClose(this);
            this.transport.getSelectorHandler().execute(this.selectorRunner, new SelectorHandler.Task(){

                @Override
                public boolean run() {
                    try {
                        NIOConnection.this.doClose();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, "Error during connection close", e);
                    }
                    return true;
                }
            }, (CompletionHandler<SelectorHandler.Task>)new CompletionHandlerAdapter<Closeable, SelectorHandler.Task>(null, completionHandler){

                @Override
                protected Connection adapt(SelectorHandler.Task result) {
                    return NIOConnection.this;
                }

                @Override
                public void failed(Throwable throwable) {
                    try {
                        NIOConnection.this.doClose();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.completed(null);
                }
            });
        } else {
            Futures.notifyResult(null, completionHandler, this);
        }
    }

    protected void doClose() throws IOException {
        this.transport.closeConnection(this);
    }

    @Override
    public void addCloseListener(CloseListener closeListener) {
        CloseReason reason = this.closeReason;
        if (reason == null) {
            this.closeListeners.add(closeListener);
            reason = this.closeReason;
            if (reason != null && this.closeListeners.remove(closeListener)) {
                this.invokeCloseListener(closeListener, reason.getType());
            }
        } else {
            this.invokeCloseListener(closeListener, reason.getType());
        }
    }

    @Override
    public boolean removeCloseListener(CloseListener closeListener) {
        return this.closeListeners.remove(closeListener);
    }

    @Override
    public void addCloseListener(Connection.CloseListener closeListener) {
        this.addCloseListener((CloseListener)closeListener);
    }

    @Override
    public boolean removeCloseListener(Connection.CloseListener closeListener) {
        return this.removeCloseListener((CloseListener)closeListener);
    }

    @Override
    public void notifyConnectionError(Throwable error) {
        NIOConnection.notifyProbesError(this, error);
    }

    @Override
    public final MonitoringConfig<ConnectionProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    protected static void notifyProbesBind(NIOConnection connection) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onBindEvent(connection);
            }
        }
    }

    protected static void notifyProbesAccept(NIOConnection serverConnection, NIOConnection clientConnection) {
        ConnectionProbe[] probes = serverConnection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onAcceptEvent(serverConnection, clientConnection);
            }
        }
    }

    protected static void notifyProbesConnect(NIOConnection connection) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onConnectEvent(connection);
            }
        }
    }

    protected static void notifyProbesRead(NIOConnection connection, Buffer data, int size) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onReadEvent(connection, data, size);
            }
        }
    }

    protected static void notifyProbesWrite(NIOConnection connection, Buffer data, long size) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onWriteEvent(connection, data, size);
            }
        }
    }

    protected static void notifyIOEventReady(NIOConnection connection, IOEvent ioEvent) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onIOEventReadyEvent(connection, ioEvent);
            }
        }
    }

    protected static void notifyIOEventEnabled(NIOConnection connection, IOEvent ioEvent) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onIOEventEnableEvent(connection, ioEvent);
            }
        }
    }

    protected static void notifyIOEventDisabled(NIOConnection connection, IOEvent ioEvent) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onIOEventDisableEvent(connection, ioEvent);
            }
        }
    }

    protected static void notifyProbesClose(NIOConnection connection) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onCloseEvent(connection);
            }
        }
    }

    protected static void notifyProbesError(NIOConnection connection, Throwable error) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onErrorEvent(connection, error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCloseListeners(CloseReason closeReason) {
        if (!this.closeListeners.isEmpty()) {
            ArrayList<CloseListener> copiedCloseListeners;
            CloseType closeType = closeReason.getType();
            List<CloseListener> list = this.closeListeners;
            synchronized (list) {
                copiedCloseListeners = new ArrayList<CloseListener>(this.closeListeners);
                this.closeListeners.clear();
            }
            for (CloseListener closeListener : copiedCloseListeners) {
                this.invokeCloseListener(closeListener, closeType);
            }
        }
    }

    protected void preClose() {
        if (connectCloseSemaphoreUpdater.getAndSet(this, NOTIFICATION_CLOSED_COMPLETE) == NOTIFICATION_INITIALIZED) {
            this.transport.fireIOEvent(IOEvent.CLOSED, this, null);
        }
    }

    protected void enableInitialOpRead() throws IOException {
        if (this.isInitialReadRequired) {
            this.enableIOEvent(IOEvent.READ);
        }
    }

    @Override
    public void simulateIOEvent(IOEvent ioEvent) throws IOException {
        if (!this.isOpen()) {
            return;
        }
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        switch (ioEvent) {
            case WRITE: {
                selectorHandler.enque(this.selectorRunner, this.writeSimulatorRunnable, null);
                break;
            }
            case READ: {
                selectorHandler.enque(this.selectorRunner, this.readSimulatorRunnable, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("We support only READ and WRITE events. Got " + ioEvent);
            }
        }
    }

    @Override
    public final void enableIOEvent(IOEvent ioEvent) throws IOException {
        boolean isOpRead = ioEvent == IOEvent.READ;
        int interest = ioEvent.getSelectionKeyInterest();
        if (interest == 0 || isOpRead && this.isCloseScheduled.get() || this.closeReason != null) {
            return;
        }
        NIOConnection.notifyIOEventEnabled(this, ioEvent);
        this.isInitialReadRequired = this.isInitialReadRequired && !isOpRead;
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        selectorHandler.registerKeyInterest(this.selectorRunner, this.selectionKey, interest);
    }

    @Override
    public final void disableIOEvent(IOEvent ioEvent) throws IOException {
        int interest = ioEvent.getSelectionKeyInterest();
        if (interest == 0) {
            return;
        }
        NIOConnection.notifyIOEventDisabled(this, ioEvent);
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        selectorHandler.deregisterKeyInterest(this.selectorRunner, this.selectionKey, interest);
    }

    protected final void checkEmptyRead(int size) {
        if (WIN32) {
            if (size == 0) {
                this.zeroByteReadCount = (short)(this.zeroByteReadCount + 1);
                short count = this.zeroByteReadCount;
                if (count >= 100) {
                    this.closeSilently();
                }
            } else {
                this.zeroByteReadCount = 0;
            }
        }
    }

    final void onSelectionKeyUpdated(SelectionKey newSelectionKey) {
        this.selectionKey = newSelectionKey;
    }

    private void invokeCloseListener(CloseListener closeListener, CloseType closeType) {
        try {
            if (closeListener instanceof Connection.CloseListener) {
                Connection.CloseType closeLocal = closeType == CloseType.LOCALLY ? Connection.CloseType.LOCALLY : Connection.CloseType.REMOTELY;
                ((Connection.CloseListener)closeListener).onClosed(this, closeLocal);
            } else {
                closeListener.onClosed(this, closeType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setMonitoringProbes(ConnectionProbe[] monitoringProbes) {
        this.monitoringConfig.addProbes((ConnectionProbe[])monitoringProbes);
    }

    private static final class ProcessorStatesMap {
        private volatile int volatileFlag;
        private ProcessorState singleProcessorState;
        private ConcurrentMap<Processor, Object> processorStatesMap;

        private ProcessorStatesMap() {
        }

        public <E> E getState(Processor processor, NullaryFunction<E> stateFactory) {
            int c = this.volatileFlag;
            if (c == 0) {
                return (E)this.getStateSync(processor, stateFactory);
            }
            ProcessorState localProcessorState = this.singleProcessorState;
            if (localProcessorState != null) {
                if (localProcessorState.processor.equals(processor)) {
                    return (E)localProcessorState.state;
                }
            } else {
                return (E)this.getStateSync(processor, stateFactory);
            }
            return (E)StaticMapAccessor.getFromMap(this, processor, stateFactory);
        }

        private synchronized <E> Object getStateSync(Processor processor, NullaryFunction<E> stateFactory) {
            if (this.volatileFlag == 0) {
                E state = stateFactory.evaluate();
                this.singleProcessorState = new ProcessorState(processor, state);
                ++this.volatileFlag;
                return state;
            }
            if (this.volatileFlag == 1 && this.singleProcessorState.processor.equals(processor)) {
                return this.singleProcessorState.state;
            }
            return StaticMapAccessor.getFromMapSync(this, processor, stateFactory);
        }

        private static final class ProcessorState {
            private final Processor processor;
            private final Object state;

            public ProcessorState(Processor processor, Object state) {
                this.processor = processor;
                this.state = state;
            }
        }

        private static final class StaticMapAccessor {
            private StaticMapAccessor() {
            }

            private static <E> Object getFromMap(ProcessorStatesMap storage, Processor processor, NullaryFunction<E> stateFactory) {
                Object state;
                ConcurrentMap<Processor, Object> localStateMap = storage.processorStatesMap;
                if (localStateMap != null && (state = storage.processorStatesMap.get(processor)) != null) {
                    return state;
                }
                return storage.getStateSync(processor, stateFactory);
            }

            private static <E> Object getFromMapSync(ProcessorStatesMap storage, Processor processor, NullaryFunction<E> stateFactory) {
                ConcurrentMap<Processor, Object> localStatesMap = storage.processorStatesMap;
                if (localStatesMap != null) {
                    if (localStatesMap.containsKey(processor)) {
                        return localStatesMap.get(processor);
                    }
                    E state = stateFactory.evaluate();
                    localStatesMap.put(processor, state);
                    return state;
                }
                localStatesMap = new ConcurrentHashMap<Processor, Object>(4);
                E state = stateFactory.evaluate();
                localStatesMap.put(processor, state);
                storage.processorStatesMap = localStatesMap;
                ++storage.volatileFlag;
                return state;
            }

            static {
                Grizzly.logger(StaticMapAccessor.class).fine("Map is going to be used as Connection<->ProcessorState storage");
            }
        }
    }
}

