/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.filterchain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Appendable;
import org.glassfish.grizzly.Appender;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.ProcessorResult;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueEnabledTransport;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.PushBackHandler;
import org.glassfish.grizzly.filterchain.ExecutorResolver;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.FilterExecutor;
import org.glassfish.grizzly.filterchain.ForkAction;
import org.glassfish.grizzly.filterchain.InternalContextImpl;
import org.glassfish.grizzly.filterchain.InvokeAction;
import org.glassfish.grizzly.filterchain.ListFacadeFilterChain;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.StopAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.utils.Exceptions;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.grizzly.utils.NullaryFunction;

public final class DefaultFilterChain
extends ListFacadeFilterChain {
    private final FiltersStateFactory filtersStateFactory = new FiltersStateFactory();
    private static final Logger LOGGER = Grizzly.logger(DefaultFilterChain.class);

    public DefaultFilterChain() {
        this((Collection<Filter>)new ArrayList<Filter>());
    }

    public DefaultFilterChain(Collection<Filter> initialFilters) {
        super(new ArrayList<Filter>(initialFilters));
    }

    @Override
    public ProcessorResult process(Context context) {
        if (this.isEmpty()) {
            return ProcessorResult.createComplete();
        }
        InternalContextImpl internalContext = (InternalContextImpl)context;
        FilterChainContext filterChainContext = internalContext.filterChainContext;
        if (filterChainContext.getOperation() == FilterChainContext.Operation.NONE) {
            IOEvent ioEvent = internalContext.getIoEvent();
            if (ioEvent != IOEvent.WRITE) {
                filterChainContext.setOperation(FilterChainContext.ioEvent2Operation(ioEvent));
            } else {
                Connection connection = context.getConnection();
                AsyncQueueEnabledTransport transport = (AsyncQueueEnabledTransport)((Object)connection.getTransport());
                AsyncQueueWriter writer = transport.getAsyncQueueIO().getWriter();
                return writer.processAsync(context).toProcessorResult();
            }
        }
        return this.execute(filterChainContext);
    }

    @Override
    public ProcessorResult execute(FilterChainContext ctx) {
        FilterExecutor executor = ExecutorResolver.resolve(ctx);
        if (ctx.getFilterIdx() == Integer.MIN_VALUE) {
            executor.initIndexes(ctx);
        }
        Connection connection = ctx.getConnection();
        FiltersState filtersState = this.obtainFiltersState(connection);
        int end = ctx.getEndIdx();
        try {
            do {
                FilterExecution execution = this.executeChainPart(ctx, executor, ctx.getFilterIdx(), end, filtersState);
                switch (execution.type) {
                    case 1: {
                        return ProcessorResult.createTerminate();
                    }
                    case 2: {
                        ctx = execution.getContext();
                        int idx = filtersState.peekUnparsedIdx(ctx.getOperation(), ctx.getStartIdx(), ctx.getEndIdx());
                        if (idx != -1) {
                            ctx.setMessage(null);
                            ctx.setFilterIdx(idx);
                            return ProcessorResult.createRerun(ctx.internalContext);
                        }
                        return ProcessorResult.createReregister(ctx.internalContext);
                    }
                }
            } while (DefaultFilterChain.prepareRemainder(ctx, filtersState));
        }
        catch (Throwable e) {
            LOGGER.log(e instanceof IOException ? Level.FINE : Level.WARNING, LogMessages.WARNING_GRIZZLY_FILTERCHAIN_EXCEPTION(), e);
            this.throwChain(ctx, executor, e);
            ctx.getCloseable().closeWithReason(Exceptions.makeIOException(e));
            return ProcessorResult.createError(e);
        }
        return ProcessorResult.createComplete();
    }

    protected FilterExecution executeChainPart(FilterChainContext ctx, FilterExecutor executor, int start, int end, FiltersState filtersState) throws IOException {
        Object chunk;
        int i = start;
        Filter currentFilter = null;
        int lastNextActionType = 0;
        NextAction lastNextAction = null;
        while (i != end) {
            currentFilter = this.get(i);
            if (ctx.predefinedNextAction == null) {
                this.checkStoredMessage(ctx, filtersState, i);
                lastNextAction = this.executeFilter(executor, currentFilter, ctx);
            } else {
                lastNextAction = ctx.predefinedNextAction;
                ctx.predefinedNextAction = null;
            }
            lastNextActionType = lastNextAction.type();
            if (lastNextActionType != 0) break;
            InvokeAction invokeAction = (InvokeAction)lastNextAction;
            chunk = invokeAction.getChunk();
            if (chunk != null) {
                this.storeMessage(ctx, filtersState, invokeAction.isIncomplete(), i, chunk, invokeAction.getAppender());
            }
            i = executor.getNextFilter(ctx);
            ctx.setFilterIdx(i);
        }
        switch (lastNextActionType) {
            case 0: {
                this.notifyComplete(ctx);
                break;
            }
            case 1: {
                assert (currentFilter != null);
                StopAction stopAction = (StopAction)lastNextAction;
                chunk = stopAction.getIncompleteChunk();
                if (chunk == null) break;
                this.storeMessage(ctx, filtersState, true, i, chunk, stopAction.getAppender());
                break;
            }
            case 5: {
                ForkAction forkAction = (ForkAction)lastNextAction;
                return FilterExecution.createReExecute(forkAction.getContext());
            }
            case 2: {
                return FilterExecution.createTerminate();
            }
        }
        return FilterExecution.createContinue();
    }

    protected NextAction executeFilter(FilterExecutor executor, Filter currentFilter, FilterChainContext ctx) throws IOException {
        NextAction nextNextAction;
        do {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINE, "before filter execution. filter={0} context={1}", new Object[]{currentFilter, ctx});
            }
            nextNextAction = executor.execute(currentFilter, ctx);
            if (!LOGGER.isLoggable(Level.FINEST)) continue;
            LOGGER.log(Level.FINE, "after execute filter. filter={0} context={1} nextAction={2}", new Object[]{currentFilter, ctx, nextNextAction});
        } while (nextNextAction.type() == 4);
        return nextNextAction;
    }

    private static boolean prepareRemainder(FilterChainContext ctx, FiltersState filtersState) {
        int idx = filtersState.peekUnparsedIdx(ctx.getOperation(), ctx.getStartIdx(), ctx.getEndIdx());
        if (idx != -1) {
            ctx.setFilterIdx(idx);
            ctx.setMessage(null);
            return true;
        }
        return false;
    }

    @Override
    public void read(Connection connection, CompletionHandler<ReadResult> completionHandler) {
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.setOperation(FilterChainContext.Operation.READ);
        context.getTransportContext().configureBlocking(true);
        ExecutorResolver.resolve(context).initIndexes(context);
        try {
            ReadResult readResult = this.read(context);
            Futures.notifyResult(null, completionHandler, readResult);
        }
        catch (IOException e) {
            Futures.notifyFailure(null, completionHandler, e);
        }
    }

    @Override
    public ReadResult read(FilterChainContext context) throws IOException {
        Connection connection = context.getConnection();
        if (!context.getTransportContext().isBlocking()) {
            throw new IllegalStateException("FilterChain doesn't support standalone non blocking read. Please use Filter instead.");
        }
        FutureImpl future = Futures.createUnsafeFuture();
        context.operationCompletionHandler = Futures.toCompletionHandler(future);
        FilterExecutor executor = ExecutorResolver.resolve(context);
        FiltersState filtersState = this.obtainFiltersState(connection);
        do {
            if (!DefaultFilterChain.prepareRemainder(context, filtersState)) {
                context.setFilterIdx(0);
                context.setMessage(null);
            }
            this.executeChainPart(context, executor, context.getFilterIdx(), context.getEndIdx(), filtersState);
        } while (!future.isDone());
        try {
            FilterChainContext retContext = (FilterChainContext)future.get();
            ReadResult rr = ReadResult.create(connection);
            rr.setMessage(retContext.getMessage());
            rr.setSrcAddressHolder(retContext.getAddressHolder());
            future.recycle(false);
            return rr;
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(Connection connection, Object dstAddress, Object message, CompletionHandler<WriteResult> completionHandler) {
        this.write(connection, dstAddress, message, completionHandler, (MessageCloner)null);
    }

    @Override
    public void write(Connection connection, Object dstAddress, Object message, CompletionHandler<WriteResult> completionHandler, MessageCloner messageCloner) {
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.transportFilterContext.completionHandler = completionHandler;
        context.transportFilterContext.cloner = messageCloner;
        context.setAddress(dstAddress);
        context.setMessage(message);
        context.setOperation(FilterChainContext.Operation.WRITE);
        ProcessorExecutor.execute(context.internalContext);
    }

    @Override
    @Deprecated
    public void write(Connection connection, Object dstAddress, Object message, CompletionHandler completionHandler, PushBackHandler pushBackHandler) {
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.transportFilterContext.completionHandler = completionHandler;
        context.transportFilterContext.pushBackHandler = pushBackHandler;
        context.setAddress(dstAddress);
        context.setMessage(message);
        context.setOperation(FilterChainContext.Operation.WRITE);
        ProcessorExecutor.execute(context.internalContext);
    }

    @Override
    public void flush(Connection connection, CompletionHandler<WriteResult> completionHandler) {
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.setOperation(FilterChainContext.Operation.EVENT);
        context.event = TransportFilter.createFlushEvent(completionHandler);
        ExecutorResolver.DOWNSTREAM_EXECUTOR_SAMPLE.initIndexes(context);
        ProcessorExecutor.execute(context.internalContext);
    }

    @Override
    public void fireEventDownstream(Connection connection, FilterChainEvent event, CompletionHandler<FilterChainContext> completionHandler) {
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.operationCompletionHandler = completionHandler;
        context.setOperation(FilterChainContext.Operation.EVENT);
        context.event = event;
        ExecutorResolver.DOWNSTREAM_EXECUTOR_SAMPLE.initIndexes(context);
        ProcessorExecutor.execute(context.internalContext);
    }

    @Override
    public void fireEventUpstream(Connection connection, FilterChainEvent event, CompletionHandler<FilterChainContext> completionHandler) {
        FilterChainContext context = this.obtainFilterChainContext(connection);
        context.operationCompletionHandler = completionHandler;
        context.setOperation(FilterChainContext.Operation.EVENT);
        context.event = event;
        ExecutorResolver.UPSTREAM_EXECUTOR_SAMPLE.initIndexes(context);
        ProcessorExecutor.execute(context.internalContext);
    }

    @Override
    public void fail(FilterChainContext context, Throwable failure) {
        this.throwChain(context, ExecutorResolver.resolve(context), failure);
    }

    private void throwChain(FilterChainContext ctx, FilterExecutor executor, Throwable exception) {
        int i;
        this.notifyFailure(ctx, exception);
        int endIdx = ctx.getStartIdx();
        if (ctx.getFilterIdx() == endIdx) {
            return;
        }
        do {
            i = executor.getPreviousFilter(ctx);
            ctx.setFilterIdx(i);
            this.get(i).exceptionOccurred(ctx, exception);
        } while (i != endIdx);
    }

    public DefaultFilterChain subList(int fromIndex, int toIndex) {
        return new DefaultFilterChain((Collection<Filter>)this.filters.subList(fromIndex, toIndex));
    }

    private FiltersState obtainFiltersState(Connection connection) {
        return connection.obtainProcessorState(this, this.filtersStateFactory);
    }

    private void checkStoredMessage(FilterChainContext ctx, FiltersState filtersState, int filterIdx) {
        if (filtersState != null) {
            Buffer bufferMessage;
            Object message = ctx.getMessage();
            if (message instanceof Buffer && !(bufferMessage = (Buffer)message).hasRemaining()) {
                return;
            }
            ctx.setMessage(filtersState.append(ctx.getOperation(), filterIdx, message));
        }
    }

    private <M> void storeMessage(FilterChainContext ctx, FiltersState filtersState, boolean isIncomplete, int filterIdx, M messageToStore, Appender<M> appender) {
        assert (messageToStore != null);
        filtersState.set(ctx.getOperation(), filterIdx, isIncomplete, messageToStore, appender);
    }

    private void notifyComplete(FilterChainContext context) {
        CompletionHandler transportCompletionHandler;
        CompletionHandler<FilterChainContext> completionHandler = context.operationCompletionHandler;
        if (completionHandler != null) {
            completionHandler.completed(context);
        }
        if ((transportCompletionHandler = context.transportFilterContext.completionHandler) != null) {
            transportCompletionHandler.completed(null);
        }
    }

    private void notifyFailure(FilterChainContext context, Throwable e) {
        CompletionHandler transportCompletionHandler;
        CompletionHandler<FilterChainContext> completionHandler = context.operationCompletionHandler;
        if (completionHandler != null) {
            completionHandler.failed(e);
        }
        if ((transportCompletionHandler = context.transportFilterContext.completionHandler) != null) {
            transportCompletionHandler.failed(e);
        }
    }

    private final class FiltersStateFactory
    implements NullaryFunction<FiltersState> {
        private FiltersStateFactory() {
        }

        @Override
        public FiltersState evaluate() {
            return new FiltersState(DefaultFilterChain.this.size());
        }
    }

    private static final class FiltersState {
        private static final int OPERATIONS_NUM = FilterChainContext.Operation.values().length;
        private final FilterStateElement[][] state;

        public FiltersState(int filtersNum) {
            this.state = new FilterStateElement[OPERATIONS_NUM][filtersNum];
        }

        public FilterStateElement get(FilterChainContext.Operation operation, int filterIndex) {
            int opIdx = operation.ordinal();
            FilterStateElement elem = this.state[opIdx][filterIndex];
            if (elem != null && elem.isValid) {
                return elem;
            }
            return null;
        }

        public <M> void set(FilterChainContext.Operation operation, int filterIndex, boolean isIncomplete, M messageToStore, Appender<M> appender) {
            int opIdx = operation.ordinal();
            FilterStateElement elem = this.state[opIdx][filterIndex];
            if (elem != null) {
                elem.set(isIncomplete, messageToStore, appender);
            } else {
                this.state[opIdx][filterIndex] = FilterStateElement.create(isIncomplete, messageToStore, appender);
            }
        }

        public int peekUnparsedIdx(FilterChainContext.Operation operation, int start, int end) {
            if (start == end) {
                return -1;
            }
            int opIdx = operation.ordinal();
            int diff = end > start ? -1 : 1;
            int i = end;
            do {
                FilterStateElement elem;
                if ((elem = this.state[opIdx][i += diff]) == null || !elem.isValid || elem.isIncomplete) continue;
                return i;
            } while (i != start);
            return -1;
        }

        private Object append(FilterChainContext.Operation operation, int filterIdx, Object currentMessage) {
            FilterStateElement filterState = this.get(operation, filterIdx);
            return filterState != null ? filterState.append(currentMessage) : currentMessage;
        }
    }

    private static final class FilterExecution {
        private static final int CONTINUE_TYPE = 0;
        private static final int TERMINATE_TYPE = 1;
        private static final int REEXECUTE_TYPE = 2;
        private static final FilterExecution CONTINUE = new FilterExecution(0, null);
        private static final FilterExecution TERMINATE = new FilterExecution(1, null);
        private final int type;
        private final FilterChainContext context;

        public static FilterExecution createContinue() {
            return CONTINUE;
        }

        public static FilterExecution createTerminate() {
            return TERMINATE;
        }

        public static FilterExecution createReExecute(FilterChainContext context) {
            return new FilterExecution(2, context);
        }

        public FilterExecution(int type, FilterChainContext context) {
            this.type = type;
            this.context = context;
        }

        public int getType() {
            return this.type;
        }

        public FilterChainContext getContext() {
            return this.context;
        }
    }

    private static final class FilterStateElement {
        private boolean isIncomplete;
        private Object state;
        private Appender appender;
        private boolean isValid = true;

        static FilterStateElement create(boolean isIncomplete, Object remainder) {
            if (remainder instanceof Buffer) {
                return FilterStateElement.create(isIncomplete, (Buffer)remainder, Buffers.getBufferAppender(true));
            }
            return FilterStateElement.create(isIncomplete, (Appendable)remainder);
        }

        static FilterStateElement create(boolean isIncomplete, Appendable state) {
            return new FilterStateElement(isIncomplete, state);
        }

        static <E> FilterStateElement create(boolean isIncomplete, E state, Appender<E> appender) {
            return new FilterStateElement(isIncomplete, state, appender);
        }

        private FilterStateElement(boolean isIncomplete, Appendable state) {
            assert (state != null);
            this.isIncomplete = isIncomplete;
            this.state = state;
            this.appender = null;
        }

        private <E> FilterStateElement(boolean isIncomplete, E state, Appender<E> appender) {
            assert (state != null);
            this.isIncomplete = isIncomplete;
            this.state = state;
            this.appender = appender;
        }

        private <E> void set(boolean isIncomplete, E state, Appender<E> appender) {
            assert (state != null);
            this.isIncomplete = isIncomplete;
            this.state = state;
            this.appender = appender;
            this.isValid = true;
        }

        private Object append(Object currentMessage) {
            Object resultMessage = currentMessage != null ? (this.appender != null ? this.appender.append(this.state, currentMessage) : ((Appendable)this.state).append(currentMessage)) : this.state;
            this.state = null;
            this.appender = null;
            this.isValid = false;
            return resultMessage;
        }
    }
}

