/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.async;

import com.sun.enterprise.web.connector.grizzly.AsyncExecutor;
import com.sun.enterprise.web.connector.grizzly.AsyncFilter;
import com.sun.enterprise.web.connector.grizzly.AsyncHandler;
import com.sun.enterprise.web.connector.grizzly.AsyncTask;
import com.sun.enterprise.web.connector.grizzly.ConcurrentQueue;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.async.AsyncProcessorTask;
import java.util.ArrayList;
import java.util.Queue;

public class DefaultAsyncHandler
implements AsyncHandler {
    private Queue<AsyncTask> asyncProcessors = new ConcurrentQueue<AsyncTask>("DefaultAsyncHandler.asyncProcessors");
    private Queue<AsyncTask> interruptedQueue = new ConcurrentQueue<AsyncTask>("DefaultAsyncHandler.interruptedQueue");
    private ArrayList<AsyncFilter> asyncFilters = new ArrayList();
    private String asyncExecutorClassName = "com.sun.enterprise.web.connector.grizzly.async.DefaultAsyncExecutor";

    private AsyncTask newAsyncProcessorTask() {
        AsyncProcessorTask asyncTask = new AsyncProcessorTask();
        asyncTask.setAsyncExecutor(this.newAsyncExecutor(asyncTask));
        return asyncTask;
    }

    private AsyncExecutor newAsyncExecutor(AsyncTask asyncTask) {
        Class<?> className = null;
        AsyncExecutor asyncExecutor = null;
        try {
            className = Class.forName(this.asyncExecutorClassName);
            asyncExecutor = (AsyncExecutor)className.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        if (asyncExecutor != null) {
            asyncExecutor.setAsyncTask(asyncTask);
            asyncExecutor.setAsyncHandler(this);
            for (AsyncFilter l : this.asyncFilters) {
                asyncExecutor.addAsyncFilter(l);
            }
        }
        return asyncExecutor;
    }

    private AsyncTask getAsyncProcessorTask() {
        AsyncTask asyncTask = this.asyncProcessors.poll();
        if (asyncTask == null) {
            asyncTask = this.newAsyncProcessorTask();
        } else {
            asyncTask.recycle();
        }
        return asyncTask;
    }

    public void handle(Task task) {
        boolean wasInterrupted;
        AsyncTask apt = null;
        if (task.getType() == 2) {
            apt = this.getAsyncProcessorTask();
            apt.setProcessorTask((ProcessorTask)task);
            apt.setSelectorThread(task.getSelectorThread());
        }
        if (!(wasInterrupted = this.interruptedQueue.remove(apt)) && apt == null) {
            this.interruptedQueue.remove(task);
        }
        if (apt == null) {
            apt = (AsyncTask)task;
        }
        if (apt != null) {
            apt.execute();
        }
    }

    public void returnTask(AsyncTask asyncTask) {
        this.asyncProcessors.offer(asyncTask);
    }

    public void addToInterruptedQueue(AsyncTask task) {
        this.interruptedQueue.offer(task);
    }

    public void removeFromInterruptedQueue(AsyncTask task) {
        this.interruptedQueue.remove(task);
    }

    public void setAsyncExecutorClassName(String asyncExecutorClassName) {
        this.asyncExecutorClassName = asyncExecutorClassName;
    }

    public String getAsyncExecutorClassName() {
        return this.asyncExecutorClassName;
    }

    public void addAsyncFilter(AsyncFilter asyncFilter) {
        this.asyncFilters.add(asyncFilter);
    }

    public boolean removeAsyncFilter(AsyncFilter asyncFilter) {
        return this.asyncFilters.remove(asyncFilter);
    }
}

