/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.ssl;

import com.sun.enterprise.web.connector.grizzly.DefaultReadTask;
import com.sun.enterprise.web.connector.grizzly.StreamAlgorithm;
import com.sun.enterprise.web.connector.grizzly.WorkerThread;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLByteBufferInputStream;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLProcessorTask;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLSelectorThread;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLUtils;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLWorkerThread;
import com.sun.enterprise.web.connector.grizzly.ssl.SecureOuputBuffer;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLSupport;

public class SSLReadTask
extends DefaultReadTask {
    protected SSLEngine sslEngine = null;
    protected int appBBSize = 20480;
    protected int inputBBSize = 20480;
    protected ByteBuffer inputBB;
    protected ByteBuffer outputBB;
    protected boolean handshake = true;
    protected SSLImplementation sslImplementation;

    public void initialize(StreamAlgorithm algorithm, boolean useDirectByteBuffer, boolean useByteBufferView) {
        this.type = 1;
        this.algorithm = algorithm;
        this.inputStream = new SSLByteBufferInputStream();
        this.useDirectByteBuffer = useDirectByteBuffer;
        this.useByteBufferView = useByteBufferView;
    }

    public void allocateBuffers() {
        ByteBuffer newBB;
        SSLWorkerThread workerThread = (SSLWorkerThread)Thread.currentThread();
        int expectedSize = this.sslEngine.getSession().getPacketBufferSize();
        if (this.inputBBSize < expectedSize) {
            this.inputBBSize = expectedSize;
        }
        if (this.inputBB != null && this.inputBB.capacity() < this.inputBBSize) {
            newBB = ByteBuffer.allocate(this.inputBBSize);
            this.inputBB.flip();
            newBB.put(this.inputBB);
            this.inputBB = newBB;
        } else if (this.inputBB == null && workerThread.getInputBB() != null) {
            this.inputBB = workerThread.getInputBB();
        } else if (this.inputBB == null) {
            this.inputBB = ByteBuffer.allocate(this.inputBBSize);
        }
        this.outputBB = workerThread.getOutputBB() == null ? ByteBuffer.allocate(this.inputBBSize) : workerThread.getOutputBB();
        if (this.byteBuffer == null && workerThread.getByteBuffer() == null) {
            this.byteBuffer = ByteBuffer.allocate(this.inputBBSize * 2);
        } else if (this.byteBuffer == null) {
            this.byteBuffer = workerThread.getByteBuffer();
        }
        expectedSize = this.sslEngine.getSession().getApplicationBufferSize();
        if (expectedSize > this.byteBuffer.capacity()) {
            newBB = ByteBuffer.allocate(expectedSize);
            this.byteBuffer.flip();
            newBB.put(this.byteBuffer);
            this.byteBuffer = newBB;
        }
        workerThread.setInputBB(this.inputBB);
        workerThread.setOutputBB(this.outputBB);
        workerThread.setByteBuffer(this.byteBuffer);
        this.outputBB.position(0);
        this.outputBB.limit(0);
        workerThread.setSSLEngine(this.sslEngine);
    }

    public void registerKey() {
        this.key.attach(this.sslEngine);
        super.registerKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTask() throws IOException {
        boolean keepAlive;
        IOException exception;
        int count;
        block13: {
            block14: {
                count = 0;
                exception = null;
                keepAlive = false;
                SSLWorkerThread workerThread = (SSLWorkerThread)Thread.currentThread();
                SocketChannel socketChannel = (SocketChannel)this.key.channel();
                try {
                    try {
                        this.allocateBuffers();
                        if (!this.doHandshake(SSLUtils.getReadTimeout())) {
                            keepAlive = false;
                            count = -1;
                            break block13;
                        }
                        if (!this.handshake) {
                            count = this.doRead(this.inputBB);
                            if (count == -1) {
                                keepAlive = false;
                                Object var10_6 = null;
                                break block14;
                            }
                        } else {
                            this.handshake = false;
                        }
                        try {
                            this.inputStream.setByteBuffer(this.byteBuffer);
                            keepAlive = this.process();
                        }
                        catch (IOException ex) {
                            keepAlive = false;
                        }
                        break block13;
                    }
                    catch (IOException ex) {
                        exception = ex;
                        keepAlive = false;
                        Object var10_8 = null;
                        this.manageKeepAlive(keepAlive, count, exception);
                        return;
                    }
                    catch (Throwable ex) {
                        Logger logger = SSLSelectorThread.logger();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "doRead", ex);
                        }
                        count = -1;
                        keepAlive = false;
                        Object var10_9 = null;
                        this.manageKeepAlive(keepAlive, count, exception);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    this.manageKeepAlive(keepAlive, count, exception);
                    throw throwable;
                }
            }
            this.manageKeepAlive(keepAlive, count, exception);
            return;
        }
        Object var10_7 = null;
        this.manageKeepAlive(keepAlive, count, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doRead(ByteBuffer inputBB) {
        int workerThread222;
        int count = -1;
        try {
            try {
                count = ((SocketChannel)this.key.channel()).read(inputBB);
                if (count != -1) {
                    this.byteBuffer = SSLUtils.unwrapAll(this.byteBuffer, inputBB, this.sslEngine);
                    SSLWorkerThread workerThread222 = (SSLWorkerThread)Thread.currentThread();
                    workerThread222.setByteBuffer(this.byteBuffer);
                    workerThread222.setInputBB(inputBB);
                }
                workerThread222 = count;
                Object var6_6 = null;
                if (count != -1) return workerThread222;
            }
            catch (IOException ex) {
                int n = -1;
                Object var6_7 = null;
                if (count != -1) return n;
                try {
                    this.sslEngine.closeInbound();
                    return n;
                }
                catch (SSLException ex2) {
                    // empty catch block
                }
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (count != -1) throw throwable;
            try {}
            catch (SSLException ex2) {
                throw throwable;
            }
            this.sslEngine.closeInbound();
            throw throwable;
        }
        try {}
        catch (SSLException ex2) {
            // empty catch block
            return workerThread222;
        }
        this.sslEngine.closeInbound();
        return workerThread222;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doHandshake(int timeout) throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        boolean OK = true;
        SSLWorkerThread workerThread = (SSLWorkerThread)Thread.currentThread();
        try {
            try {
                if (this.handshake) {
                    this.byteBuffer = SSLUtils.doHandshake(this.key, this.byteBuffer, this.inputBB, this.outputBB, this.sslEngine, handshakeStatus, timeout);
                    if (this.doRead(this.inputBB) == -1) {
                        throw new EOFException();
                    }
                }
                Object var8_5 = null;
                workerThread.setOutputBB(this.outputBB);
            }
            catch (EOFException ex) {
                Logger logger = SSLSelectorThread.logger();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "doHandshake", ex);
                }
                OK = false;
                Object var8_6 = null;
                workerThread.setOutputBB(this.outputBB);
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            workerThread.setOutputBB(this.outputBB);
            throw throwable;
        }
        return OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] doPeerCertificateChain(boolean needClientAuth) throws IOException {
        Certificate[] certs;
        Logger logger;
        block19: {
            SSLWorkerThread workerThread;
            block17: {
                logger = SSLSelectorThread.logger();
                workerThread = (SSLWorkerThread)Thread.currentThread();
                certs = null;
                try {
                    certs = this.sslEngine.getSession().getPeerCertificates();
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.FINE)) break block17;
                    logger.log(Level.FINE, "Error getting client certs", t);
                }
            }
            if (certs == null && needClientAuth) {
                this.sslEngine.getSession().invalidate();
                this.sslEngine.setNeedClientAuth(true);
                this.sslEngine.beginHandshake();
                ByteBuffer origBB = workerThread.getByteBuffer();
                this.outputBB = workerThread.getOutputBB();
                this.byteBuffer = origBB.position() != origBB.limit() ? ByteBuffer.allocate(origBB.capacity()) : origBB;
                this.byteBuffer.clear();
                this.outputBB.position(0);
                this.outputBB.limit(0);
                this.handshake = true;
                try {
                    try {
                        this.doHandshake(0);
                    }
                    catch (Throwable ex) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Error during handshake", ex);
                        }
                        Object[] objectArray = null;
                        Object var9_8 = null;
                        this.byteBuffer = origBB;
                        this.handshake = false;
                        workerThread.setByteBuffer(this.byteBuffer);
                        this.inputStream.setByteBuffer(this.byteBuffer);
                        this.byteBuffer.clear();
                        return objectArray;
                    }
                    Object var9_7 = null;
                    this.byteBuffer = origBB;
                    this.handshake = false;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    this.byteBuffer = origBB;
                    this.handshake = false;
                    workerThread.setByteBuffer(this.byteBuffer);
                    this.inputStream.setByteBuffer(this.byteBuffer);
                    this.byteBuffer.clear();
                    throw throwable;
                }
                workerThread.setByteBuffer(this.byteBuffer);
                this.inputStream.setByteBuffer(this.byteBuffer);
                this.byteBuffer.clear();
                try {
                    certs = this.sslEngine.getSession().getPeerCertificates();
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.FINE)) break block19;
                    logger.log(Level.FINE, "Error getting client certs", t);
                }
            }
        }
        if (certs == null) {
            return null;
        }
        Object[] x509Certs = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            if (certs[i] instanceof X509Certificate) {
                x509Certs[i] = (X509Certificate)certs[i];
            } else {
                try {
                    byte[] buffer = certs[i].getEncoded();
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Error translating cert " + certs[i], ex);
                    return null;
                }
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "Cert #" + i + " = " + x509Certs[i]);
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    protected void configureProcessorTask() {
        super.configureProcessorTask();
        SSLSupport sslSupport = this.sslImplementation.getSSLSupport(this.sslEngine);
        ((SSLProcessorTask)this.processorTask).setSSLSupport(sslSupport);
        ((SSLProcessorTask)this.processorTask).setSslReadTask(this);
        SecureOuputBuffer secureOutputBuffer = ((SSLProcessorTask)this.processorTask).getSecureOutputBuffer();
        if (secureOutputBuffer == null) {
            this.processorTask.initialize();
            secureOutputBuffer = ((SSLProcessorTask)this.processorTask).getSecureOutputBuffer();
        }
        secureOutputBuffer.setSSLEngine(this.sslEngine);
        secureOutputBuffer.setOutputBB(this.outputBB);
    }

    public void detachProcessor() {
        if (this.processorTask != null) {
            ((SSLProcessorTask)this.processorTask).setSSLSupport(null);
            ((SSLProcessorTask)this.processorTask).setSslReadTask(null);
            SecureOuputBuffer secureOutputBuffer = ((SSLProcessorTask)this.processorTask).getSecureOutputBuffer();
            secureOutputBuffer.setSSLEngine(null);
            secureOutputBuffer.setOutputBB(null);
        }
        super.detachProcessor();
    }

    protected boolean process() throws IOException {
        boolean keepAlive = false;
        SocketChannel socketChannel = (SocketChannel)this.key.channel();
        Socket socket = socketChannel.socket();
        this.algorithm.setSocketChannel(socketChannel);
        this.inputStream.setSelectionKey(this.key);
        if (this.processorTask == null) {
            this.attachProcessor(this.selectorThread.getProcessorTask());
        }
        if (this.algorithm.parse(this.byteBuffer)) {
            return this.executeProcessorTask();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recycle() {
        block8: {
            if (this.byteBuffer != null) {
                try {
                    try {
                        WorkerThread workerThread = (WorkerThread)((Object)Thread.currentThread());
                        workerThread.setByteBuffer(this.byteBuffer);
                    }
                    catch (ClassCastException ex) {
                        Logger logger = SSLSelectorThread.logger();
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "recycle", ex);
                        }
                        Object var4_4 = null;
                        this.byteBuffer = this.algorithm.postParse(this.byteBuffer);
                        this.byteBuffer.clear();
                        break block8;
                    }
                    Object var4_3 = null;
                    this.byteBuffer = this.algorithm.postParse(this.byteBuffer);
                    this.byteBuffer.clear();
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.byteBuffer = this.algorithm.postParse(this.byteBuffer);
                    this.byteBuffer.clear();
                    throw throwable;
                }
            }
        }
        this.handshake = true;
        this.inputStream.recycle();
        this.algorithm.recycle();
        this.key = null;
        this.inputStream.setSelectionKey(null);
        if (this.inputBB != null) {
            this.inputBB.clear();
        }
        if (this.outputBB != null) {
            this.outputBB.clear();
            this.outputBB.position(0);
            this.outputBB.limit(0);
        }
        this.inputBB = null;
        this.outputBB = null;
        this.byteBuffer = null;
        this.sslEngine = null;
    }

    public void setSSLImplementation(SSLImplementation sslImplementation) {
        this.sslImplementation = sslImplementation;
    }

    public void setHandshake(boolean handshake) {
        this.handshake = handshake;
    }

    public boolean getHandshake() {
        return this.handshake;
    }

    public void setSSLEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    public SSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    public ByteBuffer getInputBB() {
        return this.inputBB;
    }

    public void setInputBB(ByteBuffer inputBB) {
        this.inputBB = inputBB;
    }

    public ByteBuffer getOutputBB() {
        return this.outputBB;
    }

    public void setOutputBB(ByteBuffer outputBB) {
        this.outputBB = outputBB;
    }
}

