/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.ssl;

import com.sun.enterprise.web.connector.grizzly.MultiSelectorThread;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLSelectorThread;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.logging.Level;

public class SSLSelectorReadThread
extends SSLSelectorThread
implements MultiSelectorThread {
    ArrayList<SocketChannel> channels = new ArrayList();
    public static int countName;

    public synchronized void addChannel(SocketChannel channel) throws IOException, ClosedChannelException {
        this.channels.add(channel);
        this.getSelector().wakeup();
    }

    private synchronized void registerNewChannels() throws IOException {
        int size = this.channels.size();
        for (int i = 0; i < size; ++i) {
            SocketChannel sc = this.channels.get(i);
            sc.configureBlocking(false);
            try {
                SelectionKey readKey = sc.register(this.getSelector(), 1);
                this.setSocketOptions(((SocketChannel)readKey.channel()).socket());
                continue;
            }
            catch (ClosedChannelException cce) {
                // empty catch block
            }
        }
        this.channels.clear();
    }

    public void initEndpoint() throws IOException, InstantiationException {
        this.setName("SSLSelectorReaderThread-" + this.getPort());
        this.initAlgorithm();
    }

    public void startEndpoint() throws IOException, InstantiationException {
        this.setRunning(true);
        while (this.isRunning()) {
            try {
                if (this.getSelector() == null) {
                    this.setSelector(Selector.open());
                }
                this.registerNewChannels();
                this.doSelect();
            }
            catch (Throwable t) {
                logger.log(Level.FINE, "selectorThread.errorOnRequest", t);
            }
        }
    }

    public int getCurrentBusyProcessorThreads() {
        return this.getProcessorPipeline().getCurrentThreadsBusy();
    }
}

