/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.policy;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.transport.tcp.TcpTransportFeature;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.SimpleAssertion;
import com.sun.xml.ws.policy.jaxws.spi.PolicyMapConfigurator;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.subject.WsdlBindingSubject;
import com.sun.xml.ws.transport.tcp.wsit.TCPConstants;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class TCPTransportPolicyMapConfigurator
implements PolicyMapConfigurator {
    private static final Logger LOGGER = Logger.getLogger(TCPTransportPolicyMapConfigurator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PolicySubject> update(PolicyMap policyMap, SEIModel model, WSBinding wsBinding) throws PolicyException {
        LinkedList<PolicySubject> subjects = new LinkedList<PolicySubject>();
        try {
            LOGGER.entering(new Object[]{policyMap, model, wsBinding});
            this.updateTCPTransportSettings(subjects, wsBinding, model, policyMap);
            LinkedList<PolicySubject> linkedList = subjects;
            return linkedList;
        }
        finally {
            LOGGER.exiting(subjects);
        }
    }

    private void updateTCPTransportSettings(Collection<PolicySubject> subjects, WSBinding wsBinding, SEIModel model, PolicyMap policyMap) throws PolicyException, IllegalArgumentException {
        Policy existingPolicy;
        TcpTransportFeature tcpTransportFeature = (TcpTransportFeature)wsBinding.getFeature(TcpTransportFeature.class);
        if (tcpTransportFeature == null || !tcpTransportFeature.isEnabled()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Make TCP transport feature enabled on service '%s', port '%s'", model.getServiceQName(), model.getPortName()));
        }
        PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey((QName)model.getServiceQName(), (QName)model.getPortName());
        Policy policy = existingPolicy = policyMap != null ? policyMap.getEndpointEffectivePolicy(endpointKey) : null;
        if (existingPolicy == null || !existingPolicy.contains(TCPConstants.TCPTRANSPORT_POLICY_ASSERTION)) {
            Policy tcpTransportPolicy = this.createTCPTransportPolicy(model.getBoundPortTypeName());
            WsdlBindingSubject wsdlSubject = WsdlBindingSubject.createBindingSubject((QName)model.getBoundPortTypeName());
            PolicySubject subject = new PolicySubject((Object)wsdlSubject, tcpTransportPolicy);
            subjects.add(subject);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Added TCP transport policy with ID '%s' to binding element '%s'", tcpTransportPolicy.getIdOrName(), model.getBoundPortTypeName()));
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Make TCP transport assertion is already present in the endpoint policy");
        }
    }

    private Policy createTCPTransportPolicy(QName bindingName) {
        return Policy.createPolicy(null, (String)(bindingName.getLocalPart() + "_TCPTransport_Policy"), Arrays.asList(AssertionSet.createAssertionSet(Arrays.asList(new PolicyAssertion[]{new TCPTransportAssertion()}))));
    }

    public static class TCPTransportAssertion
    extends SimpleAssertion {
        public TCPTransportAssertion() {
            this(AssertionData.createAssertionData((QName)TCPConstants.TCPTRANSPORT_POLICY_ASSERTION), null);
        }

        public TCPTransportAssertion(AssertionData data, Collection<? extends PolicyAssertion> assertionParameters) {
            super(data, assertionParameters);
        }
    }
}

