/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.client;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.client.ClientTransportException;
import com.sun.xml.ws.transport.tcp.client.TCPClientTransport;
import com.sun.xml.ws.transport.tcp.client.WSConnectionManager;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.servicechannel.ServiceChannelException;
import com.sun.xml.ws.transport.tcp.util.ChannelContext;
import com.sun.xml.ws.transport.tcp.util.VersionMismatchException;
import com.sun.xml.ws.transport.tcp.util.WSTCPException;
import com.sun.xml.ws.transport.tcp.util.WSTCPURI;
import jakarta.xml.ws.WebServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPTransportPipe
extends AbstractTubeImpl {
    private static final Logger logger = Logger.getLogger("com.sun.metro.transport.tcp.client");
    protected TCPClientTransport clientTransport = new TCPClientTransport();
    protected final Codec defaultCodec;
    protected final WSBinding wsBinding;
    protected final WSService wsService;
    protected final int customTCPPort;

    public TCPTransportPipe(ClientTubeAssemblerContext context) {
        this(context, -1);
    }

    public TCPTransportPipe(ClientTubeAssemblerContext context, int customTCPPort) {
        this(context.getService(), context.getBinding(), context.getCodec(), customTCPPort);
    }

    protected TCPTransportPipe(WSService wsService, WSBinding wsBinding, Codec defaultCodec, int customTCPPort) {
        this.wsService = wsService;
        this.wsBinding = wsBinding;
        this.defaultCodec = defaultCodec;
        this.customTCPPort = customTCPPort;
    }

    protected TCPTransportPipe(TCPTransportPipe that, TubeCloner cloner) {
        this(that.wsService, that.wsBinding, that.defaultCodec.copy(), that.customTCPPort);
        cloner.add((Tube)that, (Tube)this);
    }

    public void preDestroy() {
        if (this.clientTransport != null && this.clientTransport.getConnectionContext() != null) {
            WSConnectionManager.getInstance().closeChannel(this.clientTransport.getConnectionContext());
        }
    }

    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new TCPTransportPipe(this, cloner);
    }

    public NextAction processRequest(Packet request) {
        return this.doReturnWith(this.process(request));
    }

    public NextAction processResponse(Packet response) {
        throw new IllegalStateException("TCPTransportPipe's processResponse shouldn't be called.");
    }

    public NextAction processException(Throwable t) {
        throw new IllegalStateException("TCPTransportPipe's processException shouldn't be called.");
    }

    public Packet process(Packet packet) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1010_TCP_TP_PROCESS_ENTER(packet.endpointAddress));
        }
        ChannelContext channelContext = null;
        ClientTransportException failure = null;
        WSConnectionManager wsConnectionManager = WSConnectionManager.getInstance();
        int retryNum = 0;
        do {
            try {
                this.setupClientTransport(wsConnectionManager, packet.endpointAddress.getURI());
                channelContext = this.clientTransport.getConnectionContext();
                wsConnectionManager.lockConnection(channelContext.getConnectionSession());
                Codec codec = channelContext.getCodec();
                ContentType ct = codec.getStaticContentType(packet);
                this.clientTransport.setContentType(ct.getContentType());
                this.writeTransportSOAPActionHeaderIfRequired(channelContext, ct, packet);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, MessagesMessages.WSTCP_1013_TCP_TP_PROCESS_ENCODE(ct.getContentType()));
                }
                codec.encode(packet, this.clientTransport.openOutputStream());
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, MessagesMessages.WSTCP_1014_TCP_TP_PROCESS_SEND());
                }
                this.clientTransport.send();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, MessagesMessages.WSTCP_1015_TCP_TP_PROCESS_OPEN_PREPARE_READING());
                }
                InputStream replyInputStream = this.clientTransport.openInputStream();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, MessagesMessages.WSTCP_1016_TCP_TP_PROCESS_OPEN_PROCESS_READING(this.clientTransport.getStatus(), this.clientTransport.getContentType()));
                }
                if (this.clientTransport.getStatus() != 2) {
                    Packet reply = packet.createClientResponse(null);
                    if (this.clientTransport.getStatus() != 1) {
                        String contentTypeStr = this.clientTransport.getContentType();
                        codec.decode(replyInputStream, contentTypeStr, reply);
                    } else {
                        this.releaseSession(channelContext);
                    }
                    return reply;
                }
                logger.log(Level.SEVERE, MessagesMessages.WSTCP_0016_ERROR_WS_EXECUTION_ON_SERVER(this.clientTransport.getError()));
                throw new WSTCPException(this.clientTransport.getError());
            }
            catch (ClientTransportException e) {
                this.abortSession(channelContext);
                failure = e;
            }
            catch (WSTCPException e) {
                if (e.getError().isCritical()) {
                    this.abortSession(channelContext);
                } else {
                    this.releaseSession(channelContext);
                }
                failure = new WebServiceException(MessagesMessages.WSTCP_0016_ERROR_WS_EXECUTION_ON_SERVER(e.getError()), (Throwable)e);
            }
            catch (IOException e) {
                this.abortSession(channelContext);
                failure = new WebServiceException(MessagesMessages.WSTCP_0017_ERROR_WS_EXECUTION_ON_CLIENT(), (Throwable)e);
            }
            catch (ServiceChannelException e) {
                this.releaseSession(channelContext);
                retryNum = 6;
                failure = new WebServiceException(MessagesMessages.WSTCP_0016_ERROR_WS_EXECUTION_ON_SERVER((Object)((Object)e.getFaultInfo().getErrorCode()) + ":" + e.getMessage()), (Throwable)e);
            }
            catch (Exception e) {
                this.abortSession(channelContext);
                retryNum = 6;
                failure = new WebServiceException(MessagesMessages.WSTCP_0017_ERROR_WS_EXECUTION_ON_CLIENT(), (Throwable)e);
            }
            if (!logger.isLoggable(Level.FINE) || !TCPTransportPipe.canRetry(retryNum + 1)) continue;
            logger.log(Level.FINE, MessagesMessages.WSTCP_0012_SEND_RETRY(retryNum), failure);
        } while (TCPTransportPipe.canRetry(++retryNum));
        assert (failure != null);
        logger.log(Level.SEVERE, MessagesMessages.WSTCP_0001_MESSAGE_PROCESS_FAILED(), failure);
        throw failure;
    }

    protected void writeTransportSOAPActionHeaderIfRequired(ChannelContext channelContext, ContentType ct, Packet packet) {
        String soapActionTransportHeader = this.getSOAPAction(ct.getSOAPActionHeader(), packet);
        if (soapActionTransportHeader != null) {
            try {
                int transportSoapActionParamId = channelContext.encodeParam("SOAPAction");
                channelContext.getConnection().setContentProperty(transportSoapActionParamId, soapActionTransportHeader);
            }
            catch (WSTCPException ex) {
                logger.log(Level.WARNING, MessagesMessages.WSTCP_0032_UNEXPECTED_TRANSPORT_SOAP_ACTION(), ex);
            }
        }
    }

    protected void abortSession(ChannelContext channelContext) {
        if (channelContext != null) {
            WSConnectionManager.getInstance().abortConnection(channelContext.getConnectionSession());
        }
    }

    protected void releaseSession(ChannelContext channelContext) {
        if (channelContext != null) {
            WSConnectionManager.getInstance().freeConnection(channelContext.getConnectionSession());
        }
    }

    @NotNull
    private void setupClientTransport(@NotNull WSConnectionManager wsConnectionManager, @NotNull URI uri) throws InterruptedException, IOException, ServiceChannelException, VersionMismatchException {
        WSTCPURI tcpURI = WSTCPURI.parse(uri);
        if (tcpURI == null) {
            throw new WebServiceException(MessagesMessages.WSTCP_0005_INVALID_EP_URL(uri.toString()));
        }
        tcpURI.setCustomPort(this.customTCPPort);
        ChannelContext channelContext = wsConnectionManager.openChannel(tcpURI, this.wsService, this.wsBinding, this.defaultCodec);
        this.clientTransport.setup(channelContext);
    }

    @Nullable
    private String getSOAPAction(String soapAction, Packet packet) {
        boolean use;
        Boolean useAction = (Boolean)packet.invocationProperties.get("jakarta.xml.ws.soap.http.soapaction.use");
        String sAction = null;
        boolean bl = use = useAction != null ? useAction : false;
        if (use) {
            sAction = packet.soapAction;
        }
        if (sAction != null) {
            return sAction;
        }
        return soapAction;
    }

    private static boolean canRetry(int retryNum) {
        return retryNum <= 5;
    }
}

