/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.runtime.dev;

import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.api.security.secconv.WSSecureConversationRuntimeException;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.commons.ha.StickyKey;
import com.sun.xml.ws.runtime.dev.Session;
import com.sun.xml.ws.runtime.dev.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManagerImpl
extends SessionManager {
    private Map<String, Session> sessionMap = new HashMap<String, Session>();
    private Map<String, IssuedTokenContext> issuedTokenContextMap = new HashMap<String, IssuedTokenContext>();
    private Map<String, SecurityContextTokenInfo> securityContextTokenInfoMap = new HashMap<String, SecurityContextTokenInfo>();
    private final BackingStore<StickyKey, SecurityContextTokenInfo> sctBs;

    public SessionManagerImpl(WSEndpoint endpoint) {
        BackingStoreFactory bsFactory = HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY);
        this.sctBs = HighAvailabilityProvider.INSTANCE.createBackingStore(bsFactory, endpoint.getServiceName() + ":" + endpoint.getPortName() + "_SCT_BS", StickyKey.class, SecurityContextTokenInfo.class);
    }

    @Override
    public Session getSession(String key) {
        Session session = this.sessionMap.get(key);
        if (session == null && HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) {
            SecurityContextTokenInfo sctInfo = (SecurityContextTokenInfo)HighAvailabilityProvider.loadFrom(this.sctBs, (Serializable)new StickyKey((Serializable)((Object)key)), null);
            session = new Session(this, key, null);
            session.setSecurityInfo(sctInfo);
            this.sessionMap.put(key, session);
        }
        return session;
    }

    @Override
    public Set<String> keys() {
        return this.sessionMap.keySet();
    }

    @Override
    protected Collection<Session> sessions() {
        return this.sessionMap.values();
    }

    @Override
    public void terminateSession(String key) {
        this.sessionMap.remove(key);
        if (HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) {
            HighAvailabilityProvider.removeFrom(this.sctBs, (Serializable)new StickyKey((Serializable)((Object)key)));
        }
    }

    @Override
    public Session createSession(String key, Class clasz) {
        Session sess;
        try {
            sess = new Session(this, key, clasz.newInstance());
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException ee) {
            return null;
        }
        this.sessionMap.put(key, sess);
        return sess;
    }

    @Override
    public Session createSession(String key, Object obj) {
        Session sess = new Session(this, key, obj);
        this.sessionMap.put(key, sess);
        SecurityContextTokenInfo sctInfo = sess.getSecurityInfo();
        if (sctInfo != null && HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) {
            HaInfo haInfo = HaContext.currentHaInfo();
            if (haInfo != null) {
                HighAvailabilityProvider.saveTo(this.sctBs, (Serializable)new StickyKey((Serializable)((Object)key), haInfo.getKey()), (Serializable)sctInfo, (boolean)true);
            } else {
                StickyKey stickyKey = new StickyKey((Serializable)((Object)key));
                String replicaId = HighAvailabilityProvider.saveTo(this.sctBs, (Serializable)stickyKey, (Serializable)sctInfo, (boolean)true);
                HaContext.updateHaInfo((HaInfo)new HaInfo(stickyKey.getHashKey(), replicaId, false));
            }
        }
        return sess;
    }

    @Override
    public Session createSession(String key) {
        return this.createSession(key, Collections.synchronizedMap(new HashMap()));
    }

    @Override
    public void saveSession(String key) {
    }

    @Override
    public IssuedTokenContext getSecurityContext(String key, boolean checkExpiry) {
        IssuedTokenContext ctx = this.issuedTokenContextMap.get(key);
        if (ctx == null) {
            Session session = this.getSession(key);
            if (session != null) {
                SecurityContextTokenInfo sctInfo = session.getSecurityInfo();
                ctx = sctInfo.getIssuedTokenContext();
                this.addSecurityContext(key, ctx);
            } else {
                throw new WebServiceException("Could not locate SecureConversation session for Id:" + key);
            }
        }
        if (ctx != null && checkExpiry) {
            GregorianCalendar c = new GregorianCalendar();
            long offset = c.get(15);
            if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
                offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
            }
            long beforeTime = c.getTimeInMillis();
            long currentTime = beforeTime - offset;
            c.setTimeInMillis(currentTime);
            Date currentTimeInDateFormat = c.getTime();
            if (!currentTimeInDateFormat.after(ctx.getCreationTime()) || !currentTimeInDateFormat.before(ctx.getExpirationTime())) {
                throw new WSSecureConversationRuntimeException(new QName("RenewNeeded"), "The provided context token has expired");
            }
        }
        if (((SecurityContextToken)ctx.getSecurityToken()).getInstance() != null) {
            String sctInfoKey = ((SecurityContextToken)ctx.getSecurityToken()).getIdentifier().toString() + "_" + ((SecurityContextToken)ctx.getSecurityToken()).getInstance();
            ctx.setSecurityContextTokenInfo(this.securityContextTokenInfoMap.get(sctInfoKey));
        }
        return ctx;
    }

    @Override
    public void addSecurityContext(String key, IssuedTokenContext itctx) {
        this.issuedTokenContextMap.put(key, itctx);
        if (((SecurityContextToken)itctx.getSecurityToken()).getInstance() != null) {
            String sctInfoKey = ((SecurityContextToken)itctx.getSecurityToken()).getIdentifier().toString() + "_" + ((SecurityContextToken)itctx.getSecurityToken()).getInstance();
            this.securityContextTokenInfoMap.put(sctInfoKey, itctx.getSecurityContextTokenInfo());
            itctx.setSecurityContextTokenInfo(null);
        }
    }
}

