/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.metro.helidon;

import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.resources.WsservletMessages;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.RequestHeaders;
import io.helidon.webserver.ServerRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

class WSUtils {
    WSUtils() {
    }

    static CharSequence writeWebServicesHtmlPage(URI baseUri, List<BoundEndpoint> endpoints) {
        StringBuilder out = new StringBuilder();
        out.append("<html>");
        out.append("<head><title>");
        out.append(WsservletMessages.SERVLET_HTML_TITLE());
        out.append("</title></head>");
        out.append("<body>");
        out.append(WsservletMessages.SERVLET_HTML_TITLE_2());
        if (endpoints.isEmpty()) {
            out.append(WsservletMessages.SERVLET_HTML_NO_INFO_AVAILABLE());
        } else {
            out.append("<table width='100%' border='1'>");
            out.append("<tr>");
            out.append("<td>");
            out.append(WsservletMessages.SERVLET_HTML_COLUMN_HEADER_PORT_NAME());
            out.append("</td>");
            out.append("<td>");
            out.append(WsservletMessages.SERVLET_HTML_COLUMN_HEADER_INFORMATION());
            out.append("</td>");
            out.append("</tr>");
            for (BoundEndpoint a : endpoints) {
                String endpointAddress = a.getAddress(baseUri.toString()).toString();
                out.append("<tr>");
                out.append("<td>");
                out.append(WsservletMessages.SERVLET_HTML_ENDPOINT_TABLE((Object)a.getEndpoint().getServiceName(), (Object)a.getEndpoint().getPortName()));
                out.append("</td>");
                out.append("<td>");
                out.append(WsservletMessages.SERVLET_HTML_INFORMATION_TABLE((Object)endpointAddress, (Object)a.getEndpoint().getImplementationClass().getName()));
                out.append("</td>");
                out.append("</tr>");
            }
            out.append("</table>");
        }
        out.append("</body>");
        out.append("</html>");
        return out;
    }

    static URI getBaseUri(ServerRequest req) {
        try {
            return new URI(WSUtils.getBaseAddress(req));
        }
        catch (URISyntaxException e) {
            throw new HttpException("Unable to parse request URL", (Http.ResponseStatus)Http.Status.BAD_REQUEST_400, (Throwable)e);
        }
    }

    static String getBaseAddress(ServerRequest req) {
        StringBuilder buf = new StringBuilder();
        RequestHeaders headers = req.headers();
        String protocol = headers.first("X-Forwarded-Proto").orElse(req.isSecure() ? "https" : "http");
        String host = headers.first("X-Forwarded-Host").orElse((String)((Object)headers.first("Host").orElse(req.localAddress() + ":" + req.localPort())));
        buf.append(protocol);
        buf.append("://");
        buf.append(host);
        buf.append(WSUtils.basePath(req.path()));
        return buf.toString();
    }

    private static String basePath(HttpRequest.Path path) {
        String reqPath = path.toString();
        String absPath = path.absolute().toString();
        String basePath = absPath.substring(0, absPath.length() - reqPath.length() + 1);
        return basePath.endsWith("/") ? basePath.substring(0, basePath.length() - 1) : basePath;
    }
}

