/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.metro.helidon;

import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.ResourceLoader;
import com.sun.xml.ws.transport.http.client.HttpTransportPipe;
import io.helidon.common.configurable.ServerThreadPoolSupplier;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.config.Config;
import io.helidon.webserver.Handler;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.metro.helidon.HelidonAdapter;
import org.eclipse.metro.helidon.HelidonAdapterList;
import org.eclipse.metro.helidon.HelidonContainer;
import org.eclipse.metro.helidon.HelidonResourceLoader;
import org.eclipse.metro.helidon.WSUtils;

public class MetroSupport
implements Service {
    private static final Logger LOGGER = Logger.getLogger(MetroSupport.class.getName());
    private static final AtomicReference<ExecutorService> DEFAULT_THREAD_POOL = new AtomicReference();
    private final ExecutorService service;
    private final HelidonContainer container;
    private final List<HelidonAdapter> adapterList;
    private final boolean publishStatusPage;

    private MetroSupport(Builder builder) {
        this.publishStatusPage = builder.publishStatusPage;
        HttpAdapter.setPublishStatus((boolean)false);
        HttpAdapter.setDump((boolean)builder.dumpService);
        HttpTransportPipe.setDump((boolean)builder.dumpClient);
        HttpAdapter.setDumpTreshold((int)builder.dumpTreshold);
        List<HelidonAdapter> e = Collections.EMPTY_LIST;
        this.container = new HelidonContainer(builder.webContext);
        try {
            e = this.parseEndpoints(builder.dd, new HelidonResourceLoader(builder.catalog), this.container);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, null, ioe);
        }
        this.adapterList = e;
        if (this.adapterList.isEmpty()) {
            LOGGER.warning("No XML Web Services were recognized.");
        }
        this.service = Contexts.wrap((ExecutorService)MetroSupport.getDefaultThreadPool(null));
    }

    public void update(Routing.Rules rules) {
        rules.get("/", new Handler[]{this::publishStatusPage});
        for (HelidonAdapter ha : this.adapterList) {
            rules.any(ha.getServiceContextPath(), new Handler[]{new MetroHandler(ha)});
        }
    }

    private void publishStatusPage(ServerRequest req, ServerResponse res) {
        if (!this.publishStatusPage) {
            throw new HttpException("Listing available web services is forbidden", (Http.ResponseStatus)Http.Status.FORBIDDEN_403);
        }
        res.status((Http.ResponseStatus)Http.Status.OK_200);
        res.headers().contentType(MediaType.TEXT_HTML.withCharset(StandardCharsets.UTF_8.name()));
        res.send((Object)WSUtils.writeWebServicesHtmlPage(WSUtils.getBaseUri(req), this.container.getBoundEndpoints()));
    }

    private List<HelidonAdapter> parseEndpoints(String dd, ResourceLoader loader, Container container) throws IOException {
        DeploymentDescriptorParser parser = new DeploymentDescriptorParser(Thread.currentThread().getContextClassLoader(), loader, container, (DeploymentDescriptorParser.AdapterFactory)new HelidonAdapterList());
        URL cfg = loader.getResource(dd);
        try (InputStream is = cfg.openStream();){
            List list = parser.parse(cfg.toExternalForm(), is);
            return list;
        }
    }

    private static synchronized ExecutorService getDefaultThreadPool(Config config) {
        if (DEFAULT_THREAD_POOL.get() == null) {
            DEFAULT_THREAD_POOL.set(ServerThreadPoolSupplier.builder().name("server").build().get());
        }
        return DEFAULT_THREAD_POOL.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MetroSupport create() {
        return MetroSupport.builder().build();
    }

    public static MetroSupport create(Config config) {
        return MetroSupport.builder().config(config).build();
    }

    private class MetroHandler
    implements Handler {
        final HelidonAdapter adapter;

        MetroHandler(HelidonAdapter ha) {
            this.adapter = ha;
            LOGGER.log(Level.INFO, "Published endpoint: {0} on {1}", new Object[]{this.adapter.getName(), this.adapter.urlPattern});
        }

        public void accept(ServerRequest req, ServerResponse res) {
            Context parent = (Context)Contexts.context().orElseThrow(() -> new IllegalStateException("Context must be propagated from server"));
            Context metroContext = Context.create((Context)parent);
            Object runInContext = Contexts.runInContext((Context)metroContext, () -> this.doAccept(req, res));
        }

        private Object doAccept(ServerRequest req, ServerResponse res) {
            MetroSupport.this.service.execute(() -> this.adapter.handle(req, res));
            return null;
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<MetroSupport> {
        private String dd = "sun-jaxws.xml";
        private String wsdlRoot = "WEB-INF/wsdl";
        private String catalog = "metro-catalog.xml";
        private String webContext = "";
        private boolean publishStatusPage = true;
        private boolean dumpClient = false;
        private boolean dumpService = false;
        private int dumpTreshold = 4096;

        private Builder() {
        }

        public Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder config(Config config) {
            config.get("catalog").asString().ifPresent(this::catalog);
            config.get("descriptor").asString().ifPresent(this::descriptor);
            config.get("dump").asString().ifPresent(value -> {
                switch (value) {
                    case "service": {
                        this.dumpService(true);
                        break;
                    }
                    case "client": {
                        this.dumpClient(true);
                        break;
                    }
                    case "all": {
                        this.dumpClient(true);
                        this.dumpService(true);
                        break;
                    }
                    case "none": {
                        this.dumpClient(false);
                        this.dumpService(false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("(all|none|client|service) allowed but was: ''{0}'", value));
                    }
                }
            });
            config.get("dump-treshold").asInt().ifPresent(this::dumpTreshold);
            config.get("status-page").asBoolean().ifPresent(this::publishStatusPage);
            config.get("web-context").asString().ifPresent(this::webContext);
            return this;
        }

        public Builder descriptor(String descriptor) {
            this.dd = descriptor;
            return this;
        }

        public Builder dumpClient(boolean enabled) {
            this.dumpClient = enabled;
            return this;
        }

        public Builder dumpService(boolean enabled) {
            this.dumpService = enabled;
            return this;
        }

        public Builder dumpTreshold(int treshold) {
            if (treshold < 0) {
                throw new IllegalArgumentException("'treshold' must be positive number, was '" + treshold + "'");
            }
            this.dumpTreshold = treshold;
            return this;
        }

        public Builder publishStatusPage(boolean enabled) {
            this.publishStatusPage = enabled;
            return this;
        }

        public Builder webContext(String path) {
            this.webContext = path.startsWith("/") ? path : "/" + path;
            return this;
        }

        public MetroSupport build() {
            return new MetroSupport(this);
        }
    }
}

