/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.metro.helidon;

import com.sun.xml.ws.transport.http.ResourceLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class HelidonResourceLoader
implements ResourceLoader {
    private final String catalog;
    private static final String DD_DIR = "WEB-INF/wsdl/";
    private static final Logger LOGGER = Logger.getLogger(HelidonResourceLoader.class.getName());

    public HelidonResourceLoader(String catalog) {
        this.catalog = catalog;
    }

    public URL getResource(String resource) throws MalformedURLException {
        String res = resource.startsWith("/") ? resource.substring(1) : resource;
        return Thread.currentThread().getContextClassLoader().getResource(res);
    }

    public URL getCatalogFile() throws MalformedURLException {
        return this.getResource(this.catalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getResourcePaths(String path) {
        if ("/WEB-INF/wsdl/".equals(path)) {
            final HashSet<String> r = new HashSet<String>();
            FileSystem jarFS = null;
            try {
                final URL rootUrl = this.getResource(path);
                if (rootUrl == null) {
                    HashSet<String> hashSet = r;
                    return hashSet;
                }
                Path wsdlDir = null;
                switch (rootUrl.getProtocol()) {
                    case "file": {
                        wsdlDir = Paths.get(rootUrl.toURI());
                        break;
                    }
                    case "jar": {
                        jarFS = FileSystems.newFileSystem(rootUrl.toURI(), Collections.emptyMap());
                        wsdlDir = jarFS.getPath(path, new String[0]);
                        break;
                    }
                    default: {
                        LOGGER.log(Level.WARNING, "Unsupported protocol: {0}", rootUrl.getProtocol());
                        LOGGER.log(Level.WARNING, "Empty set for {0}", rootUrl);
                        Set set = Collections.EMPTY_SET;
                        return set;
                    }
                }
                Files.walkFileTree(wsdlDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try {
                            String p = HelidonResourceLoader.DD_DIR + Paths.get(rootUrl.toURI()).relativize(file).toString();
                            r.add(p);
                        }
                        catch (URISyntaxException ex) {
                            LOGGER.log(Level.FINE, null, ex);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException | URISyntaxException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            finally {
                if (jarFS != null) {
                    try {
                        jarFS.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                    }
                }
            }
            return r;
        }
        LOGGER.log(Level.WARNING, "Empty set for {0}", path);
        return Collections.EMPTY_SET;
    }
}

