/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.metro.helidon;

import com.sun.xml.ws.api.ResourceLoader;
import com.sun.xml.ws.api.pipe.TransportTubeFactory;
import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.WebModule;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.metro.helidon.HelidonModule;
import org.eclipse.metro.helidon.HelidonTransportFactory;

class HelidonContainer
extends Container {
    private final TransportTubeFactory transport = new HelidonTransportFactory();
    private final ResourceLoader loader = new ResourceLoader(){

        public URL getResource(String string) throws MalformedURLException {
            URL res = Thread.currentThread().getContextClassLoader().getResource(string);
            return res != null ? res : Thread.currentThread().getContextClassLoader().getResource("/META-INF/" + string);
        }
    };
    private final WebModule module;

    public HelidonContainer(String rootContext) {
        this.module = new HelidonModule(rootContext);
    }

    List<BoundEndpoint> getBoundEndpoints() {
        return this.module.getBoundEndpoints();
    }

    public <T> T getSPI(Class<T> spiType) {
        Object t = super.getSPI(spiType);
        if (t != null) {
            return (T)t;
        }
        if (spiType == TransportTubeFactory.class) {
            return spiType.cast(this.transport);
        }
        if (spiType == ResourceLoader.class) {
            return spiType.cast(this.loader);
        }
        if (spiType.isAssignableFrom(WebModule.class)) {
            return spiType.cast(this.module);
        }
        return null;
    }
}

