/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.metro.helidon;

import com.oracle.webservices.api.message.BasePropertySet;
import com.oracle.webservices.api.message.PropertySet;
import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.resources.WsservletMessages;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import io.helidon.common.context.Context;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.common.reactive.IoMulti;
import io.helidon.common.reactive.OutputStreamMulti;
import io.helidon.media.common.DataChunkInputStream;
import io.helidon.webserver.ResponseHeaders;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Flow;
import java.util.logging.Logger;
import org.eclipse.metro.helidon.APISupport;
import org.eclipse.metro.helidon.WSUtils;

class HelidonConnectionImpl
extends WSHTTPConnection
implements WebServiceContextDelegate {
    private final ServerRequest req;
    private final ServerResponse res;
    private final HttpAdapter adapter;
    private HaInfo haInfo;
    private static final BasePropertySet.PropertyMap model;
    private static final Logger LOGGER;

    public HelidonConnectionImpl(HttpAdapter adapter, ServerRequest req, ServerResponse res) {
        this.adapter = adapter;
        this.req = req;
        this.res = res;
        res.status(0);
    }

    public WebServiceContextDelegate getWebServiceContextDelegate() {
        return this;
    }

    @PropertySet.Property(value={"org.eclipse.metro.http.request"})
    public ServerRequest getRequest() {
        return this.req;
    }

    @PropertySet.Property(value={"org.eclipse.metro.http.context"})
    public Context getContext() {
        return this.req.context();
    }

    @PropertySet.Property(value={"org.eclipse.metro.http.response"})
    public ServerResponse getResponse() {
        return this.res;
    }

    protected BasePropertySet.PropertyMap getPropertyMap() {
        return model;
    }

    public void setResponseHeaders(Map<String, List<String>> headers) {
        new ArrayList(this.res.headers().toMap().keySet()).forEach(arg_0 -> ((ResponseHeaders)this.res.headers()).remove(arg_0));
        headers.entrySet().stream().filter(e -> !((String)e.getKey()).equalsIgnoreCase("Content-Type") && !((String)e.getKey()).equalsIgnoreCase("Content-Length")).forEach(e -> this.res.headers().add((String)e.getKey(), (Iterable)e.getValue()));
    }

    public void setResponseHeader(String key, String value) {
        this.res.headers().put(key, new String[]{value});
    }

    public void setResponseHeader(String key, List<String> value) {
        this.res.headers().put(key, value);
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.res.headers().toMap();
    }

    public void setContentTypeResponseHeader(String value) {
        this.res.headers().contentType(MediaType.parse((String)value));
    }

    public void setContentLengthResponseHeader(int value) {
        this.res.headers().contentLength((long)value);
    }

    public void setStatus(int status) {
        this.res.status(status);
    }

    public int getStatus() {
        return this.res.status().code();
    }

    public void setCookie(String name, String value) {
        this.res.headers().addCookie(name, value);
    }

    public String getCookie(String name) {
        return this.req.headers().cookies().first(name).orElse(null);
    }

    public InputStream getInput() throws IOException {
        return new DataChunkInputStream((Flow.Publisher)this.req.content());
    }

    public OutputStream getOutput() throws IOException {
        OutputStreamMulti os = IoMulti.outputStreamMulti();
        this.res.send((Flow.Publisher)os.map(byteBuffer -> DataChunk.create((boolean)false, (boolean)true, (ByteBuffer[])new ByteBuffer[]{byteBuffer})));
        return os;
    }

    public String getRequestMethod() {
        return this.req.method().name();
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.req.headers().toMap();
    }

    public Set<String> getRequestHeaderNames() {
        return this.getRequestHeaders().keySet();
    }

    public String getRequestHeader(String name) {
        return this.req.headers().first(name).orElse(null);
    }

    public List<String> getRequestHeaderValues(String header) {
        return header != null ? this.req.headers().values(header) : null;
    }

    public String getQueryString() {
        return this.req.query();
    }

    public String getPathInfo() {
        return this.req.path().param("pathinfo");
    }

    public String getProtocol() {
        return this.req.version().value();
    }

    @PropertySet.Property(value={"org.eclipse.metro.http.request.uri"})
    public String getRequestURI() {
        return this.req.uri().toString();
    }

    public String getRequestScheme() {
        return this.isSecure() ? "https" : "http";
    }

    public String getServerName() {
        return this.req.localAddress();
    }

    public int getServerPort() {
        return this.req.localPort();
    }

    public boolean isSecure() {
        return this.req.isSecure();
    }

    public String getBaseAddress() {
        return WSUtils.getBaseAddress(this.req);
    }

    public Principal getUserPrincipal() {
        return this.getUserPrincipal(null);
    }

    public Principal getUserPrincipal(Packet request) {
        LOGGER.warning("Calling unsupported method: getUserPrincipal");
        return null;
    }

    public boolean isUserInRole(String role) {
        return this.isUserInRole(null, role);
    }

    public boolean isUserInRole(Packet request, String role) {
        LOGGER.warning("Calling unsupported method: isUserInRole");
        return false;
    }

    @PropertySet.Property(value={"com.sun.xml.ws.api.message.packet.hainfo"})
    public HaInfo getHaInfo() {
        if (this.haInfo == null) {
            Parameters cookies = this.req.headers().cookies();
            String replicaInstance = cookies.first("JREPLICA").orElse(null);
            String key = cookies.first("METRO_KEY").orElse(null);
            String jrouteId = cookies.first("JROUTE").orElse(null);
            if (replicaInstance != null && key != null) {
                String proxyJroute = this.getRequestHeader("proxy-jroute");
                boolean failOver = jrouteId != null && proxyJroute != null && !jrouteId.equals(proxyJroute);
                this.haInfo = new HaInfo(key, replicaInstance, failOver);
            }
        }
        return this.haInfo;
    }

    public void setHaInfo(HaInfo replicaInfo) {
        this.haInfo = replicaInfo;
    }

    public String getEPRAddress(Packet request, WSEndpoint endpoint) {
        PortAddressResolver resolver = this.adapter.owner.createPortAddressResolver(this.getBaseAddress(), endpoint.getImplementationClass());
        String address = resolver.getAddressFor(endpoint.getServiceName(), endpoint.getPortName().getLocalPart());
        if (address == null) {
            throw APISupport.createException(WsservletMessages.SERVLET_NO_ADDRESS_AVAILABLE((Object)endpoint.getPortName()));
        }
        return address;
    }

    public String getWSDLAddress(Packet request, WSEndpoint endpoint) {
        String eprAddress = this.getEPRAddress(request, endpoint);
        return this.adapter.getEndpoint().getPort() != null ? eprAddress + "?wsdl" : null;
    }

    static {
        LOGGER = Logger.getLogger(HelidonConnectionImpl.class.getName());
        model = HelidonConnectionImpl.parse(HelidonConnectionImpl.class, (MethodHandles.Lookup)MethodHandles.lookup());
    }
}

