/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.metro.helidon;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebModule;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.HttpAdapterList;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.reactive.IoMulti;
import io.helidon.common.reactive.OutputStreamMulti;
import io.helidon.webserver.PathMatcher;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.Flow;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.metro.helidon.APISupport;
import org.eclipse.metro.helidon.HelidonConnectionImpl;

class HelidonAdapter
extends HttpAdapter
implements BoundEndpoint {
    private final String name;
    private static final Logger LOGGER = Logger.getLogger(HelidonAdapter.class.getName());
    private final PathMatcher serviceContext;

    public HelidonAdapter(String name, WSEndpoint endpoint, HttpAdapterList<? extends HttpAdapter> owner, String urlPattern) {
        super(endpoint, owner, urlPattern);
        this.name = name;
        this.serviceContext = urlPattern.endsWith("/*") ? PathMatcher.create((String)(this.getValidPath() + "[{pathinfo:/.+}]")) : PathMatcher.create((String)urlPattern);
    }

    String getName() {
        return this.name;
    }

    PathMatcher getServiceContextPath() {
        return this.serviceContext;
    }

    public void handle(ServerRequest req, ServerResponse res) {
        HelidonConnectionImpl con = new HelidonConnectionImpl(this, req, res);
        try {
            this.invokeAsync(con);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    protected void addSatellites(Packet packet) {
        ServerRequest req = (ServerRequest)packet.get((Object)"org.eclipse.metro.http.request");
        ServerResponse res = (ServerResponse)packet.get((Object)"org.eclipse.metro.http.response");
        packet.addSatellite(APISupport.createPropertySet(req, res));
    }

    private boolean isMetadataQuery(String query) {
        return query != null && (query.equals("WSDL") || query.startsWith("wsdl") || query.startsWith("xsd="));
    }

    public boolean XhandleGet(WSHTTPConnection connection) throws IOException {
        if (connection.getRequestMethod().equals("GET")) {
            if (this.isMetadataQuery(connection.getQueryString())) {
                this.publishWSDL(connection);
                return true;
            }
        } else if (connection.getRequestMethod().equals("HEAD")) {
            // empty if block
        }
        return false;
    }

    public void publishWSDLX(WSHTTPConnection c) throws IOException {
        HelidonConnectionImpl con = (HelidonConnectionImpl)c;
        SDDocument doc = (SDDocument)this.wsdls.get(con.getQueryString());
        if (doc == null) {
            return;
        }
        ServerResponse res = con.getResponse();
        res.status((Http.ResponseStatus)Http.Status.OK_200);
        res.headers().add("Content-Type", Collections.singletonList("text/xml;charset=utf-8"));
        OutputStreamMulti os = IoMulti.outputStreamMulti();
        PortAddressResolver portAddressResolver = this.getPortAddressResolver(con.getBaseAddress());
        DocumentAddressResolver resolver = this.getDocumentAddressResolver(portAddressResolver);
        res.send((Flow.Publisher)os.map(byteBuffer -> DataChunk.create((boolean)false, (boolean)true, (ByteBuffer[])new ByteBuffer[]{byteBuffer})));
        doc.writeTo(portAddressResolver, resolver, (OutputStream)os);
        os.close();
    }

    public URI getAddress() {
        WebModule webModule = (WebModule)this.endpoint.getContainer().getSPI(WebModule.class);
        if (webModule == null) {
            throw APISupport.createException("Container " + this.endpoint.getContainer() + " doesn't support " + WebModule.class);
        }
        return this.getAddress(webModule.getContextPath());
    }

    public URI getAddress(String base) {
        try {
            return new URI((base.endsWith("/") ? base.substring(0, base.length() - 1) : base) + this.getValidPath());
        }
        catch (URISyntaxException ex) {
            throw APISupport.createException("Unable to compute address for " + this.endpoint, ex);
        }
    }
}

