/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.metro.helidon;

import com.oracle.webservices.api.message.BasePropertySet;
import com.oracle.webservices.api.message.PropertySet;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;

final class ConnectionProperties
extends BasePropertySet {
    private static final BasePropertySet.PropertyMap model = ConnectionProperties.parse(ConnectionProperties.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private ServerRequest req;
    private ServerResponse res;

    ConnectionProperties(ServerRequest rq, ServerResponse rs) {
        this.req = rq;
        this.res = rs;
    }

    protected BasePropertySet.PropertyMap getPropertyMap() {
        return model;
    }

    @PropertySet.Property(value={"jakarta.xml.ws.http.request.method"})
    public String getRequestMethod() {
        return this.req.method().name();
    }

    @PropertySet.Property(value={"jakarta.xml.ws.http.request.headers", "com.sun.xml.ws.api.message.packet.inbound.transport.headers"})
    public Map<String, List<String>> getRequestHeaders() {
        return this.req.headers().toMap();
    }

    @PropertySet.Property(value={"jakarta.xml.ws.http.request.querystring"})
    public String getQueryString() {
        return this.req.query();
    }

    @PropertySet.Property(value={"jakarta.xml.ws.http.request.pathinfo"})
    public String getPathInfo() {
        return this.req.path().param("pathinfo");
    }

    @PropertySet.Property(value={"jakarta.xml.ws.http.response.code"})
    public int getStatus() {
        return this.res.status().code();
    }
}

