/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.metro.helidon;

import com.oracle.webservices.api.message.PropertySet;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import jakarta.xml.ws.WebServiceException;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.eclipse.metro.helidon.APISupportImpl;
import org.eclipse.metro.helidon.ConnectionProperties;

final class APISupport {
    private static final APISupportImpl INSTANCE = APISupport.create();

    private APISupport() {
    }

    static PropertySet createPropertySet(ServerRequest req, ServerResponse res) {
        return INSTANCE.createPropertySet(req, res);
    }

    static RuntimeException createException(String msg) {
        return INSTANCE.createException(msg);
    }

    static RuntimeException createException(String msg, Throwable t) {
        return INSTANCE.createException(msg, t);
    }

    private static APISupportImpl create() {
        Iterator loader = HelidonServiceLoader.create(ServiceLoader.load(APISupportImpl.class)).iterator();
        if (loader.hasNext()) {
            return (APISupportImpl)loader.next();
        }
        return new APISupportImpl(){

            @Override
            public PropertySet createPropertySet(ServerRequest req, ServerResponse res) {
                return new ConnectionProperties(req, res);
            }

            @Override
            public RuntimeException createException(String msg) {
                return new WebServiceException(msg);
            }

            @Override
            public RuntimeException createException(String msg, Throwable t) {
                return new WebServiceException(msg, t);
            }
        };
    }
}

