/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.tool;

import com.sun.xml.ws.test.tool.WsTool;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

final class RemoteWsTool
extends WsTool {
    private final File executable;

    public RemoteWsTool(File executable) {
        this.executable = executable;
        if (!executable.exists()) {
            throw new IllegalArgumentException("Non-existent executable " + executable);
        }
    }

    public void invoke(String ... args) throws Exception {
        int len;
        String nonProxyHosts;
        String proxyPort;
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.executable.getPath());
        String proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null) {
            params.add("-J-Dhttp.proxyHost=" + proxyHost);
        }
        if ((proxyPort = System.getProperty("http.proxyPort")) != null) {
            params.add("-J-Dhttp.proxyPort=" + proxyPort);
        }
        if ((nonProxyHosts = System.getProperty("http.nonProxyHosts")) != null) {
            params.add("-J-Dhttp.nonProxyHosts=" + nonProxyHosts);
        }
        params.addAll(Arrays.asList(args));
        ProcessBuilder b = new ProcessBuilder(params);
        b.redirectErrorStream(true);
        Process proc = b.start();
        proc.getOutputStream().close();
        byte[] buf = new byte[8192];
        InputStream in = proc.getInputStream();
        while ((len = in.read(buf)) >= 0) {
            System.out.write(buf, 0, len);
        }
        int exit = proc.waitFor();
        RemoteWsTool.assertEquals((String)("wsimport reported exit code " + exit), (int)0, (int)exit);
    }
}

