/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.model;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public abstract class Script {
    private Script() {
    }

    public abstract String getName();

    public abstract Reader read() throws IOException;

    public static final class File
    extends Script {
        private final java.io.File script;

        public File(java.io.File script) {
            this.script = script;
        }

        public String getName() {
            return this.script.getName();
        }

        public Reader read() throws IOException {
            return new InputStreamReader((InputStream)new FileInputStream(this.script), "UTF-8");
        }
    }

    public static final class Inline
    extends Script {
        private final String name;
        private final String script;

        public Inline(String name, String script) {
            this.name = name;
            this.script = script;
        }

        public String getName() {
            return this.name;
        }

        public Reader read() {
            return new StringReader(this.script);
        }
    }
}

