/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.emma;

import com.vladium.emma.rt.IClassLoadHook;
import com.vladium.util.ByteArrayOStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.tools.ant.loader.AntClassLoader2;

final class InstrumentingClassLoader
extends AntClassLoader2 {
    final IClassLoadHook transformer;

    public InstrumentingClassLoader(IClassLoadHook transformer) {
        this.transformer = transformer;
    }

    public final Class findClass(String name) throws ClassNotFoundException {
        String classResource = name.replace('.', '/') + ".class";
        URL classURL = this.getResource(classResource);
        if (classURL == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            byte[] image = this.readFully(classURL);
            ByteArrayOStream baos = new ByteArrayOStream(image.length);
            if (this.transformer.processClassDef(name, image, image.length, baos)) {
                image = baos.copyByteArray();
            }
            return this.defineClass(name, image, 0, image.length);
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFully(URL resource) throws IOException {
        URLConnection con = resource.openConnection();
        InputStream in = con.getInputStream();
        try {
            int len = con.getContentLength();
            if (len != -1) {
                byte[] buf = new byte[len];
                new DataInputStream(in).readFully(buf);
                byte[] byArray = buf;
                return byArray;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) >= 0) {
                baos.write(buf, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }
}

