/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.emma;

import com.sun.xml.ws.test.emma.InstrumentingClassLoader;
import com.vladium.emma.EMMAProperties;
import com.vladium.emma.data.CoverageOptions;
import com.vladium.emma.data.CoverageOptionsFactory;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.ISessionData;
import com.vladium.emma.data.SessionData;
import com.vladium.emma.filter.IInclExclFilter;
import com.vladium.emma.rt.IClassLoadHook;
import com.vladium.emma.rt.InstrClassLoadHook;
import com.vladium.emma.rt.RT;
import com.vladium.emma.rt.RTSettings;
import com.vladium.util.IProperties;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.loader.AntClassLoader2;

public class Emma {
    private final IMetaData metadata;
    private final IInclExclFilter filter;
    private ICoverageData coverage;

    public Emma() {
        this(new IInclExclFilter(){

            public boolean included(String s) {
                return true;
            }
        });
    }

    public Emma(IInclExclFilter filter) {
        RTSettings.setStandaloneMode((boolean)false);
        RT.reset((boolean)true, (boolean)false);
        IProperties appProperties = RT.getAppProperties();
        if (appProperties == null) {
            appProperties = EMMAProperties.getAppProperties();
        }
        this.metadata = DataFactory.newMetaData((CoverageOptions)CoverageOptionsFactory.create((IProperties)appProperties));
        this.coverage = RT.getCoverageData();
        this.filter = filter;
    }

    public AntClassLoader2 createInstrumentingClassLoader() {
        return new InstrumentingClassLoader((IClassLoadHook)new InstrClassLoadHook(this.filter, this.metadata));
    }

    public void write(File output) throws IOException {
        IMetaData msnap = this.metadata.shallowCopy();
        if (msnap.isEmpty()) {
            System.err.println("no metadata collected at runtime [no reports generated]");
            return;
        }
        ICoverageData csnap = this.coverage.shallowCopy();
        if (csnap.isEmpty()) {
            System.err.println("no coverage data collected at runtime [all reports will be empty]");
            return;
        }
        System.out.println("Writing emma coverage report");
        DataFactory.persist((ISessionData)new SessionData(msnap, csnap), (File)output, (boolean)false);
    }
}

