/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.model;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.test.VersionNumber;
import com.sun.istack.test.VersionProcessor;
import com.sun.xml.ws.test.World;
import com.sun.xml.ws.test.client.AbstractXmlResource;
import com.sun.xml.ws.test.client.InlineXmlResource;
import com.sun.xml.ws.test.client.ReferencedXmlResource;
import com.sun.xml.ws.test.client.XmlResource;
import com.sun.xml.ws.test.container.ApplicationContainer;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.container.DeploymentContext;
import com.sun.xml.ws.test.exec.ClientCompileExecutor;
import com.sun.xml.ws.test.exec.ClientExecutor;
import com.sun.xml.ws.test.exec.ConcurrentClientExecutor;
import com.sun.xml.ws.test.exec.DeploymentExecutor;
import com.sun.xml.ws.test.exec.JavaClientExecutor;
import com.sun.xml.ws.test.exec.PrepareExecutor;
import com.sun.xml.ws.test.model.Script;
import com.sun.xml.ws.test.model.TestClient;
import com.sun.xml.ws.test.model.TestService;
import com.sun.xml.ws.test.model.TransportSet;
import com.sun.xml.ws.test.model.WSDL;
import com.sun.xml.ws.test.tool.WsTool;
import com.sun.xml.ws.test.util.XMLUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.tools.ant.types.FileSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TestDescriptor {
    @NotNull
    public final String name;
    @Nullable
    public final File resources;
    @Nullable
    public final File common;
    @NotNull
    public final VersionProcessor applicableVersions;
    @Nullable
    public final String description;
    @NotNull
    public final TransportSet supportedTransport;
    public final Set<String> useSet;
    public final List<String> metadatafiles = new ArrayList<String>();
    @NotNull
    public final SortedSet<Integer> bugsterIds = new TreeSet<Integer>();
    @NotNull
    public final List<TestClient> clients = new ArrayList<TestClient>();
    @NotNull
    public final List<File> clientCustomizations = new ArrayList<File>();
    @Nullable
    public final String setUpScript;
    @NotNull
    public final List<File> javaClients = new ArrayList<File>();
    @NotNull
    public final List<TestService> services = new ArrayList<TestService>();
    public final Map<String, XmlResource> xmlResources = new HashMap<String, XmlResource>();
    @NotNull
    public final File home;
    public final List<String> testOptions = new ArrayList<String>();
    public final List<String> wsimportClientOptions = new ArrayList<String>();
    public final List<String> wsimportServerOptions = new ArrayList<String>();
    public final List<String> wsgenOptions = new ArrayList<String>();
    public final List<String> javacOptions = new ArrayList<String>();
    public final List<String> systemProperties = new ArrayList<String>();
    private boolean skip;
    private static final String JDK6_EXCLUDE_VERSION = "jdk6";
    public final boolean disgardWsGenOutput;
    public final boolean jdk6;

    public TestDescriptor(String shortName, File home, File resources, File common, VersionProcessor applicableVersions, String description, boolean disgardWsGenOutput, boolean jdk6) {
        this.name = shortName;
        this.home = home;
        this.resources = resources;
        this.common = common;
        this.applicableVersions = applicableVersions;
        this.disgardWsGenOutput = disgardWsGenOutput;
        this.supportedTransport = TransportSet.ALL;
        this.description = description;
        this.skip = false;
        this.setUpScript = null;
        this.jdk6 = jdk6;
        this.useSet = new HashSet<String>();
    }

    public TestDescriptor(File descriptor, boolean disgardWsGenOutput, boolean jdk6) throws IOException, ParserConfigurationException, SAXException {
        File schemaCustomization;
        this.disgardWsGenOutput = disgardWsGenOutput;
        this.jdk6 = jdk6;
        File testDir = descriptor.getParentFile();
        Element root = this.parse(descriptor).getDocumentElement();
        List<Element> list = XMLUtil.getElements(root, "/descriptor/description");
        this.description = list.isEmpty() ? "" : list.get(0).getTextContent().trim();
        File resourceDir = new File(testDir, "resources");
        this.resources = resourceDir.exists() ? resourceDir : null;
        for (Element xre : XMLUtil.getElements(root, "/descriptor/xml-resource")) {
            String attr = xre.getAttribute("href");
            AbstractXmlResource xr = attr == null || attr.trim().isEmpty() ? new InlineXmlResource((Element)xre.getFirstChild()) : new ReferencedXmlResource(new File(testDir, attr));
            this.xmlResources.put(xre.getAttribute("name"), xr);
        }
        File commonDir = new File(testDir, "common");
        this.common = commonDir.exists() ? commonDir : null;
        this.applicableVersions = this.getVersionProcessor(root);
        this.skip = Boolean.parseBoolean(root.getAttribute("skip"));
        this.parseArguments(XMLUtil.getTextFrom(root, "/descriptor/test-options"), this.testOptions);
        this.parseArguments(XMLUtil.getTextFrom(root, "/descriptor/wsimport-client"), this.wsimportClientOptions);
        this.parseArguments(XMLUtil.getTextFrom(root, "/descriptor/wsimport-server"), this.wsimportServerOptions);
        this.parseArguments(XMLUtil.getTextFrom(root, "/descriptor/wsgen-options"), this.wsgenOptions);
        this.parseArguments(XMLUtil.getTextFrom(root, "/descriptor/javac-options"), this.javacOptions);
        this.parseArguments(XMLUtil.getTextFrom(root, "/descriptor/system-properties"), this.systemProperties);
        String transport = XMLUtil.getAttributeOrNull(root, "transport");
        this.supportedTransport = transport == null ? TransportSet.ALL : new TransportSet.Singleton(transport);
        this.useSet = new HashSet<String>();
        String uses = XMLUtil.getAttributeOrNull(root, "uses");
        if (uses != null) {
            StringTokenizer st = new StringTokenizer(uses);
            while (st.hasMoreTokens()) {
                this.useSet.add(st.nextToken());
            }
        }
        String path = testDir.getCanonicalPath();
        String testCasesPattern = "testcases" + File.separatorChar;
        int testCaseIndex = path.lastIndexOf(testCasesPattern);
        this.name = path.substring(testCaseIndex += testCasesPattern.length()).replace(File.separatorChar, '.');
        this.home = descriptor.getParentFile();
        list = XMLUtil.getElements(root, "/descriptor/pre-client");
        this.setUpScript = list.isEmpty() ? null : XMLUtil.getTextFrom(list.get(0));
        for (Element client : XMLUtil.getElements(root, "/descriptor/client")) {
            VersionProcessor versionProcessor = this.getVersionProcessor(client);
            boolean sideEffectFree = client.getAttribute("sideEffectFree") != null;
            String clientTransport = XMLUtil.getAttributeOrNull(client, "transport");
            TransportSet clientSupportedTransport = clientTransport == null ? TransportSet.ALL : new TransportSet.Singleton(clientTransport);
            String href = XMLUtil.getAttributeOrNull(client, "href");
            if (href != null) {
                FileSet fs = new FileSet();
                fs.setDir(testDir);
                fs.setIncludes(href);
                for (String relPath : fs.getDirectoryScanner(World.project).getIncludedFiles()) {
                    TestClient testClient = new TestClient(this, versionProcessor, clientSupportedTransport, new Script.File(new File(testDir, relPath)), sideEffectFree);
                    this.clients.add(testClient);
                }
                continue;
            }
            TestClient testClient = new TestClient(this, versionProcessor, clientSupportedTransport, new Script.Inline(client.getAttribute("name"), XMLUtil.getTextFrom(client)), sideEffectFree);
            this.clients.add(testClient);
        }
        File customization = this.parseFile(testDir, "custom-client.xml");
        if (customization.exists()) {
            this.clientCustomizations.add(customization);
        }
        if ((schemaCustomization = this.parseFile(testDir, "custom-schema-client.xml")).exists()) {
            this.clientCustomizations.add(schemaCustomization);
        }
        this.findAllJavaClients(this.home);
        List<Element> serviceList = XMLUtil.getElements(root, "/descriptor/service");
        this.populateServices(serviceList, testDir, false);
        List<Element> stsList = XMLUtil.getElements(root, "/descriptor/sts");
        this.populateServices(stsList, testDir, true);
        list = XMLUtil.getElements(root, "/descriptor/external-metadata");
        for (Element element : list) {
            String filepath = XMLUtil.getAttributeOrNull(element, "file");
            if (filepath == null) continue;
            this.metadatafiles.add(filepath);
        }
    }

    private void parseArguments(String s, List<String> result) {
        if (s != null) {
            result.addAll(Arrays.asList(s.split("\\p{Space}+")));
        }
    }

    private void findAllJavaClients(File dir) {
        for (File child : dir.listFiles()) {
            if (child.getName().equals("work")) continue;
            if (child.isDirectory()) {
                this.findAllJavaClients(child);
            }
            if (!child.getName().endsWith("Test.java")) continue;
            this.javaClients.add(child);
        }
    }

    public TestSuite build(ApplicationContainer container, WsTool wsimport, String clientScriptName, boolean concurrentSideEffectFree, VersionNumber version) throws IOException {
        TestSuite suite = new TestSuite();
        if (this.skip) {
            System.out.println("Skipping " + this.name + "; explictly marked to skip.");
            return suite;
        }
        if (!this.supportedTransport.contains(container.getTransport())) {
            System.out.println("Skipping " + this.name + " as it's not applicable to " + container.getTransport());
            return suite;
        }
        HashSet<String> temp = new HashSet<String>(this.useSet);
        temp.retainAll(container.getUnsupportedUses());
        if (temp.size() > 0) {
            System.out.println("Skipping " + this.name + " as the container " + container + " doesn't support " + temp);
            return suite;
        }
        DeploymentContext context = new DeploymentContext(this, container, wsimport);
        ArrayList<DeploymentExecutor> deployTests = new ArrayList<DeploymentExecutor>();
        suite.addTest((Test)new PrepareExecutor(context, !wsimport.isNoop()));
        for (DeployedService s : context.services.values()) {
            DeploymentExecutor dt = new DeploymentExecutor(s);
            deployTests.add(dt);
            suite.addTest((Test)dt);
        }
        if (context.services.isEmpty() && new File(context.descriptor.home, "client").exists()) {
            suite.addTest((Test)new ClientCompileExecutor(context));
        }
        for (TestClient c : this.clients) {
            if (clientScriptName != null && !c.script.getName().equals(clientScriptName)) continue;
            if (version != null && !c.applicableVersions.isApplicable(version)) {
                System.err.println("Not applicable to current version=" + version + ". Skipping " + c.script.getName());
                continue;
            }
            if (!c.supportedTransport.contains(container.getTransport())) {
                System.out.println("Skipping " + c.script.getName() + " as it's not applicable to " + container.getTransport());
                continue;
            }
            if (concurrentSideEffectFree && c.sideEffectFree) {
                suite.addTest((Test)new ConcurrentClientExecutor.Fixed(context, c));
                suite.addTest((Test)new ConcurrentClientExecutor.Cached(context, c));
                continue;
            }
            suite.addTest((Test)new ClientExecutor(context, c));
        }
        for (File f : this.javaClients) {
            suite.addTest((Test)new JavaClientExecutor(context, f, version));
        }
        for (DeploymentExecutor dt : deployTests) {
            suite.addTest((Test)dt.createUndeployer());
        }
        return suite;
    }

    private File parseFile(File base, String href) {
        File f = new File(href);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(base, href);
    }

    private Document parse(File descriptor) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtil.readXML(descriptor, World.class.getResource("test-descriptor.rnc"));
    }

    public String toString() {
        return this.name;
    }

    private void populateServices(List<Element> serviceList, File testDir, boolean isSTS) throws IOException {
        for (Element service : serviceList) {
            File schemaCustomization;
            String serviceName;
            File serviceBaseDir;
            String baseDir = XMLUtil.getAttributeOrDefault(service, "basedir", ".");
            if (!baseDir.equals(".")) {
                serviceBaseDir = new File(testDir, baseDir);
                serviceName = serviceBaseDir.getCanonicalFile().getName();
            } else {
                serviceName = "";
                serviceBaseDir = testDir;
            }
            LinkedList<WSDL> wsdlInfo = new LinkedList<WSDL>();
            String xpath = isSTS ? "/descriptor/sts/wsdl" : "/descriptor/service/wsdl";
            for (Element el : XMLUtil.getElements(service, xpath)) {
                File serviceTargetDir = serviceBaseDir;
                String wsdlAttribute = XMLUtil.getAttributeOrDefault(el, "href", "test.wsdl");
                File wsdl = this.parseFile(serviceTargetDir, wsdlAttribute);
                String relLoc = null;
                FileSet schemaSet = new FileSet();
                if (wsdlAttribute.contains("/")) {
                    relLoc = wsdlAttribute.substring(0, wsdlAttribute.lastIndexOf("/"));
                    serviceTargetDir = new File(serviceTargetDir, relLoc);
                }
                schemaSet.setDir(serviceTargetDir);
                schemaSet.setIncludes("**/*.xsd");
                schemaSet.setExcludes("work/**");
                ArrayList<File> schemaFiles = new ArrayList<File>();
                for (String relPath : schemaSet.getDirectoryScanner(World.project).getIncludedFiles()) {
                    schemaFiles.add(new File(serviceTargetDir, relPath));
                }
                FileSet wsdlSet = new FileSet();
                wsdlSet.setDir(serviceTargetDir);
                wsdlSet.setIncludes("**/*.wsdl");
                wsdlSet.setExcludes("wsdlAttribute, work/**");
                ArrayList<File> importedWsdls = new ArrayList<File>();
                for (String relPath : wsdlSet.getDirectoryScanner(World.project).getIncludedFiles()) {
                    importedWsdls.add(new File(serviceTargetDir, relPath));
                }
                wsdlInfo.add(new WSDL(wsdl, importedWsdls, schemaFiles, relLoc));
            }
            TestService testService = new TestService(this, serviceName, serviceBaseDir, wsdlInfo, isSTS, XMLUtil.getAttributeOrNull(service, "class"));
            File customization = this.parseFile(serviceBaseDir, "custom-server.xml");
            if (customization.exists()) {
                testService.customizations.add(customization);
            }
            if ((schemaCustomization = this.parseFile(serviceBaseDir, "custom-schema-server.xml")).exists()) {
                testService.customizations.add(schemaCustomization);
            }
            this.services.add(testService);
        }
    }

    private VersionProcessor getVersionProcessor(Element e) {
        String excludeFrom = XMLUtil.getAttributeOrNull(e, "excludeFrom");
        if (excludeFrom != null && excludeFrom.contains(JDK6_EXCLUDE_VERSION)) {
            excludeFrom = this.jdk6 ? "all" : excludeFrom.replace(JDK6_EXCLUDE_VERSION, "");
        }
        return new VersionProcessor(XMLUtil.getAttributeOrNull(e, "since"), XMLUtil.getAttributeOrNull(e, "until"), excludeFrom);
    }

    class WSDLFilter
    implements FilenameFilter {
        String primaryWsdl;

        public WSDLFilter(String primaryWsdl) {
            this.primaryWsdl = primaryWsdl;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".wsdl") && !name.equals(this.primaryWsdl);
        }
    }

    class XSDFilter
    implements FilenameFilter {
        XSDFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".xsd");
        }
    }
}

