/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container;

import com.sun.istack.NotNull;
import com.sun.xml.ws.test.CodeGenerator;
import com.sun.xml.ws.test.Realm;
import com.sun.xml.ws.test.World;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.container.jelly.EndpointInfoBean;
import com.sun.xml.ws.test.container.jelly.WebXmlInfoBean;
import com.sun.xml.ws.test.model.TestEndpoint;
import com.sun.xml.ws.test.model.WSDL;
import com.sun.xml.ws.test.tool.WsTool;
import com.sun.xml.ws.test.util.ArgumentListBuilder;
import com.sun.xml.ws.test.util.FileUtil;
import com.sun.xml.ws.test.util.FreeMarkerTemplate;
import com.sun.xml.ws.test.util.JavacTask;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceProvider;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.Path;
import org.w3c.dom.Document;

public final class WAR {
    public final File root;
    public final File classDir;
    public final File webInfDir;
    public final File libDir;
    public final File srcDir;
    private final List<File> wsdl = new ArrayList<File>();
    public final DeployedService service;
    private static final File NOWHERE = new File(System.getProperty("java.io.tmpdir"));

    public WAR(DeployedService service) {
        this.service = service;
        this.root = service.warDir;
        this.webInfDir = new File(this.root, "WEB-INF");
        this.classDir = new File(this.webInfDir, "classes");
        this.classDir.mkdirs();
        this.libDir = new File(this.webInfDir, "lib");
        this.libDir.mkdir();
        this.srcDir = new File(service.workDir, "gen-src");
        this.srcDir.mkdir();
    }

    public List<EndpointInfoBean> getEndpointsInfos() throws Exception {
        Set<TestEndpoint> endpoints = this.service.service.endpoints;
        ArrayList<EndpointInfoBean> beans = new ArrayList<EndpointInfoBean>();
        if (this.service.service.wsdl.isEmpty() || this.service.service.parent.metadatafiles.size() > 0) {
            for (TestEndpoint endpoint : endpoints) {
                EndpointInfoBean bean = EndpointInfoBean.create(endpoint.name, endpoint.className, null, null, null, null, "/" + endpoint.name);
                beans.add(bean);
            }
        } else {
            ArrayList<String> portNames = new ArrayList<String>();
            HashMap<String, String> portNameToImpl = new HashMap<String, String>();
            HashMap<String, String> implToPort = new HashMap<String, String>();
            HashMap<String, QName> portNameToServiceName = new HashMap<String, QName>();
            String implClass = null;
            URLClassLoader loader = new URLClassLoader(new URL[]{this.classDir.toURL()}, World.runtime.getClassLoader());
            WebServiceClient wsca = null;
            for (String className : FileUtil.getClassFileNames(this.classDir)) {
                Class<?> clazz = loader.loadClass(className);
                if (clazz.getAnnotation(WebServiceClient.class) != null) {
                    wsca = clazz.getAnnotation(WebServiceClient.class);
                    for (Method method : clazz.getMethods()) {
                        String name;
                        WebEndpoint a = method.getAnnotation(WebEndpoint.class);
                        if (a == null || method.getParameterTypes().length != 0 || (name = a.name()).equals("")) continue;
                        portNames.add(name);
                        portNameToServiceName.put(name, new QName(wsca.targetNamespace(), wsca.name()));
                    }
                    continue;
                }
                WebService ws = clazz.getAnnotation(WebService.class);
                if (ws != null) {
                    String endpointInterface = ws.endpointInterface();
                    if (!endpointInterface.equals("")) {
                        implClass = clazz.getName();
                    }
                    if ("".equals(ws.portName())) continue;
                    portNameToImpl.put(ws.portName(), implClass);
                    implToPort.put(implClass, ws.portName());
                    continue;
                }
                WebServiceProvider wsp = clazz.getAnnotation(WebServiceProvider.class);
                if (wsp == null) continue;
                implClass = clazz.getName();
                if ("".equals(wsp.portName())) continue;
                portNameToImpl.put(wsp.portName(), implClass);
                implToPort.put(implClass, wsp.portName());
            }
            String tns = null;
            String wsdlLocation = null;
            if (wsca != null) {
                tns = wsca.targetNamespace();
                wsdlLocation = wsca.wsdlLocation();
                wsdlLocation = wsdlLocation.replace('\\', '/');
                wsdlLocation = "WEB-INF/wsdl/" + wsdlLocation.substring(wsdlLocation.lastIndexOf("/") + 1, wsdlLocation.length());
            }
            int i = 0;
            for (String string : portNames) {
                String impl = (String)portNameToImpl.get(string);
                portNameToImpl.remove(string);
                if (impl == null) {
                    if (portNames.size() > 1) continue;
                    impl = implClass;
                }
                EndpointInfoBean bean = EndpointInfoBean.create("endpoint" + i++, impl, wsdlLocation, (QName)portNameToServiceName.get(string), new QName(tns, string), "binding", "/" + this.service.service.getEndpointByImpl((String)impl).name);
                beans.add(bean);
                implToPort.remove(impl);
            }
            for (Map.Entry entry : implToPort.entrySet()) {
                EndpointInfoBean bean = EndpointInfoBean.create("endpoint" + i++, (String)entry.getKey(), wsdlLocation, (QName)portNameToServiceName.get(entry.getValue()), new QName(tns, (String)entry.getValue()), "binding", "/" + this.service.service.getEndpointByImpl((String)((String)entry.getKey())).name);
                beans.add(bean);
            }
            if (!portNameToImpl.isEmpty()) {
                throw new Exception("Implementations " + new ArrayList(portNameToImpl.values()) + " don't have corresponding ports in WSDL. Their declared ports are " + new ArrayList(portNameToImpl.keySet()) + " but actual ports are " + portNames);
            }
        }
        return beans;
    }

    public void zipTo(File archive) throws Exception {
        Zip zip = new Zip();
        zip.setProject(World.project);
        zip.setDestFile(archive);
        zip.setBasedir(this.root);
        zip.execute();
    }

    public void copyClasspath(Realm classpath) throws Exception {
        int n = 0;
        for (File path : classpath.list()) {
            if (path.isFile()) {
                FileUtil.copyFile(path, new File(this.libDir, path.getName()));
                continue;
            }
            Jar jar = new Jar();
            jar.setProject(World.project);
            jar.setDestFile(new File(this.libDir, "generated" + n++ + ".jar"));
            jar.setBasedir(path);
            jar.setCompress(false);
            jar.execute();
        }
    }

    public void copyToClasses(File ... handlerConfigs) {
        for (File config : handlerConfigs) {
            FileUtil.copyFile(config, new File(this.classDir, config.getName()));
        }
    }

    public void copyToWEBINF(File file) {
        FileUtil.copyFile(file, new File(this.webInfDir, file.getName()));
    }

    public void copyResources(File resourcesDir) {
        if (resourcesDir != null) {
            FileUtil.copyDir(resourcesDir, this.classDir, "**/wsit-client.xml");
        }
    }

    public void copyWsit(File wsitConf) {
        if (wsitConf != null && wsitConf.exists()) {
            FileUtil.copyFile(wsitConf, new File(this.classDir, wsitConf.getName()));
        }
    }

    @NotNull
    public List<File> getWSDL() {
        return this.wsdl;
    }

    final void generateSunJaxWsXml(List<EndpointInfoBean> endpointInfoBeans) throws Exception {
        FreeMarkerTemplate jelly = new FreeMarkerTemplate("/web/sun-jaxws.ftl");
        jelly.put("endpointInfoBeans", endpointInfoBeans);
        jelly.run(new File(this.webInfDir, "sun-jaxws.xml"));
    }

    final void generateWebXml(List<EndpointInfoBean> endpoints, boolean httpspi) throws Exception {
        FreeMarkerTemplate jelly = new FreeMarkerTemplate("/web/web.ftl");
        String listenerClass = httpspi ? "com.sun.xml.ws.transport.httpspi.servlet.WSSPIContextListener" : "com.sun.xml.ws.transport.http.servlet.WSServletContextListener";
        String servletClass = httpspi ? "com.sun.xml.ws.transport.httpspi.servlet.WSSPIServlet" : "com.sun.xml.ws.transport.http.servlet.WSServlet";
        WebXmlInfoBean infoBean = new WebXmlInfoBean(this.service.parent, endpoints, listenerClass, servletClass);
        jelly.put("data", infoBean);
        jelly.run(new File(this.webInfDir, "web.xml"));
    }

    final void generateSunWebXml() throws Exception {
        FreeMarkerTemplate jelly = new FreeMarkerTemplate("/web/sun-web.ftl");
        jelly.run(new File(this.webInfDir, "sun-web.xml"));
    }

    final void compileWSDL(WsTool wsimport) throws Exception {
        assert (!this.service.service.wsdl.isEmpty());
        assert (this.wsdl.isEmpty());
        for (WSDL dl : this.service.service.wsdl) {
            String importedPath;
            ArgumentListBuilder options = new ArgumentListBuilder();
            for (File custFile : this.service.service.customizations) {
                options.add("-b").add(custFile);
            }
            options.add("-extension");
            if (!this.service.service.parent.testOptions.contains("-noPackage") && !this.service.service.parent.wsimportServerOptions.contains("-p")) {
                options.add("-p").add(this.service.service.getGlobalUniqueName());
            }
            if (World.debug) {
                options.add("-verbose");
            }
            options.add("-s").add(this.srcDir);
            options.add("-d").add(this.classDir);
            options.add("-Xnocompile");
            if (Boolean.getBoolean("harness.useSSL")) {
                options.add("-XdisableSSLHostnameVerification");
            }
            options.add(dl.wsdlFile);
            options.addAll(this.service.service.parent.wsimportServerOptions);
            if (!wsimport.isNoop()) {
                System.out.println("Generating server artifacts from " + dl.wsdlFile);
                options.invoke(wsimport);
            }
            File wsdlDir = new File(this.webInfDir, "wsdl");
            if (dl.relativeLocation != null) {
                wsdlDir = new File(wsdlDir, dl.relativeLocation);
            }
            wsdlDir.mkdirs();
            File src = dl.wsdlFile;
            File wsdlFile = new File(wsdlDir, src.getName());
            this.wsdl.add(wsdlFile);
            FileUtil.copyFile(src, wsdlFile);
            for (File importedWsdl : dl.importedWsdls) {
                importedPath = importedWsdl.getCanonicalPath().substring(src.getParentFile().getCanonicalPath().length() + 1);
                FileUtil.copyFile(importedWsdl, new File(wsdlDir, importedPath));
            }
            for (File schema : dl.schemas) {
                importedPath = schema.getCanonicalPath().substring(src.getParentFile().getCanonicalPath().length() + 1);
                FileUtil.copyFile(schema, new File(wsdlDir, importedPath));
            }
        }
    }

    final void compileJavac() throws Exception {
        JavacTask javac = new JavacTask(this.service.parent.descriptor.javacOptions);
        if (this.service.parent.descriptor.common != null) {
            javac.setSourceDir(this.service.service.baseDir, this.srcDir, this.service.parent.descriptor.common);
        } else {
            javac.setSourceDir(this.service.service.baseDir, this.srcDir);
        }
        javac.setDestdir(this.classDir);
        javac.setDebug(true);
        CodeGenerator.generateJavac(javac);
        javac.execute();
    }

    final void generateWSDL(WsTool wsgen) throws Exception {
        assert (this.service.service.wsdl.isEmpty());
        File wsdlDir = new File(this.webInfDir, "wsdl");
        wsdlDir.mkdirs();
        for (TestEndpoint endpt : this.service.service.endpoints) {
            if (endpt.isProvider) continue;
            ArgumentListBuilder options = new ArgumentListBuilder();
            options.add("-wsdl");
            if (World.debug) {
                options.add("-verbose");
            }
            options.add("-r").add(wsdlDir);
            Path cp = new Path(World.project);
            cp.createPathElement().setLocation(this.classDir);
            cp.add(World.tool.getPath());
            cp.add(World.runtime.getPath());
            if (World.debug) {
                System.out.println("wsgen classpath arg = " + cp);
            }
            options.add("-cp").add(cp);
            options.add("-s").add(this.service.service.parent.disgardWsGenOutput ? NOWHERE : this.classDir);
            options.add("-d").add(this.service.service.parent.disgardWsGenOutput ? NOWHERE : this.classDir);
            File report = new File(wsdlDir, "wsgen.report");
            options.add("-XwsgenReport").add(report);
            options.addAll(this.service.service.parent.wsgenOptions);
            options.add(endpt.className);
            System.out.println("Generating WSDL");
            if (World.debug) {
                System.out.println(options);
            }
            options.invoke(wsgen);
            Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(report);
            this.wsdl.add(new File(dom.getDocumentElement().getElementsByTagName("wsdl").item(0).getTextContent().trim()));
        }
    }
}

