/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container;

import com.sun.istack.NotNull;
import com.sun.xml.ws.test.World;
import com.sun.xml.ws.test.container.ApplicationContainer;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.container.WAR;
import com.sun.xml.ws.test.container.jelly.EndpointInfoBean;
import com.sun.xml.ws.test.model.TestService;
import com.sun.xml.ws.test.tool.WsTool;
import com.sun.xml.ws.test.util.WSITUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractApplicationContainer
implements ApplicationContainer {
    private final WsTool wsimport;
    private final WsTool wsgen;
    private final Set<String> unsupportedUses;
    private final boolean httpspi;

    protected AbstractApplicationContainer(WsTool wsimport, WsTool wsgen, boolean httpspi) {
        this.wsimport = wsimport;
        this.wsgen = wsgen;
        this.unsupportedUses = new HashSet<String>();
        this.httpspi = httpspi;
    }

    @Override
    @NotNull
    public Set<String> getUnsupportedUses() {
        return this.unsupportedUses;
    }

    protected WAR assembleWar(DeployedService service) throws Exception {
        File[] externalMetadataFiles;
        WAR war = new WAR(service);
        boolean fromJava = service.service.wsdl.isEmpty();
        if (!fromJava) {
            war.compileWSDL(this.wsimport);
        }
        if (!this.isSkipMode()) {
            war.compileJavac();
        }
        if ((externalMetadataFiles = this.getExternalMetadataFiles(service.service)) != null) {
            war.copyToClasses(externalMetadataFiles);
            this.updateWsgenOpts(service.service);
        }
        if (fromJava) {
            war.generateWSDL(this.wsgen);
        }
        if (!this.isSkipMode()) {
            List<EndpointInfoBean> endpoints = null;
            File configuredSunJaxwsXml = service.service.getConfiguredFile("sun-jaxws.xml");
            if (configuredSunJaxwsXml == null) {
                endpoints = war.getEndpointsInfos();
                war.generateSunJaxWsXml(endpoints);
            } else {
                war.copyToWEBINF(configuredSunJaxwsXml);
            }
            File configuredWebXml = service.service.getConfiguredFile("web.xml");
            if (configuredWebXml == null) {
                if (endpoints == null) {
                    endpoints = war.getEndpointsInfos();
                }
                war.generateWebXml(endpoints, this.httpspi);
            } else {
                war.copyToWEBINF(configuredWebXml);
            }
            PrintWriter w = new PrintWriter(new FileWriter(new File(war.root, "index.html")));
            w.println("<html><body>Deployed by the JAX-WS test harness</body></html>");
            w.close();
        }
        war.copyToClasses(service.service.getHandlerConfiguration());
        war.copyResources(service.getResources());
        return war;
    }

    protected void updateWsgenOpts(TestService service) {
        if (service.parent.metadatafiles != null) {
            for (String path : service.parent.metadatafiles) {
                service.parent.wsgenOptions.add("-x");
                service.parent.wsgenOptions.add(path);
            }
        }
    }

    protected void updateWsitClient(WAR war, DeployedService deployedService, String id) throws Exception {
        File wsitClientFile = new File(deployedService.getResources(), "wsit-client.xml");
        if (!wsitClientFile.exists()) {
            throw new RuntimeException("wsit-client.xml is absent. It is required. \nPlease check " + deployedService.getResources());
        }
        WSITUtil.updateWsitClient(wsitClientFile, id, deployedService.service.wsdl.get((int)0).wsdlFile.toURI().toString());
        war.copyWsit(wsitClientFile);
    }

    private File[] getExternalMetadataFiles(TestService service) {
        ArrayList<File> files = null;
        if (service.parent.metadatafiles != null) {
            for (String path : service.parent.metadatafiles) {
                if (files == null) {
                    files = new ArrayList<File>();
                }
                files.add(new File(service.getAbsolutePath(path)));
            }
        }
        return files == null ? null : files.toArray(new File[files.size()]);
    }

    private boolean isSkipMode() {
        return this.wsgen.isNoop() && this.wsimport.isNoop();
    }

    protected final WAR createWARZip(DeployedService service, File archive) throws Exception {
        WAR assembly = this.assembleWar(service);
        if (this.copyRuntimeLibraries()) {
            System.out.println("Copying runtime libraries");
            assembly.copyClasspath(World.runtime);
        }
        System.out.println("Assembling a war file");
        assembly.zipTo(archive);
        return assembly;
    }

    protected boolean copyRuntimeLibraries() {
        return false;
    }
}

