/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.tool;

import com.sun.istack.test.Which;
import com.sun.xml.ws.test.World;
import com.sun.xml.ws.test.tool.WsTool;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

final class LocalWsTool
extends WsTool {
    private final Method main;

    public LocalWsTool(String className, boolean dumpParameters) {
        super(dumpParameters);
        try {
            Class wsimport = World.tool.loadClass(className);
            System.out.println("Using " + Which.which((Class)wsimport));
            this.main = wsimport.getMethod("doMain", String[].class);
            Thread.currentThread().setContextClassLoader(World.tool.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new Error("Unable to find tool " + className, e);
        }
        catch (NoSuchMethodException e) {
            throw new Error("No main method on " + className, e);
        }
    }

    @Override
    public void invoke(String ... args) throws Exception {
        int r;
        if (this.dumpParams()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(this.main.getDeclaringClass().getName() + "#" + this.main.getName() + "()");
            params.addAll(Arrays.asList(args));
            this.dumpWsParams(params);
        }
        if ((r = ((Integer)this.main.invoke(null, new Object[]{args})).intValue()) != 0) {
            LocalWsTool.assertEquals((String)("wsimport reported exit code " + r), (int)0, (int)r);
        }
    }
}

