/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.exec;

import com.sun.xml.ws.test.container.DeploymentContext;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

abstract class Executor
extends TestCase {
    public final DeploymentContext context;
    private Map<String, String> systemProperties;

    protected void setUp() throws Exception {
        this.setSystemProperties(this.context.descriptor.systemProperties);
    }

    protected void tearDown() throws Exception {
        this.rollBackSystemProperties();
    }

    protected Executor(String name, DeploymentContext context) {
        super(context.descriptor.name + "." + name);
        this.context = context;
    }

    public abstract void runTest() throws Throwable;

    protected final File makeWorkDir(String dirName) {
        File gensrcDir = new File(this.context.workDir, dirName);
        gensrcDir.mkdirs();
        return gensrcDir;
    }

    final void setSystemProperties(Collection<String> propertiesList) {
        this.systemProperties = new HashMap<String, String>();
        for (String property : propertiesList) {
            String[] parts = property.split("=");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Bad system property: " + property);
            }
            String name = parts[0];
            String newValue = parts[1];
            if (name == null || name.isEmpty() || newValue == null || newValue.isEmpty()) {
                throw new IllegalArgumentException("Bad system property: " + property);
            }
            String currentValue = System.getProperty(name);
            this.systemProperties.put(name, currentValue);
            System.setProperty(name, newValue);
        }
    }

    final void rollBackSystemProperties() {
        for (String name : this.systemProperties.keySet()) {
            String value = this.systemProperties.get(name);
            if (value != null) {
                System.setProperty(name, value);
                continue;
            }
            System.clearProperty(name);
        }
    }
}

