/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container.cargo;

import com.sun.xml.ws.test.container.cargo.AbstractCargoContainer;
import com.sun.xml.ws.test.tool.WsTool;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.Random;
import org.codehaus.cargo.container.LocalContainer;

abstract class AbstractRunnableCargoContainer<C extends LocalContainer>
extends AbstractCargoContainer<C> {
    protected final int httpPort;

    protected AbstractRunnableCargoContainer(WsTool wsimport, WsTool wsgen, int port, boolean httpspi) {
        super(wsimport, wsgen, httpspi);
        this.httpPort = port < 0 ? AbstractRunnableCargoContainer.getFreePort() : port;
    }

    @Override
    public void start() throws Exception {
        System.out.println("Starting " + ((LocalContainer)this.container).getId());
        ((LocalContainer)this.container).start();
    }

    @Override
    public void shutdown() throws Exception {
        System.out.println("Stopping " + ((LocalContainer)this.container).getId());
        ((LocalContainer)this.container).stop();
    }

    @Override
    protected URL getServiceUrl(String contextPath) throws Exception {
        return new URL(Boolean.getBoolean("harness.useSSL") ? "https" : "http", "localhost", this.httpPort, "/" + contextPath + "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findFreePort(int x) {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(x);
            int n = ss.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    public static int getFreePort() {
        for (int i = 0; i < 10; ++i) {
            int p = AbstractRunnableCargoContainer.findFreePort(new Random().nextInt(40000) + 20000);
            if (p <= 0) continue;
            return p;
        }
        System.err.println("Couldn't find free port");
        return -1;
    }
}

