/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.container;

import com.sun.istack.NotNull;
import com.sun.xml.ws.test.container.ApplicationContainer;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.model.TestDescriptor;
import com.sun.xml.ws.test.model.TestService;
import com.sun.xml.ws.test.tool.WsTool;
import com.sun.xml.ws.test.util.FileUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DeploymentContext {
    @NotNull
    public final TestDescriptor descriptor;
    @NotNull
    public final ApplicationContainer container;
    @NotNull
    public final WsTool wsimport;
    public final Map<TestService, DeployedService> services;
    public ClassLoader clientClassLoader;
    public final File workDir;
    private File resources = null;

    public DeploymentContext(TestDescriptor descriptor, ApplicationContainer container, WsTool wsimport) {
        this.descriptor = descriptor;
        this.container = container;
        this.wsimport = wsimport;
        this.workDir = new File(descriptor.home, "work");
        HashMap<TestService, DeployedService> services = new HashMap<TestService, DeployedService>();
        for (TestService svc : descriptor.services) {
            services.put(svc, new DeployedService(this, svc));
        }
        this.services = Collections.unmodifiableMap(services);
    }

    public void prepare(boolean clean) {
        if (clean) {
            FileUtil.deleteRecursive(this.workDir);
        }
        this.workDir.mkdirs();
        if (this.descriptor.resources != null) {
            this.resources = new File(this.workDir, "resources");
            FileUtil.copyDir(this.descriptor.resources, this.resources, null);
        }
        for (DeployedService ds : this.services.values()) {
            ds.prepare();
        }
    }

    public File getResources() {
        return this.resources;
    }
}

