/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test;

import com.sun.xml.ws.test.World;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.tools.ant.types.Path;
import org.codehaus.classworlds.ClassRealm;

public final class RealmBuilder {
    private final ClassRealm realm;
    private Path classPath;

    public RealmBuilder(ClassRealm realm, Path classPath) {
        this.realm = realm;
        this.classPath = classPath;
    }

    public RealmBuilder(ClassRealm realm) {
        this(realm, new Path(World.project));
    }

    public void addJar(File jar) throws IOException {
        if (!jar.exists()) {
            throw new IOException("No such file: " + jar);
        }
        this.realm.addConstituent(jar.toURL());
        this.classPath.createPathElement().setLocation(jar);
    }

    public void addClassFolder(File classFolder) throws IOException {
        this.addJar(classFolder);
    }

    public void addJarFolder(File folder, final String ... excludes) throws IOException {
        File[] children;
        if (!folder.isDirectory()) {
            throw new IOException("Not a directory " + folder);
        }
        for (File child : children = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                for (String name : excludes) {
                    if (!pathname.getName().equals(name)) continue;
                    return false;
                }
                return pathname.getPath().endsWith(".jar");
            }
        })) {
            this.addJar(child);
        }
    }

    public void dump(PrintStream out) {
        for (String item : this.classPath.toString().split(File.pathSeparator)) {
            out.println("  " + item);
        }
    }
}

