/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.ServerAuthConfig;
import com.sun.enterprise.security.jauth.ServerAuthContext;
import com.sun.enterprise.security.wss.WebServiceSecurity;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.webservice.SOAPMessageContext;
import com.sun.enterprise.webservice.SOAPMessageContextImpl;
import com.sun.enterprise.webservice.ServletWSSecurityPipe;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.JavaMethod;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterPipeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.policy.PolicyMap;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class ServletWSSecurityPipe
extends AbstractFilterPipeImpl {
    private static final String SERVER_AUTH_CONTEXT = "com.sun.enterprise.security.jauth.ServerAuthContext";
    protected static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.security");
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServletWSSecurityPipe.class);
    protected final HashMap propertyBag;
    protected final SEIModel seiModel;
    protected final WSDLPort wsdlModel;
    protected final WSEndpoint owner;
    protected final WebServiceEndpoint endpoint;
    protected final PolicyMap wsPolicy;
    protected ServerAuthConfig authConfig = null;

    ServletWSSecurityPipe(HashMap pBag, Pipe tail, WebServiceEndpoint ep) {
        super(tail);
        this.propertyBag = pBag;
        this.endpoint = ep;
        this.seiModel = (SEIModel)pBag.get("SEI_MODEL");
        this.wsdlModel = (WSDLPort)pBag.get("WSDL_MODEL");
        this.owner = (WSEndpoint)pBag.get("ENDPOINT");
        this.wsPolicy = (PolicyMap)pBag.get("POLICY");
        MessageSecurityBindingDescriptor binding = null;
        if (this.endpoint != null) {
            binding = this.endpoint.getMessageSecurityBinding();
            if (!this.endpoint.hasAuthMethod()) {
                try {
                    this.authConfig = ServerAuthConfig.getConfig((String)"SOAP", (MessageSecurityBindingDescriptor)binding, null);
                }
                catch (AuthException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
    }

    protected ServletWSSecurityPipe(ServletWSSecurityPipe that, PipeCloner cloner) {
        super((AbstractFilterPipeImpl)that, cloner);
        this.propertyBag = that.propertyBag;
        this.endpoint = that.endpoint;
        this.seiModel = that.seiModel;
        this.wsdlModel = that.wsdlModel;
        this.owner = that.owner;
        this.wsPolicy = that.wsPolicy;
        this.authConfig = that.authConfig;
    }

    public Pipe copy(PipeCloner cloner) {
        return new ServletWSSecurityPipe(this, cloner);
    }

    public Packet process(Packet request) {
        if ("http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding())) {
            return this.next.process(request);
        }
        SOAPMessageContextImpl ctxt = new SOAPMessageContextImpl(request);
        Packet packet = null;
        Exception exception = null;
        try {
            ProcessResult pResult = this.processRequest(ctxt, request);
            if (pResult != null && pResult.status) {
                packet = pResult.packet;
                this.processResponse(new SOAPMessageContextImpl(pResult.packet));
            } else {
                exception = new IllegalStateException(localStrings.getLocalString("enterprise.webservice.cantValidateRequest", "Cannot validate request for {0}", new Object[]{this.wsdlModel.getName()}));
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            packet = packet.createResponse(Messages.create((Throwable)exception, (SOAPVersion)SOAPVersion.SOAP_11));
        }
        return packet;
    }

    private ProcessResult processRequest(SOAPMessageContext soapMC, Packet packet) throws Exception {
        ProcessResult pResult = new ProcessResult(this);
        boolean status = false;
        ServerAuthContext sAC = this.authConfig == null ? null : this.authConfig.getAuthContext((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC);
        try {
            if (sAC == null) {
                status = true;
            } else {
                status = WebServiceSecurity.validateRequest((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC, (ServerAuthContext)sAC);
                if (status) {
                    soapMC.put(SERVER_AUTH_CONTEXT, sAC);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "ws.error_validate_request", e);
                }
            } else {
                _logger.log(Level.SEVERE, "ws.error_validate_request", e);
            }
            throw e;
        }
        finally {
            WebServiceSecurity.auditInvocation((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC, (boolean)status);
        }
        if (status) {
            this.preInvokeEndpointHook(packet);
            pResult.packet = this.processValidatedRequest(packet, this.next);
        }
        pResult.status = status;
        return pResult;
    }

    protected void preInvokeEndpointHook(Packet packet) throws Exception {
    }

    protected Packet processValidatedRequest(Packet validatedPacket, Pipe next) throws Exception {
        Packet resultPacket = null;
        if (System.getSecurityManager() == null) {
            resultPacket = next.process(validatedPacket);
        } else {
            Packet fpacket = validatedPacket;
            Pipe fpipe = next;
            try {
                resultPacket = (Packet)Subject.doAsPrivileged(SecurityContext.getCurrent().getSubject(), new /* Unavailable Anonymous Inner Class!! */, null);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof AuthException) {
                    _logger.log(Level.SEVERE, "ws.error_secure_response", cause);
                }
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new Exception(cause);
            }
        }
        return resultPacket;
    }

    private void processResponse(SOAPMessageContext soapMC) throws Exception {
        ServerAuthContext sAC = (ServerAuthContext)soapMC.get(SERVER_AUTH_CONTEXT);
        if (sAC == null) {
            return;
        }
        try {
            WebServiceSecurity.secureResponse((javax.xml.ws.handler.soap.SOAPMessageContext)soapMC, (ServerAuthContext)sAC);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "ws.error_secure_response", e);
                }
            } else {
                _logger.log(Level.SEVERE, "ws.error_secure_response", e);
            }
            throw e;
        }
    }

    protected Method getMethod(Packet packet) {
        JavaMethod jm = packet.getMessage().getMethod(this.seiModel);
        return jm != null ? jm.getMethod() : null;
    }
}

