/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.WebServiceHandlerChain;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.deployment.types.HandlerChainContainer;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceEndpoint
extends Descriptor
implements HandlerChainContainer {
    public static final String TRANSPORT_NONE = "NONE";
    public static final String TRANSPORT_INTEGRAL = "INTEGRAL";
    public static final String TRANSPORT_CONFIDENTIAL = "CONFIDENTIAL";
    public static final String CLIENT_CERT = "CLIENT-CERT";
    public static final String SOAP11_TOKEN = "##SOAP11_HTTP";
    public static final String SOAP12_TOKEN = "##SOAP12_HTTP";
    public static final String SOAP11_MTOM_TOKEN = "##SOAP11_HTTP_MTOM";
    public static final String SOAP12_MTOM_TOKEN = "##SOAP12_HTTP_MTOM";
    public static final String XML_TOKEN = "##XML_HTTP";
    public static final String PUBLISHING_SUBCONTEXT = "__container$publishing$subctx";
    private String endpointName;
    private String serviceEndpointInterface;
    private QName wsdlPort;
    private String wsdlPortNamespacePrefix;
    private QName wsdlService;
    private String wsdlServiceNamespacePrefix;
    private String mtomEnabled = null;
    private String protocolBinding = null;
    private String ejbLink;
    private EjbDescriptor ejbComponentImpl;
    private String webComponentLink;
    private WebComponentDescriptor webComponentImpl;
    private LinkedList handlers;
    private LinkedList<WebServiceHandlerChain> handlerChains;
    private WebService webService;
    private String endpointAddressUri;
    private String authMethod;
    private String realm;
    private String transportGuarantee;
    private String serviceNamespaceUri;
    private String serviceLocalPart;
    private String servletImplClass;
    private String tieClassName;
    private MessageSecurityBindingDescriptor messageSecBindingDesc = null;
    private String debuggingEnabled = "true";
    private List props = null;

    public WebServiceEndpoint(WebServiceEndpoint other) {
        super(other);
        this.endpointName = other.endpointName;
        this.serviceEndpointInterface = other.serviceEndpointInterface;
        this.wsdlPort = other.wsdlPort;
        this.wsdlPortNamespacePrefix = other.wsdlPortNamespacePrefix;
        this.wsdlService = other.wsdlService;
        this.wsdlServiceNamespacePrefix = other.wsdlServiceNamespacePrefix;
        this.mtomEnabled = other.mtomEnabled;
        this.protocolBinding = other.protocolBinding;
        this.ejbLink = other.ejbLink;
        this.ejbComponentImpl = other.ejbComponentImpl;
        this.webComponentLink = other.webComponentLink;
        this.webComponentImpl = other.webComponentImpl;
        this.handlers = other.handlers;
        if (other.handlers != null) {
            this.handlers = new LinkedList();
            for (WebServiceHandler webServiceHandler : other.handlers) {
                this.handlers.addLast(new WebServiceHandler(webServiceHandler));
            }
        } else {
            this.handlers = null;
        }
        if (other.handlerChains != null) {
            this.handlerChains = new LinkedList();
            for (WebServiceHandlerChain webServiceHandlerChain : other.handlerChains) {
                this.handlerChains.addLast(new WebServiceHandlerChain(webServiceHandlerChain));
            }
        } else {
            this.handlers = null;
        }
        this.webService = other.webService;
        this.endpointAddressUri = other.endpointAddressUri;
        this.authMethod = other.authMethod;
        this.transportGuarantee = other.transportGuarantee;
        this.serviceNamespaceUri = other.serviceNamespaceUri;
        this.serviceLocalPart = other.serviceLocalPart;
        this.servletImplClass = other.servletImplClass;
        this.tieClassName = other.tieClassName;
    }

    public WebServiceEndpoint() {
        this.handlers = new LinkedList();
        this.handlerChains = new LinkedList();
        this.authMethod = null;
        this.wsdlPort = null;
    }

    public void setWebService(WebService service) {
        this.webService = service;
        super.changed();
    }

    public WebService getWebService() {
        return this.webService;
    }

    public void setEndpointName(String name) {
        this.endpointName = name;
        super.changed();
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setServiceEndpointInterface(String endpointInterface) {
        this.serviceEndpointInterface = endpointInterface;
        super.changed();
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void setProtocolBinding(String value) {
        this.protocolBinding = SOAP11_TOKEN.equals(value) ? "http://schemas.xmlsoap.org/wsdl/soap/http" : (SOAP11_MTOM_TOKEN.equals(value) ? "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true" : (SOAP12_TOKEN.equals(value) ? "http://www.w3.org/2003/05/soap/bindings/HTTP/" : (SOAP12_MTOM_TOKEN.equals(value) ? "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true" : (XML_TOKEN.equals(value) ? "http://www.w3.org/2004/08/wsdl/http" : value))));
        super.changed();
    }

    public String getProtocolBinding() {
        return this.protocolBinding == null ? "http://schemas.xmlsoap.org/wsdl/soap/http" : this.protocolBinding;
    }

    public boolean hasUserSpecifiedProtocolBinding() {
        return this.protocolBinding != null;
    }

    public void setMtomEnabled(String value) {
        this.mtomEnabled = value;
        super.changed();
    }

    public String getMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setWsdlService(QName svc, String prefix) {
        this.wsdlService = svc;
        this.wsdlServiceNamespacePrefix = prefix;
        this.serviceNamespaceUri = svc.getNamespaceURI();
        this.serviceLocalPart = svc.getLocalPart();
        super.changed();
    }

    public void setWsdlService(QName service) {
        this.wsdlService = service;
        this.wsdlServiceNamespacePrefix = service.getPrefix();
        this.serviceNamespaceUri = service.getNamespaceURI();
        this.serviceLocalPart = service.getLocalPart();
        super.changed();
    }

    public String getWsdlServiceNamespacePrefix() {
        return this.wsdlServiceNamespacePrefix;
    }

    public boolean hasWsdlServiceNamespacePrefix() {
        return this.wsdlServiceNamespacePrefix != null;
    }

    public QName getWsdlService() {
        return this.wsdlService;
    }

    public void setWsdlPort(QName port, String prefix) {
        this.wsdlPort = port;
        this.wsdlPortNamespacePrefix = prefix;
        super.changed();
    }

    public void setWsdlPort(QName port) {
        this.wsdlPort = port;
        this.wsdlPortNamespacePrefix = port.getPrefix();
        super.changed();
    }

    public String getWsdlPortNamespacePrefix() {
        return this.wsdlPortNamespacePrefix;
    }

    public boolean hasWsdlPortNamespacePrefix() {
        return this.wsdlPortNamespacePrefix != null;
    }

    public boolean hasWsdlPort() {
        return this.wsdlPort != null;
    }

    public QName getWsdlPort() {
        return this.wsdlPort;
    }

    public void setMessageSecurityBinding(MessageSecurityBindingDescriptor messageSecBindingDesc) {
        this.messageSecBindingDesc = messageSecBindingDesc;
    }

    public MessageSecurityBindingDescriptor getMessageSecurityBinding() {
        return this.messageSecBindingDesc;
    }

    public boolean resolveComponentLink() {
        WebBundleDescriptor webBundle;
        WebComponentDescriptor webComponent;
        boolean resolved = false;
        if (this.ejbLink != null) {
            EjbBundleDescriptor ejbBundle = this.getEjbBundle();
            if (ejbBundle.hasEjbByName(this.ejbLink)) {
                resolved = true;
                EjbDescriptor ejb = ejbBundle.getEjbByName(this.ejbLink);
                this.setEjbComponentImpl(ejb);
            }
        } else if (this.webComponentLink != null && (webComponent = (webBundle = this.getWebBundle()).getWebComponentByCanonicalName(this.webComponentLink)) != null) {
            resolved = true;
            this.setWebComponentImpl(webComponent);
        }
        super.changed();
        return resolved;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.getWebService().getBundleDescriptor();
    }

    private EjbBundleDescriptor getEjbBundle() {
        return (EjbBundleDescriptor)this.getBundleDescriptor();
    }

    private WebBundleDescriptor getWebBundle() {
        return (WebBundleDescriptor)this.getBundleDescriptor();
    }

    public boolean implementedByEjbComponent() {
        return this.ejbLink != null;
    }

    public boolean implementedByEjbComponent(EjbDescriptor ejb) {
        return this.ejbLink != null && this.ejbLink.equals(ejb.getName());
    }

    public boolean implementedByWebComponent() {
        return this.webComponentLink != null;
    }

    public boolean implementedByWebComponent(WebComponentDescriptor webComp) {
        return this.webComponentLink != null && this.webComponentLink.equals(webComp.getCanonicalName());
    }

    public String getLinkName() {
        String linkName = null;
        if (this.implementedByEjbComponent()) {
            linkName = this.ejbLink;
        } else if (this.implementedByWebComponent()) {
            linkName = this.webComponentLink;
        }
        return linkName;
    }

    public void setEjbLink(String link) {
        this.ejbLink = link;
        super.changed();
    }

    public String getEjbLink() {
        return this.ejbLink;
    }

    public void setEjbComponentImpl(EjbDescriptor ejbComponent) {
        this.webComponentImpl = null;
        this.webComponentLink = null;
        this.ejbLink = ejbComponent.getName();
        this.ejbComponentImpl = ejbComponent;
        super.changed();
    }

    public EjbDescriptor getEjbComponentImpl() {
        return this.ejbComponentImpl;
    }

    public void setWebComponentLink(String link) {
        this.webComponentLink = link;
        super.changed();
    }

    public String getWebComponentLink() {
        return this.webComponentLink;
    }

    public void setWebComponentImpl(WebComponentDescriptor webComponent) {
        this.ejbComponentImpl = null;
        this.ejbLink = null;
        this.webComponentLink = webComponent.getCanonicalName();
        this.webComponentImpl = webComponent;
        super.changed();
    }

    public WebComponentDescriptor getWebComponentImpl() {
        return this.webComponentImpl;
    }

    public boolean hasHandlers() {
        return this.handlers.size() > 0;
    }

    public void addHandler(WebServiceHandler handler) {
        this.handlers.addLast(handler);
        super.changed();
    }

    public void removeHandler(WebServiceHandler handler) {
        this.handlers.remove(handler);
        super.changed();
    }

    public void removeHandlerByName(String handlerName) {
        Iterator iter = this.handlers.iterator();
        while (iter.hasNext()) {
            WebServiceHandler next = (WebServiceHandler)iter.next();
            if (!next.getHandlerName().equals(handlerName)) continue;
            iter.remove();
            super.changed();
            break;
        }
    }

    public LinkedList getHandlers() {
        return this.handlers;
    }

    public LinkedList<WebServiceHandlerChain> getHandlerChain() {
        return this.handlerChains;
    }

    public boolean hasHandlerChain() {
        return this.handlerChains.size() > 0;
    }

    public void addHandlerChain(WebServiceHandlerChain handlerChain) {
        this.handlerChains.addLast(handlerChain);
        super.changed();
    }

    public void removeHandlerChain(WebServiceHandlerChain handlerChain) {
        this.handlerChains.remove(handlerChain);
        super.changed();
    }

    public boolean hasEndpointAddressUri() {
        return this.endpointAddressUri != null;
    }

    public void setEndpointAddressUri(String uri) {
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        this.endpointAddressUri = uri;
        super.changed();
    }

    public String getEndpointAddressUri() {
        return this.endpointAddressUri;
    }

    public boolean isSecure() {
        return this.hasTransportGuarantee() && (this.transportGuarantee.equals(TRANSPORT_INTEGRAL) || this.transportGuarantee.equals(TRANSPORT_CONFIDENTIAL));
    }

    public URL composeEndpointAddress(URL root) throws MalformedURLException {
        String uri = null;
        if (this.implementedByWebComponent()) {
            WebBundleDescriptor webBundle;
            String contextRoot;
            if (this.endpointAddressUri == null) {
                this.updateServletEndpointRuntime();
            }
            if ((contextRoot = (webBundle = this.webComponentImpl.getWebBundleDescriptor()).getContextRoot()) != null) {
                if (!contextRoot.startsWith("/")) {
                    contextRoot = "/" + contextRoot;
                }
                uri = contextRoot + (this.endpointAddressUri.startsWith("/") ? this.endpointAddressUri : "/" + this.endpointAddressUri);
            }
        } else if (this.hasEndpointAddressUri()) {
            uri = this.endpointAddressUri.startsWith("/") ? this.endpointAddressUri : "/" + this.endpointAddressUri;
        } else {
            uri = "/" + this.getWebService().getName() + "/" + this.getEndpointName();
            this.setEndpointAddressUri(uri);
        }
        URL endpointAddressURL = new URL(root.getProtocol(), root.getHost(), root.getPort(), uri);
        return endpointAddressURL;
    }

    public URL composeFinalWsdlUrl(URL root) throws MalformedURLException {
        URL context = this.composeEndpointAddress(root);
        String mainFile = context.getFile() + "/" + PUBLISHING_SUBCONTEXT + "/" + this.webService.getWsdlFileUri();
        URL finalWsdlUrl = new URL(context.getProtocol(), context.getHost(), context.getPort(), mainFile);
        return finalWsdlUrl;
    }

    public String getPublishingUri() {
        String uri = this.endpointAddressUri.startsWith("/") ? this.endpointAddressUri.substring(1) : this.endpointAddressUri;
        return uri + "/" + PUBLISHING_SUBCONTEXT;
    }

    public boolean matchesEjbPublishRequest(String requestUriRaw, String query) {
        String requestUri = requestUriRaw.charAt(0) == '/' ? requestUriRaw.substring(1) : requestUriRaw;
        boolean matches = false;
        if (query != null) {
            String toMatch = this.endpointAddressUri.charAt(0) == '/' ? this.endpointAddressUri.substring(1) : this.endpointAddressUri;
            matches = requestUri.equals(toMatch) && (query.equalsIgnoreCase("WSDL") || query.startsWith("xsd=") || query.startsWith("wsdl="));
        } else {
            String publishingUri = this.getPublishingUri() + "/";
            matches = requestUri.startsWith(publishingUri);
        }
        return matches;
    }

    public String getWsdlContentPath(String requestUri) {
        String uri = requestUri.charAt(0) == '/' ? requestUri.substring(1) : requestUri;
        String publishingUriRaw = this.getPublishingUri();
        String publishingRoot = null;
        if (this.implementedByWebComponent()) {
            WebBundleDescriptor webBundle = this.webComponentImpl.getWebBundleDescriptor();
            String contextRoot = webBundle.getContextRoot();
            if (contextRoot.startsWith("/")) {
                contextRoot = contextRoot.substring(1);
            }
            publishingRoot = contextRoot + "/" + publishingUriRaw + "/";
        } else {
            publishingRoot = publishingUriRaw + "/";
        }
        String wsdlPath = uri.startsWith(publishingRoot) ? uri.substring(publishingRoot.length()) : null;
        return wsdlPath;
    }

    public void setAuthMethod(String authType) {
        this.authMethod = authType;
        super.changed();
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public boolean hasAuthMethod() {
        return this.authMethod != null;
    }

    public boolean hasBasicAuth() {
        return this.authMethod != null && this.authMethod.equals("BASIC");
    }

    public boolean hasClientCertAuth() {
        return this.authMethod != null && this.authMethod.equals(CLIENT_CERT);
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setTransportGuarantee(String guarantee) {
        this.transportGuarantee = guarantee;
        super.changed();
    }

    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public boolean hasTransportGuarantee() {
        return this.transportGuarantee != null;
    }

    public void setServiceNamespaceUri(String uri) {
        this.serviceNamespaceUri = uri;
        super.changed();
    }

    public void setServiceLocalPart(String localpart) {
        this.serviceLocalPart = localpart;
        super.changed();
    }

    public boolean hasServiceName() {
        return this.serviceNamespaceUri != null && this.serviceLocalPart != null;
    }

    public QName getServiceName() {
        return this.hasServiceName() ? new QName(this.serviceNamespaceUri, this.serviceLocalPart) : null;
    }

    public void saveServletImplClass() {
        if (!this.implementedByWebComponent()) {
            throw new IllegalStateException("requires ejb");
        }
        this.servletImplClass = this.webComponentImpl.getWebComponentImplementation();
        super.changed();
    }

    public boolean hasServletImplClass() {
        return this.servletImplClass != null;
    }

    public void setServletImplClass(String implClass) {
        this.servletImplClass = implClass;
        super.changed();
    }

    public String getServletImplClass() {
        return this.servletImplClass;
    }

    public boolean hasTieClassName() {
        return this.tieClassName != null;
    }

    public void setTieClassName(String tieClass) {
        this.tieClassName = tieClass;
    }

    public String getTieClassName() {
        return this.tieClassName;
    }

    public String getDebugging() {
        return this.debuggingEnabled;
    }

    public void setDebugging(String debuggingEnabled) {
        this.debuggingEnabled = debuggingEnabled;
    }

    public void addProperty(NameValuePairDescriptor newProp) {
        if (this.props == null) {
            this.props = new ArrayList();
        }
        this.props.add(newProp);
    }

    public Iterator getProperties() {
        if (this.props == null) {
            return null;
        }
        return this.props.iterator();
    }

    private void updateServletEndpointRuntime() {
        this.saveServletImplClass();
        WebComponentDescriptor webComp = this.getWebComponentImpl();
        WebBundleDescriptor bundle = webComp.getWebBundleDescriptor();
        WebServicesDescriptor webServices = bundle.getWebServices();
        Collection<WebServiceEndpoint> endpoints = webServices.getEndpointsImplementedBy(webComp);
        if (endpoints.size() > 1) {
            String msg = "Servlet " + this.getWebComponentLink() + " implements " + endpoints.size() + " web service endpoints " + " but must only implement 1";
            throw new IllegalStateException(msg);
        }
        if (this.getEndpointAddressUri() == null) {
            Set urlPatterns = webComp.getUrlPatternsSet();
            if (urlPatterns.size() == 1) {
                String uri = (String)urlPatterns.iterator().next();
                this.setEndpointAddressUri(uri);
                Collection constraints = bundle.getSecurityConstraintsForUrlPattern(uri);
                for (SecurityConstraint next : constraints) {
                    UserDataConstraint dataConstraint = next.getUserDataConstraint();
                    String guarantee = dataConstraint != null ? dataConstraint.getTransportGuarantee() : null;
                    if (guarantee == null || !guarantee.equals(TRANSPORT_INTEGRAL) && !guarantee.equals(TRANSPORT_CONFIDENTIAL)) continue;
                    this.setTransportGuarantee(guarantee);
                    break;
                }
            } else {
                String msg = "Endpoint " + this.getEndpointName() + " has not been assigned an endpoint address " + " and is associated with servlet " + webComp.getCanonicalName() + " , which has " + urlPatterns.size() + " url patterns";
                throw new IllegalStateException(msg);
            }
        }
    }

    public String getSoapAddressPrefix() {
        if ("http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(this.protocolBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(this.protocolBinding) || SOAP12_TOKEN.equals(this.protocolBinding) || SOAP12_MTOM_TOKEN.equals(this.protocolBinding)) {
            return "soap12";
        }
        return "soap";
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n endpoint name = ").append(this.endpointName);
        toStringBuffer.append("\n endpoint intf = ").append(this.serviceEndpointInterface);
        toStringBuffer.append("\n wsdl Port = ").append(this.wsdlPort);
        toStringBuffer.append("\n ejb Link = ").append(this.ejbLink);
        toStringBuffer.append("\n web Link = ").append(this.webComponentLink);
    }
}

