/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server;

import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleModule;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.server.ServerContext;
import com.sun.web.security.RealmAdapter;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;

public class LifecycleModuleService
implements ServerLifecycle {
    static final String DELAY_LIFECYCLE_INIT = "com.sun.enterprise.server.DelayLifecycleInit";
    static String lifeCycleVersion = System.getProperty("com.sun.enterprise.server.DelayLifecycleInit", "false");
    protected static boolean delayLifeCycleInit = new Boolean(lifeCycleVersion);
    private ArrayList listeners = new ArrayList();

    protected boolean lifeCycleVersionMatches() {
        return !delayLifeCycleInit;
    }

    public synchronized void onInitialization(ServerContext context) throws ServerLifecycleException {
        if (!this.lifeCycleVersionMatches()) {
            return;
        }
        try {
            Applications apps = ServerBeansFactory.getApplicationsBean((ConfigContext)context.getConfigContext());
            if (apps == null) {
                return;
            }
            LifecycleModule[] lcms = apps.getLifecycleModule();
            if (lcms == null) {
                return;
            }
            HashSet<ServerLifecycleModule> listenerSet = new HashSet<ServerLifecycleModule>();
            for (int i = 0; i < lcms.length; ++i) {
                LifecycleModule next = lcms[i];
                if (!this.isEnabled(next, context.getConfigContext())) continue;
                int order = Integer.MAX_VALUE;
                String strOrder = next.getLoadOrder();
                if (strOrder != null) {
                    try {
                        order = Integer.parseInt(strOrder);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                }
                ServerLifecycleModule slcm = new ServerLifecycleModule(context, next.getName(), next.getClassName());
                slcm.setLoadOrder(order);
                slcm.setClasspath(next.getClasspath());
                slcm.setIsFatal(next.isIsFailureFatal());
                ElementProperty[] s = next.getElementProperty();
                if (s != null) {
                    for (int j = 0; j < s.length; ++j) {
                        ElementProperty next1 = s[j];
                        slcm.setProperty(next1.getName(), next1.getValue());
                    }
                }
                LifecycleListener listener = slcm.loadServerLifecycle();
                listenerSet.add(slcm);
            }
            this.sortModules(listenerSet);
        }
        catch (Exception ce1) {
            ce1.printStackTrace();
        }
        this.initialize(context);
    }

    private boolean isEnabled(LifecycleModule lcm, ConfigContext config) {
        try {
            if (lcm == null || config == null) {
                return false;
            }
            Server server = ServerBeansFactory.getServerBean((ConfigContext)config);
            ApplicationRef appRef = server.getApplicationRefByRef(lcm.getName());
            return lcm.isEnabled() && appRef != null && appRef.isEnabled();
        }
        catch (ConfigException e) {
            return false;
        }
    }

    private void resetClassLoader(ClassLoader c) {
        AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    private void sortModules(HashSet listenerSet) {
        for (ServerLifecycleModule next : listenerSet) {
            int i;
            int order = next.getLoadOrder();
            for (i = 0; i < this.listeners.size() && ((ServerLifecycleModule)this.listeners.get(i)).getLoadOrder() <= order; ++i) {
            }
            this.listeners.add(i, next);
        }
    }

    private void initialize(ServerContext context) throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (ServerLifecycleModule next : this.listeners) {
            next.onInitialization(context);
        }
        this.resetClassLoader(cl);
    }

    public void onStartup(ServerContext context) throws ServerLifecycleException {
        if (!this.lifeCycleVersionMatches()) {
            return;
        }
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (ServerLifecycleModule next : this.listeners) {
            StandardContext invocationContext = new StandardContext();
            WebBundleDescriptor wbd = new WebBundleDescriptor();
            Application.createApplication((String)next.getName(), (ModuleDescriptor)wbd.getModuleDescriptor());
            invocationContext.setRealm((Realm)new RealmAdapter(wbd, false));
            next.onStartup(context, (Context)invocationContext);
        }
        this.resetClassLoader(cl);
    }

    public void onReady(ServerContext context) throws ServerLifecycleException {
        if (!this.lifeCycleVersionMatches()) {
            return;
        }
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (ServerLifecycleModule next : this.listeners) {
            next.onReady(context);
        }
        this.resetClassLoader(cl);
    }

    public void onShutdown() throws ServerLifecycleException {
        if (!this.lifeCycleVersionMatches()) {
            return;
        }
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (ServerLifecycleModule next : this.listeners) {
            next.onShutdown();
        }
        this.resetClassLoader(cl);
    }

    public void onTermination() throws ServerLifecycleException {
        if (!this.lifeCycleVersionMatches()) {
            return;
        }
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (ServerLifecycleModule next : this.listeners) {
            next.onTermination();
        }
        this.resetClassLoader(cl);
    }
}

