/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.WebServiceHandlerChain;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.AdminAdapter;
import com.sun.enterprise.v3.admin.adapter.AdminConsoleAdapter;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.model.Model;
import com.sun.xml.rpc.spi.model.Port;
import com.sun.xml.rpc.spi.model.Service;
import com.sun.xml.rpc.spi.runtime.SOAPConstants;
import com.sun.xml.rpc.spi.runtime.StreamingHandler;
import com.sun.xml.rpc.spi.runtime.Tie;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.SDDocumentSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.soap.SOAPBinding;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Adapter;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.web.deployment.util.VirtualServerInfo;
import org.glassfish.web.deployment.util.WebServerInfo;
import org.glassfish.web.util.HtmlEntityEncoder;
import org.glassfish.webservices.HandlerResolverImpl;
import org.glassfish.webservices.Import;
import org.glassfish.webservices.JAXWSServlet;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.PortInfoImpl;
import org.glassfish.webservices.WebServiceContractImpl;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WsUtil {
    public static final String CLIENT_TRANSPORT_LOG_PROPERTY = "com.sun.enterprise.webservice.client.transport.log";
    public static final String ENDPOINT_ADDRESS_PARAM_NAME = "endpointAddressParam";
    public final String WSDL_IMPORT_NAMESPACE_PARAM_NAME = "wsdlImportNamespaceParam";
    public static final String WSDL_IMPORT_LOCATION_PARAM_NAME = "wsdlImportLocationParam";
    public static final String WSDL_INCLUDE_LOCATION_PARAM_NAME = "wsdlIncludeLocationParam";
    public final String SCHEMA_IMPORT_NAMESPACE_PARAM_NAME = "schemaImportNamespaceParam";
    public static final String SCHEMA_IMPORT_LOCATION_PARAM_NAME = "schemaImportLocationParam";
    public static final String SCHEMA_INCLUDE_LOCATION_PARAM_NAME = "schemaIncludeLocationParam";
    private Config config = WebServiceContractImpl.getInstance().getConfig();
    private List<NetworkListener> networkListeners = null;
    private static final String ONE_WAY_OPERATION = "com.sun.xml.rpc.server.OneWayOperation";
    private static final String CLIENT_BAD_REQUEST = "com.sun.xml.rpc.server.http.ClientBadRequest";
    private static final String SECURITY_POLICY_NAMESPACE_URI = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy";
    private static final Logger logger = LogUtils.getLogger();
    private JaxRpcObjectFactory rpcFactory;
    static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WsUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleGet(HttpServletRequest request, HttpServletResponse response, WebServiceEndpoint endpoint) throws IOException {
        MimeHeaders headers = this.getHeaders(request);
        if (this.hasSomeTextXmlContent(headers)) {
            String message = MessageFormat.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00094"), endpoint.getEndpointName(), endpoint.getEndpointAddressUri());
            this.writeInvalidMethodType(response, message);
            logger.info(message);
            return false;
        }
        URL wsdlUrl = null;
        String requestUriRaw = request.getRequestURI();
        String requestUri = requestUriRaw.charAt(0) == '/' ? requestUriRaw.substring(1) : requestUriRaw;
        String queryString = request.getQueryString();
        WebService webService = endpoint.getWebService();
        if (queryString == null) {
            String wsdlPath = endpoint.getWsdlContentPath(requestUri);
            if (wsdlPath != null) {
                ModuleDescriptor module = webService.getBundleDescriptor().getModuleDescriptor();
                if (wsdlPath.equals(webService.getWsdlFileUri())) {
                    wsdlUrl = webService.getWsdlFileUrl();
                } else if (this.isWsdlContent(wsdlPath, webService.getBundleDescriptor())) {
                    URL finalWsdlUrl = webService.getWsdlFileUrl();
                    String finalWsdlPath = finalWsdlUrl.getPath();
                    String wsdlDirPath = finalWsdlPath.substring(0, finalWsdlPath.length() - webService.getWsdlFileUri().length());
                    File wsdlDir = new File(wsdlDirPath);
                    File wsdlFile = new File(wsdlDir, wsdlPath.replace('/', File.separatorChar));
                    try {
                        wsdlUrl = wsdlFile.toURL();
                    }
                    catch (MalformedURLException mue) {
                        String msg = MessageFormat.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00096"), webService.getName());
                        logger.log(Level.INFO, msg, mue);
                    }
                }
            }
        } else if (queryString.equalsIgnoreCase("WSDL")) {
            wsdlUrl = webService.getWsdlFileUrl();
        }
        boolean success = false;
        if (wsdlUrl != null) {
            InputStream is = null;
            try {
                response.setContentType("text/xml");
                response.setStatus(200);
                if (wsdlUrl.toURI().equals(webService.getWsdlFileUrl().toURI())) {
                    try {
                        WebServerInfo wsi = this.getWebServerInfoForDAS();
                        URL url = webService.getWsdlFileUrl();
                        File originalWsdlFile = new File(url.getPath() + "__orig");
                        if (!originalWsdlFile.exists()) {
                            originalWsdlFile = new File(url.getPath());
                        }
                        this.generateFinalWsdl(originalWsdlFile.toURL(), webService, wsi, (OutputStream)response.getOutputStream());
                    }
                    catch (Exception e) {
                        URLConnection urlCon = wsdlUrl.openConnection();
                        urlCon.setUseCaches(false);
                        is = urlCon.getInputStream();
                        this.copyIsToOs(is, (OutputStream)response.getOutputStream());
                    }
                } else {
                    URLConnection urlCon = wsdlUrl.openConnection();
                    urlCon.setUseCaches(false);
                    is = urlCon.getInputStream();
                    this.copyIsToOs(is, (OutputStream)response.getOutputStream());
                }
                success = true;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "AS-WSJSR109IMPL-00095", new Object[]{wsdlUrl, request.getRequestURL() + (queryString != null ? "?" + queryString : "")});
                }
            }
            catch (Exception e) {
                String msg = MessageFormat.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00096"), webService.getName());
                logger.log(Level.INFO, msg, e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        if (!success) {
            String message = MessageFormat.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00097"), request.getRequestURL() + (queryString != null ? "?" + queryString : ""), webService.getName());
            logger.info(message);
            this.writeInvalidMethodType(response, message);
        }
        return success;
    }

    private void copyIsToOs(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[4096];
        int len = 0;
        while (len != -1) {
            try {
                len = is.read(buf, 0, buf.length);
            }
            catch (EOFException eof) {
                break;
            }
            if (len == -1) continue;
            os.write(buf, 0, len);
        }
        os.flush();
        is.close();
        os.close();
    }

    public boolean isWsdlContent(String uri, BundleDescriptor bundle) {
        String wsdlDir = this.getWsdlDir(bundle);
        return uri != null && uri.startsWith(wsdlDir);
    }

    public String getWsdlDir(BundleDescriptor bundle) {
        boolean isWar = bundle.getModuleType().equals((Object)DOLUtils.warType());
        return isWar ? "WEB-INF/wsdl" : "META-INF/wsdl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseRelativeImports(URL wsdlFileUrl, Collection wsdlRelativeImports, Collection wsdlIncludes, Collection schemaRelativeImports, Collection schemaIncludes) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        InputStream is = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            is = wsdlFileUrl.openStream();
            Document document = builder.parse(is);
            this.procesSchemaImports(document, schemaRelativeImports);
            this.procesWsdlImports(document, wsdlRelativeImports);
            this.procesSchemaIncludes(document, schemaIncludes);
            this.procesWsdlIncludes(document, wsdlIncludes);
        }
        catch (SAXParseException spe) {
            logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00013", new Object[]{spe.getLineNumber(), spe.getSystemId()});
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00079", x);
        }
        catch (Exception sxe) {
            logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00014", sxe.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException io) {}
        }
    }

    private void addImportsAndIncludes(NodeList list, Collection result, String namespace, String location) throws SAXException, ParserConfigurationException, IOException, SAXParseException {
        for (int i = 0; i < list.getLength(); ++i) {
            String givenLocation = null;
            Node element = list.item(i);
            NamedNodeMap attrs = element.getAttributes();
            Node n = attrs.getNamedItem(location);
            if (n != null) {
                givenLocation = n.getNodeValue();
            }
            if (givenLocation == null || givenLocation.startsWith("http")) continue;
            Import imp = new Import();
            imp.setLocation(givenLocation);
            if (namespace != null && (n = attrs.getNamedItem(namespace)) != null) {
                imp.setNamespace(n.getNodeValue());
            }
            result.add(imp);
        }
    }

    private void procesSchemaImports(Document document, Collection schemaImportCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList schemaImports = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        this.addImportsAndIncludes(schemaImports, schemaImportCollection, "namespace", "schemaLocation");
    }

    private void procesWsdlImports(Document document, Collection wsdlImportCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList wsdlImports = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        this.addImportsAndIncludes(wsdlImports, wsdlImportCollection, "namespace", "location");
    }

    private void procesSchemaIncludes(Document document, Collection schemaIncludeCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList schemaIncludes = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        this.addImportsAndIncludes(schemaIncludes, schemaIncludeCollection, null, "schemaLocation");
    }

    private void procesWsdlIncludes(Document document, Collection wsdlIncludesCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList wsdlIncludes = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "include");
        this.addImportsAndIncludes(wsdlIncludes, wsdlIncludesCollection, null, "location");
    }

    public void generateFinalWsdl(URL wsdlFileUrl, WebService webService, WebServerInfo wsi, File finalWsdlFile) throws Exception {
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(finalWsdlFile));
        this.generateFinalWsdl(wsdlFileUrl, webService, wsi, outputStream);
    }

    public void generateFinalWsdl(URL wsdlFileUrl, WebService webService, WebServerInfo wsi, OutputStream outputStream) throws Exception {
        HashSet wsdlRelativeImports = new HashSet();
        HashSet wsdlIncludes = new HashSet();
        HashSet schemaRelativeImports = new HashSet();
        HashSet schemaIncludes = new HashSet();
        if (webService.hasUrlPublishing()) {
            this.parseRelativeImports(wsdlFileUrl, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        }
        Collection endpoints = webService.getEndpoints();
        ArrayList endpointsCopy = new ArrayList();
        endpointsCopy.addAll(endpoints);
        BundleDescriptor bundle = webService.getBundleDescriptor();
        WebServicesDescriptor wsd = bundle.getWebServices();
        Collection webServices = wsd.getWebServices();
        if (webServices.size() > 1) {
            for (WebService aWS : webServices) {
                if (webService.getName().equals(aWS.getName())) continue;
                if (webService.getWsdlFileUri() != null && aWS.getWsdlFileUri() != null && webService.getWsdlFileUri().equals(aWS.getWsdlFileUri())) {
                    endpointsCopy.addAll(aWS.getEndpoints());
                    continue;
                }
                if (webService.getWsdlFileUrl() == null || aWS.getWsdlFileUrl() == null || !webService.getWsdlFileUrl().toString().equals(aWS.getWsdlFileUrl().toString())) continue;
                endpointsCopy.addAll(aWS.getEndpoints());
            }
        }
        BufferedInputStream wsdlInputStream = new BufferedInputStream(wsdlFileUrl.openStream());
        StreamSource XsltWsdlDocument = new StreamSource(wsdlInputStream);
        Templates templates = this.createTemplatesFor(endpointsCopy, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        Transformer transformer = templates.newTransformer();
        WebServiceEndpoint endpointForImport = webService.pickEndpointForRelativeImports();
        URL root = wsi.getWebServerRootURL(endpointForImport.isSecure());
        URL finalWsdlUrl = endpointForImport.composeFinalWsdlUrl(root);
        int wsdlImportNum = 0;
        for (Import next : wsdlRelativeImports) {
            transformer.setParameter("wsdlImportNamespaceParam" + wsdlImportNum, next.getNamespace());
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(WSDL_IMPORT_LOCATION_PARAM_NAME + wsdlImportNum, relativeUrl);
            ++wsdlImportNum;
        }
        int schemaImportNum = 0;
        for (Import next : schemaRelativeImports) {
            transformer.setParameter("schemaImportNamespaceParam" + schemaImportNum, next.getNamespace());
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(SCHEMA_IMPORT_LOCATION_PARAM_NAME + schemaImportNum, relativeUrl);
            ++schemaImportNum;
        }
        int wsdlIncludeNum = 0;
        for (Import next : wsdlIncludes) {
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(WSDL_INCLUDE_LOCATION_PARAM_NAME + wsdlIncludeNum, relativeUrl);
            ++wsdlIncludeNum;
        }
        int schemaIncludeNum = 0;
        for (Import next : schemaIncludes) {
            URL relativeUrl = new URL(finalWsdlUrl, next.getLocation());
            transformer.setParameter(SCHEMA_INCLUDE_LOCATION_PARAM_NAME + schemaIncludeNum, relativeUrl);
            ++schemaIncludeNum;
        }
        int endpointNum = 0;
        for (WebServiceEndpoint next : endpointsCopy) {
            URL rootURL = wsi.getWebServerRootURL(next.isSecure());
            URL actualAddress = next.composeEndpointAddress(rootURL);
            transformer.setParameter(ENDPOINT_ADDRESS_PARAM_NAME + endpointNum, actualAddress.toExternalForm());
            String endpointType = next.implementedByEjbComponent() ? "EJB" : "Servlet";
            logger.log(Level.INFO, "AS-WSJSR109IMPL-00018", new Object[]{"[" + endpointType + "] " + next.getEndpointName(), actualAddress});
            ++endpointNum;
        }
        transformer.transform(XsltWsdlDocument, new StreamResult(outputStream));
        ((InputStream)wsdlInputStream).close();
        outputStream.close();
    }

    public HandlerInfo createHandlerInfo(WebServiceHandler handler, ClassLoader loader) throws Exception {
        QName[] headers = new QName[handler.getSoapHeaders().size()];
        int i = 0;
        Iterator iter = handler.getSoapHeaders().iterator();
        while (iter.hasNext()) {
            headers[i] = (QName)iter.next();
            ++i;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (NameValuePairDescriptor next : handler.getInitParams()) {
            properties.put(next.getName(), next.getValue());
        }
        Class<?> handlerClass = loader.loadClass(handler.getHandlerClass());
        return new HandlerInfo(handlerClass, properties, headers);
    }

    public URL privilegedGetServiceRefWsdl(ServiceReferenceDescriptor desc) throws Exception {
        URL wsdlFileURL;
        try {
            final ServiceReferenceDescriptor serviceRef = desc;
            wsdlFileURL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    WebServiceContractImpl wscImpl;
                    ServerEnvironment se;
                    File appFile;
                    URL retVal = serviceRef.hasWsdlOverride() ? serviceRef.getWsdlOverride() : (serviceRef.getWsdlFileUrl() != null ? serviceRef.getWsdlFileUrl() : (serviceRef.getWsdlFileUri().startsWith("http") ? new URL(serviceRef.getWsdlFileUri()) : (serviceRef.getWsdlFileUri().startsWith("WEB-INF") || serviceRef.getWsdlFileUri().startsWith("META-INF") ? ((appFile = new File((se = (wscImpl = WebServiceContractImpl.getInstance()).getServerEnvironment()).getApplicationRepositoryPath(), serviceRef.getBundleDescriptor().getApplication().getAppName())).exists() ? new File(appFile, serviceRef.getWsdlFileUri()).toURL() : Thread.currentThread().getContextClassLoader().getResource(serviceRef.getWsdlFileUri())) : new File(serviceRef.getWsdlFileUri()).toURL())));
                    return retVal;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            logger.log(Level.WARNING, "AS-WSJSR109IMPL-00050", pae);
            Exception e = new Exception();
            e.initCause(pae.getCause());
            throw e;
        }
        return wsdlFileURL;
    }

    public boolean isJAXWSbasedService(WebService ws) {
        if (ws.isJaxWSBased() != null) {
            return ws.isJaxWSBased();
        }
        boolean jaxwsEndPtFound = false;
        boolean jaxrpcEndPtFound = false;
        String declaredType = ws.getType();
        if (declaredType != null) {
            if (declaredType.equals("JAXWS")) {
                jaxwsEndPtFound = true;
            } else if (declaredType.equals("JAXRPC")) {
                jaxrpcEndPtFound = true;
            } else {
                logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00057", new Object[]{ws.getDescription(), declaredType});
            }
        }
        for (WebServiceEndpoint endpoint : ws.getEndpoints()) {
            Class<?> implClass;
            if (endpoint.getLinkName() == null) {
                String msg = MessageFormat.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00117"), endpoint.getEndpointName(), endpoint.getLinkName());
                logger.log(Level.SEVERE, msg);
                throw new RuntimeException(msg);
            }
            String implClassName = null;
            if (endpoint.implementedByEjbComponent()) {
                if (endpoint.getEjbComponentImpl() != null) {
                    implClassName = endpoint.getEjbComponentImpl().getEjbClassName();
                }
            } else if (endpoint.getWebComponentImpl() != null) {
                implClassName = endpoint.getWebComponentImpl().getWebComponentImplementation();
            }
            if (implClassName == null || "".equals(implClassName.trim())) {
                String msg = MessageFormat.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00116"), endpoint.getEndpointName());
                logger.log(Level.SEVERE, msg);
                throw new RuntimeException(msg);
            }
            try {
                implClass = Thread.currentThread().getContextClassLoader().loadClass(implClassName);
            }
            catch (Exception e) {
                String msg = MessageFormat.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00098"), implClassName);
                logger.log(Level.SEVERE, msg);
                throw new RuntimeException(msg);
            }
            if (implClass == null) continue;
            if (implClass.getAnnotation(WebServiceProvider.class) != null) {
                if (jaxrpcEndPtFound) {
                    logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00006", implClassName);
                    continue;
                }
                jaxwsEndPtFound = true;
                continue;
            }
            if (implClass.getAnnotation(javax.jws.WebService.class) != null) {
                if (jaxrpcEndPtFound) {
                    logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00006", implClassName);
                    continue;
                }
                jaxwsEndPtFound = true;
                continue;
            }
            if (JAXWSServlet.class.isAssignableFrom(implClass)) {
                if (jaxrpcEndPtFound) {
                    logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00006", implClassName);
                    continue;
                }
                jaxwsEndPtFound = true;
                continue;
            }
            if (jaxwsEndPtFound) {
                logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00006", implClassName);
                continue;
            }
            jaxrpcEndPtFound = true;
            ws.getWebServicesDescriptor().setSpecVersion("1.1");
        }
        if (jaxwsEndPtFound) {
            ws.setJaxWSBased(true);
            ws.setType("JAX-WS");
        } else {
            ws.setJaxWSBased(false);
            ws.setType("JAX-RPC");
        }
        return jaxwsEndPtFound;
    }

    public javax.xml.rpc.Service createConfiguredService(ServiceReferenceDescriptor desc) throws Exception {
        ServiceReferenceDescriptor serviceRef = desc;
        javax.xml.rpc.Service service = null;
        try {
            final URL wsdlFileURL = this.privilegedGetServiceRefWsdl(serviceRef);
            final QName serviceName = serviceRef.getServiceName();
            final ServiceFactory serviceFactory = ServiceFactory.newInstance();
            service = (javax.xml.rpc.Service)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return serviceFactory.createService(wsdlFileURL, serviceName);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            logger.log(Level.WARNING, "AS-WSJSR109IMPL-00050", pae);
            Exception e = new Exception();
            e.initCause(pae.getCause());
            throw e;
        }
        return service;
    }

    public void configureHandlerChain(ServiceReferenceDescriptor serviceRef, javax.xml.rpc.Service service, Iterator ports, ClassLoader loader) throws Exception {
        if (!serviceRef.hasHandlers()) {
            return;
        }
        HandlerRegistry registry = service.getHandlerRegistry();
        while (ports.hasNext()) {
            QName nextPort = (QName)ports.next();
            List handlerChain = registry.getHandlerChain(nextPort);
            HashSet soapRoles = new HashSet();
            for (WebServiceHandler nextHandler : serviceRef.getHandlers()) {
                Collection portNames = nextHandler.getPortNames();
                if (!portNames.isEmpty() && !portNames.contains(nextPort.getLocalPart())) continue;
                soapRoles.addAll(nextHandler.getSoapRoles());
                HandlerInfo handlerInfo = this.createHandlerInfo(nextHandler, loader);
                handlerChain.add(handlerInfo);
            }
        }
    }

    private Templates createTemplatesFor(Collection endpoints, Collection wsdlRelativeImports, Collection wsdlIncludes, Collection schemaRelativeImports, Collection schemaIncludes) throws Exception {
        String importLocationParam;
        String importLocationParam2;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, "UTF-8");
        writer.write("<xsl:transform version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" xmlns:soap12=\"http://schemas.xmlsoap.org/wsdl/soap12/\">\n");
        int wsdlImportNum = 0;
        for (Import next : wsdlRelativeImports) {
            String importNamespaceParam = "wsdlImportNamespaceParam" + wsdlImportNum;
            importLocationParam2 = WSDL_IMPORT_LOCATION_PARAM_NAME + wsdlImportNum;
            writer.write("<xsl:param name=\"" + importNamespaceParam + "\"/>\n");
            writer.write("<xsl:param name=\"" + importLocationParam2 + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:import[@location='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<wsdl:import>");
            writer.write("<xsl:attribute name=\"namespace\"><xsl:value-of select=\"$" + importNamespaceParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("<xsl:attribute name=\"location\"><xsl:value-of select=\"$" + importLocationParam2 + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</wsdl:import></xsl:template>");
            ++wsdlImportNum;
        }
        int wsdlIncludeNum = 0;
        for (Import next : wsdlIncludes) {
            importLocationParam2 = WSDL_INCLUDE_LOCATION_PARAM_NAME + wsdlIncludeNum;
            writer.write("<xsl:param name=\"" + importLocationParam2 + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:include[@location='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<wsdl:include>");
            writer.write("<xsl:attribute name=\"location\"><xsl:value-of select=\"$" + importLocationParam2 + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</wsdl:include></xsl:template>");
            ++wsdlIncludeNum;
        }
        int schemaImportNum = 0;
        for (Import next : schemaRelativeImports) {
            String importNamespaceParam = "schemaImportNamespaceParam" + schemaImportNum;
            importLocationParam = SCHEMA_IMPORT_LOCATION_PARAM_NAME + schemaImportNum;
            writer.write("<xsl:param name=\"" + importNamespaceParam + "\"/>\n");
            writer.write("<xsl:param name=\"" + importLocationParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:types/xsd:schema/xsd:import[@schemaLocation='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<xsd:import>");
            writer.write("<xsl:attribute name=\"namespace\"><xsl:value-of select=\"$" + importNamespaceParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("<xsl:attribute name=\"schemaLocation\"><xsl:value-of select=\"$" + importLocationParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</xsd:import></xsl:template>");
            ++schemaImportNum;
        }
        int schemaIncludeNum = 0;
        for (Import next : schemaIncludes) {
            importLocationParam = SCHEMA_INCLUDE_LOCATION_PARAM_NAME + schemaIncludeNum;
            writer.write("<xsl:param name=\"" + importLocationParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions/wsdl:types/xsd:schema/xsd:include[@schemaLocation='");
            writer.write(next.getLocation());
            writer.write("']\" mode=\"copy\">");
            writer.write("<xsd:include>");
            writer.write("<xsl:attribute name=\"schemaLocation\"><xsl:value-of select=\"$" + importLocationParam + "\"/>");
            writer.write("</xsl:attribute>");
            writer.write("</xsd:include></xsl:template>");
            ++schemaIncludeNum;
        }
        int endpointNum = 0;
        for (WebServiceEndpoint endpoint : endpoints) {
            if (!endpoint.hasWsdlPort()) {
                throw new Exception("No WSDL port specified for endpoint " + endpoint.getEndpointName());
            }
            if (!endpoint.hasServiceName()) {
                throw new Exception("Runtime settings error.  Cannot find service name for endpoint " + endpoint.getEndpointName());
            }
            String actualAddressParam = ENDPOINT_ADDRESS_PARAM_NAME + endpointNum;
            writer.write("<xsl:param name=\"" + actualAddressParam + "\"/>\n");
            writer.write("<xsl:template match=\"/\"><xsl:apply-templates mode=\"copy\"/></xsl:template>\n");
            writer.write("<xsl:template match=\"wsdl:definitions[@targetNamespace='");
            writer.write(endpoint.getServiceName().getNamespaceURI());
            writer.write("']/wsdl:service[@name='");
            writer.write(endpoint.getServiceName().getLocalPart());
            writer.write("']/wsdl:port[@name='");
            writer.write(endpoint.getWsdlPort().getLocalPart());
            writer.write("']/" + endpoint.getSoapAddressPrefix() + ":address\" mode=\"copy\">");
            writer.write("<" + endpoint.getSoapAddressPrefix() + ":address><xsl:attribute name=\"location\"><xsl:value-of select=\"$" + actualAddressParam + "\"/>");
            writer.write("</xsl:attribute></" + endpoint.getSoapAddressPrefix() + ":address></xsl:template>");
            ++endpointNum;
        }
        writer.write("<xsl:template match=\"@*|node()\" mode=\"copy\"><xsl:copy><xsl:apply-templates select=\"@*\" mode=\"copy\"/><xsl:apply-templates mode=\"copy\"/></xsl:copy></xsl:template>\n");
        writer.write("</xsl:transform>\n");
        writer.close();
        byte[] stylesheet = bos.toByteArray();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(new String(stylesheet));
        }
        StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(stylesheet));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Templates templates = transformerFactory.newTemplates(stylesheetSource);
        return templates;
    }

    public Collection getSEIsFromGeneratedService(Class generatedServiceInterface) throws Exception {
        HashSet<String> seis = new HashSet<String>();
        Method[] declaredMethods = generatedServiceInterface.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method next = declaredMethods[i];
            Class<?> returnType = next.getReturnType();
            if (!next.getName().startsWith("get") || next.getDeclaringClass() == javax.xml.rpc.Service.class || !Remote.class.isAssignableFrom(returnType)) continue;
            seis.add(returnType.getName());
        }
        return seis;
    }

    public Port getPortFromModel(Model model, QName portName) {
        Iterator serviceIter = model.getServices();
        while (serviceIter.hasNext()) {
            Service next = (Service)serviceIter.next();
            Iterator portIter = next.getPorts();
            while (portIter.hasNext()) {
                Port nextPort = (Port)portIter.next();
                if (!this.portsEqual(nextPort, portName)) continue;
                return nextPort;
            }
        }
        return null;
    }

    public Service getServiceForPort(Model model, QName thePortName) {
        Iterator serviceIter = model.getServices();
        while (serviceIter.hasNext()) {
            Service nextService = (Service)serviceIter.next();
            Iterator portIter = nextService.getPorts();
            while (portIter.hasNext()) {
                Port nextPort = (Port)portIter.next();
                if (!this.portsEqual(nextPort, thePortName)) continue;
                return nextService;
            }
        }
        return null;
    }

    public boolean portsEqual(Port port, QName candidatePortName) {
        boolean equal = false;
        QName portPropertyName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
        equal = portPropertyName != null ? candidatePortName.equals(portPropertyName) : candidatePortName.equals(port.getName());
        return equal;
    }

    public Collection getAllPorts(Model model) {
        HashSet ports = new HashSet();
        Iterator serviceIter = model.getServices();
        while (serviceIter.hasNext()) {
            Service next = (Service)serviceIter.next();
            ports.addAll(next.getPortsList());
        }
        return ports;
    }

    public Method getInvMethod(Tie webServiceTie, MessageContext context) throws Exception {
        SOAPMessageContext soapMsgContext = (SOAPMessageContext)context;
        SOAPMessage message = soapMsgContext.getMessage();
        if (!(webServiceTie instanceof StreamingHandler)) {
            throw new IllegalArgumentException(webServiceTie + "is not instance of StreamingHandler.");
        }
        StreamingHandler streamingHandler = (StreamingHandler)webServiceTie;
        int opcode = streamingHandler.getOpcodeForRequestMessage(message);
        return streamingHandler.getMethodForOpcode(opcode);
    }

    public void throwSOAPFaultException(String faultString, MessageContext msgContext) {
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        this.throwSOAPFaultException(faultString, soapMessage);
    }

    public void throwSOAPFaultException(String faultString, SOAPMessage soapMessage) throws SOAPFaultException {
        SOAPFaultException sfe;
        block4: {
            sfe = null;
            try {
                SOAPPart sp = soapMessage.getSOAPPart();
                SOAPEnvelope se = sp.getEnvelope();
                SOAPBody sb = se.getBody();
                Iterator iter = sb.getChildElements();
                if (iter.hasNext()) {
                    SOAPBodyElement requestBody = (SOAPBodyElement)iter.next();
                    requestBody.detachNode();
                }
                SOAPFault soapFault = sb.addFault();
                se.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
                String faultActor = "http://schemas.xmlsoap.org/soap/actor/next";
                QName faultCode = SOAPConstants.FAULT_CODE_SERVER;
                soapFault.setFaultCode("env:" + faultCode.getLocalPart());
                soapFault.setFaultString(faultString);
                soapFault.setFaultActor(faultActor);
                sfe = new SOAPFaultException(faultCode, faultActor, faultString, null);
            }
            catch (SOAPException se) {
                if (!logger.isLoggable(Level.FINE)) break block4;
                logger.log(Level.FINE, "AS-WSJSR109IMPL-00050", se);
            }
        }
        if (sfe != null) {
            throw sfe;
        }
    }

    void writeReply(HttpServletResponse response, com.sun.xml.rpc.spi.runtime.SOAPMessageContext messageContext) throws IOException, SOAPException {
        if (this.isMessageContextPropertySet(messageContext, ONE_WAY_OPERATION)) {
            return;
        }
        SOAPMessage reply = messageContext.getMessage();
        boolean statusCode = false;
        if (messageContext.isFailure()) {
            if (this.isMessageContextPropertySet(messageContext, CLIENT_BAD_REQUEST)) {
                response.setStatus(400);
                this.setContentTypeAndFlush(response);
                return;
            }
            response.setStatus(500);
        } else {
            response.setStatus(200);
        }
        ServletOutputStream os = response.getOutputStream();
        String[] headers = reply.getMimeHeaders().getHeader("Content-Type");
        if (headers != null && headers.length > 0) {
            response.setContentType(headers[0]);
        } else {
            response.setContentType("text/xml");
        }
        WsUtil.putHeaders(reply.getMimeHeaders(), response);
        reply.writeTo((OutputStream)os);
        os.flush();
    }

    private static void putHeaders(MimeHeaders headers, HttpServletResponse response) {
        headers.removeHeader("Content-Type");
        headers.removeHeader("Content-Length");
        Iterator it = headers.getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            response.setHeader(header.getName(), header.getValue());
        }
    }

    public static void raiseException(HttpServletResponse resp, String binding, String faultString) {
        resp.setStatus(500);
        if ("http://www.w3.org/2004/08/wsdl/http".equals(binding)) {
            resp.setContentType("text/xml");
            try {
                PrintWriter writer = new PrintWriter((OutputStream)resp.getOutputStream());
                writer.println("<error>" + faultString + "</error>");
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "AS-WSJSR109IMPL-00099", ioe.getMessage());
            }
        } else {
            String protocol = "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(binding) ? "SOAP 1.2 Protocol" : "SOAP 1.1 Protocol";
            SOAPMessage fault = WsUtil.getSOAPFault(protocol, faultString);
            if (fault != null) {
                resp.setContentType("text/xml");
                try {
                    fault.writeTo((OutputStream)resp.getOutputStream());
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "AS-WSJSR109IMPL-00100", ex);
                }
            }
        }
    }

    public static SOAPMessage getSOAPFault(String protocol, String faultString) {
        if (protocol == null) {
            protocol = "SOAP 1.1 Protocol";
        }
        try {
            MessageFactory factory = MessageFactory.newInstance((String)protocol);
            if (factory == null) {
                factory = MessageFactory.newInstance();
            }
            SOAPMessage message = factory.createMessage();
            SOAPBody body = message.getSOAPBody();
            SOAPFault fault = body.addFault();
            fault.setFaultString(faultString);
            SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
            String envelopeNamespace = envelope.getNamespaceURI();
            QName faultCode = new QName(envelopeNamespace, "Server", "env");
            fault.setFaultCode(faultCode);
            return message;
        }
        catch (SOAPException e) {
            logger.log(Level.WARNING, "AS-WSJSR109IMPL-00101", faultString);
            return null;
        }
    }

    void writeInvalidContentType(HttpServletResponse response) throws SOAPException, IOException {
        response.setStatus(415);
        this.setContentTypeAndFlush(response);
    }

    void writeInvalidMethodType(HttpServletResponse response, String message) throws IOException {
        response.setStatus(405);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println("Invalid Method Type");
        out.println("</title></head>");
        out.println("<body>");
        out.println(HtmlEntityEncoder.encodeXSS((String)message));
        out.println("</body>");
        out.println("</html>");
    }

    private void setContentTypeAndFlush(HttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        response.flushBuffer();
        response.getWriter().close();
    }

    boolean hasSomeTextXmlContent(MimeHeaders headers) {
        return this.hasTextXmlContentType(headers) && this.getContentLength(headers) > 0;
    }

    private int getContentLength(MimeHeaders headers) {
        String[] contentLength = headers.getHeader("Content-Length");
        int length = 0;
        if (contentLength != null && contentLength.length > 0) {
            length = new Integer(contentLength[0]);
        }
        return length;
    }

    boolean hasTextXmlContentType(MimeHeaders headers) {
        String[] contentTypes = headers.getHeader("Content-Type");
        return contentTypes != null && contentTypes.length >= 1 && contentTypes[0].indexOf("text/xml") != -1;
    }

    boolean isMessageContextPropertySet(com.sun.xml.rpc.spi.runtime.SOAPMessageContext messageContext, String property) {
        Object prop = messageContext.getProperty(property);
        return prop != null && prop instanceof String && ((String)prop).equalsIgnoreCase("true");
    }

    MimeHeaders getHeaders(HttpServletRequest request) {
        Enumeration e = request.getHeaderNames();
        MimeHeaders headers = new MimeHeaders();
        while (e.hasMoreElements()) {
            String headerName = (String)e.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.addHeader(headerName, headerValue);
        }
        return headers;
    }

    public WebServerInfo getWebServerInfoForDAS() {
        WebServerInfo wsi = new WebServerInfo();
        if (this.networkListeners == null) {
            ArrayList<Integer> adminPorts = new ArrayList<Integer>();
            for (Adapter subAdapter : WebServiceContractImpl.getInstance().getAdapters()) {
                if (subAdapter instanceof AdminAdapter) {
                    AdminAdapter aa = (AdminAdapter)subAdapter;
                    adminPorts.add(aa.getListenPort());
                    continue;
                }
                if (!(subAdapter instanceof AdminConsoleAdapter)) continue;
                AdminConsoleAdapter aca = (AdminConsoleAdapter)subAdapter;
                adminPorts.add(aca.getListenPort());
            }
            for (NetworkListener nl : this.config.getNetworkConfig().getNetworkListeners().getNetworkListener()) {
                if (adminPorts.contains(Integer.valueOf(nl.getPort()))) continue;
                if (this.networkListeners == null) {
                    this.networkListeners = new ArrayList<NetworkListener>();
                }
                this.networkListeners.add(nl);
            }
        }
        if (this.networkListeners != null && !this.networkListeners.isEmpty()) {
            for (NetworkListener listener : this.networkListeners) {
                String host = listener.getAddress();
                if (listener.getAddress().equals("0.0.0.0")) {
                    try {
                        host = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        host = "localhost";
                    }
                }
                if (listener.findHttpProtocol().getSecurityEnabled().equals("false")) {
                    wsi.setHttpVS(new VirtualServerInfo("http", host, Integer.parseInt(listener.getPort())));
                    continue;
                }
                if (!listener.findHttpProtocol().getSecurityEnabled().equals("true")) continue;
                wsi.setHttpsVS(new VirtualServerInfo("https", host, Integer.parseInt(listener.getPort())));
            }
        } else {
            wsi.setHttpVS(new VirtualServerInfo("http", "localhost", 0));
            wsi.setHttpsVS(new VirtualServerInfo("https", "localhost", 0));
        }
        return wsi;
    }

    public static Logger getDefaultLogger() {
        return logger;
    }

    public static LocalStringManagerImpl getDefaultStringManager() {
        return localStrings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateEjbEndpoint(WebServiceEndpoint ejbEndpoint) {
        EjbDescriptor ejbDescriptor = ejbEndpoint.getEjbComponentImpl();
        EjbBundleDescriptor bundle = ejbDescriptor.getEjbBundleDescriptor();
        WebServicesDescriptor webServices = bundle.getWebServices();
        Collection endpoints = webServices.getEndpointsImplementedBy(ejbDescriptor);
        if (endpoints.size() == 1) {
            if (ejbDescriptor.hasWebServiceEndpointInterface()) {
                if (ejbEndpoint.getServiceEndpointInterface().equals(ejbDescriptor.getWebServiceEndpointInterfaceName())) return;
                String msg = "Ejb " + ejbDescriptor.getName() + " service endpoint interface does not match " + " port component " + ejbEndpoint.getEndpointName();
                throw new IllegalStateException(msg);
            }
            String msg = "Ejb " + ejbDescriptor.getName() + " must declare <service-endpoint> interface";
            throw new IllegalStateException(msg);
        }
        if (endpoints.size() <= 1) return;
        String msg = "Ejb " + ejbDescriptor.getName() + " implements " + endpoints.size() + " web service endpoints " + " but must only implement 1";
        throw new IllegalStateException(msg);
    }

    public void updateServletEndpointRuntime(WebServiceEndpoint endpoint) {
        endpoint.saveServletImplClass();
        WebComponentDescriptor webComp = endpoint.getWebComponentImpl();
        WebBundleDescriptor bundle = webComp.getWebBundleDescriptor();
        WebServicesDescriptor webServices = bundle.getWebServices();
        Collection endpoints = webServices.getEndpointsImplementedBy(webComp);
        if (endpoints.size() > 1) {
            String msg = "Servlet " + endpoint.getWebComponentLink() + " implements " + endpoints.size() + " web service endpoints " + " but must only implement 1";
            throw new IllegalStateException(msg);
        }
        if (endpoint.getEndpointAddressUri() == null) {
            Set urlPatterns = webComp.getUrlPatternsSet();
            if (urlPatterns.size() == 1) {
                String uri = (String)urlPatterns.iterator().next();
                endpoint.setEndpointAddressUri(uri);
                Collection constraints = bundle.getSecurityConstraintsForUrlPattern(uri);
                for (SecurityConstraint next : constraints) {
                    UserDataConstraint dataConstraint = next.getUserDataConstraint();
                    String guarantee = dataConstraint != null ? dataConstraint.getTransportGuarantee() : null;
                    if (guarantee == null || !guarantee.equals("INTEGRAL") && !guarantee.equals("CONFIDENTIAL")) continue;
                    endpoint.setTransportGuarantee(guarantee);
                    break;
                }
            } else {
                String msg = "Endpoint " + endpoint.getEndpointName() + " has not been assigned an endpoint address " + " and is associated with servlet " + webComp.getCanonicalName() + " , which has " + urlPatterns.size() + " url patterns";
                throw new IllegalStateException(msg);
            }
        }
    }

    public Collection getWsdlsAndSchemas(File pkgedWsdl) throws Exception {
        ArrayList<SDDocumentSource> cumulative = new ArrayList<SDDocumentSource>();
        this.getWsdlsAndSchemas(pkgedWsdl, cumulative);
        URL id = pkgedWsdl.toURL();
        SDDocumentSource toRemove = null;
        for (SDDocumentSource source : cumulative) {
            if (!id.toString().equals(source.getSystemId().toString())) continue;
            toRemove = source;
        }
        if (toRemove != null) {
            cumulative.remove(toRemove);
        }
        return cumulative;
    }

    public Collection getWsdlsAndSchemas(URL pkgedWsdl) throws Exception {
        ArrayList<SDDocumentSource> cumulative = new ArrayList<SDDocumentSource>();
        this.getWsdlsAndSchemas(pkgedWsdl, cumulative);
        SDDocumentSource toRemove = null;
        for (SDDocumentSource source : cumulative) {
            if (!pkgedWsdl.toString().equals(source.getSystemId().toString())) continue;
            toRemove = source;
        }
        if (toRemove != null) {
            cumulative.remove(toRemove);
        }
        return cumulative;
    }

    private void getWsdlsAndSchemas(URL wsdlRoot, ArrayList<SDDocumentSource> cumulative) throws Exception {
        HashSet wsdlRelativeImports = new HashSet();
        HashSet schemaRelativeImports = new HashSet();
        HashSet wsdlIncludes = new HashSet();
        HashSet schemaIncludes = new HashSet();
        this.parseRelativeImports(wsdlRoot, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        wsdlRelativeImports.addAll(wsdlIncludes);
        schemaRelativeImports.addAll(schemaIncludes);
        for (Import next : schemaRelativeImports) {
            this.addFileAndDecendents(wsdlRoot.toURI().resolve(new URI(null, next.getLocation(), null).toASCIIString()).toURL(), cumulative);
        }
        for (Import next : wsdlRelativeImports) {
            this.addFileAndDecendents(wsdlRoot.toURI().resolve(new URI(null, next.getLocation(), null).toASCIIString()).toURL(), cumulative);
        }
    }

    private void addFileAndDecendents(URL fileUrl, ArrayList<SDDocumentSource> cumulative) throws Exception {
        boolean alreadyProcessed = false;
        for (SDDocumentSource source : cumulative) {
            if (!fileUrl.toString().equals(source.getSystemId().toString())) continue;
            alreadyProcessed = true;
            break;
        }
        if (!alreadyProcessed) {
            cumulative.add(0, SDDocumentSource.create((URL)fileUrl));
            this.getWsdlsAndSchemas(fileUrl, cumulative);
        }
    }

    public void getWsdlsAndSchemas(File wsdl, ArrayList<SDDocumentSource> cumulative) throws Exception {
        String location;
        HashSet wsdlRelativeImports = new HashSet();
        HashSet schemaRelativeImports = new HashSet();
        HashSet wsdlIncludes = new HashSet();
        HashSet schemaIncludes = new HashSet();
        String wsdlRoot = wsdl.getParent();
        this.parseRelativeImports(wsdl.toURL(), wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        wsdlRelativeImports.addAll(wsdlIncludes);
        schemaRelativeImports.addAll(schemaIncludes);
        for (Import next : schemaRelativeImports) {
            location = next.getLocation();
            location = location.replaceAll("/", "\\" + File.separator);
            File file = new File(wsdlRoot + File.separator + location).getCanonicalFile();
            this.addFileAndDecendents(file, cumulative);
        }
        for (Import next : wsdlRelativeImports) {
            location = next.getLocation();
            location = location.replaceAll("/", "\\" + File.separator);
            File currentWsdlFile = new File(wsdlRoot + File.separator + location).getCanonicalFile();
            this.addFileAndDecendents(currentWsdlFile, cumulative);
        }
    }

    private void addFileAndDecendents(File file, ArrayList<SDDocumentSource> cumulative) throws Exception {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        URL id = file.toURL();
        boolean alreadyProcessed = false;
        for (SDDocumentSource source : cumulative) {
            if (!id.toString().equals(source.getSystemId().toString())) continue;
            alreadyProcessed = true;
            break;
        }
        if (!alreadyProcessed) {
            cumulative.add(0, SDDocumentSource.create((URL)id));
            this.getWsdlsAndSchemas(file, cumulative);
        }
    }

    public void doPostConstruct(Class impl, Object implObj) {
        this.invokeServiceMethod(PostConstruct.class, impl, implObj);
    }

    public void doPreDestroy(WebServiceEndpoint ep, ClassLoader loader) {
        try {
            Class<?> impl = Class.forName(ep.getServletImplClass(), true, loader);
            this.invokeServiceMethod(PreDestroy.class, impl, impl.newInstance());
        }
        catch (Throwable ex) {
            String msg = MessageFormat.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00102"), ep.getServletImplClass());
            logger.log(Level.SEVERE, msg, ex);
        }
        if (!ep.hasHandlerChain()) {
            return;
        }
        for (WebServiceHandlerChain thisHc : ep.getHandlerChain()) {
            for (WebServiceHandler thisHandler : thisHc.getHandlers()) {
                try {
                    Class<?> handlerClass = Class.forName(thisHandler.getHandlerClass(), true, loader);
                    this.invokeServiceMethod(PreDestroy.class, handlerClass, handlerClass.newInstance());
                }
                catch (Throwable ex) {
                    String msg = MessageFormat.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00103"), thisHandler.getHandlerClass());
                    logger.log(Level.SEVERE, msg, ex);
                }
            }
        }
    }

    private void invokeServiceMethod(Class annType, Class impl, final Object implObj) {
        Method[] methods;
        for (final Method method : methods = impl.getDeclaredMethods()) {
            if (method.getAnnotation(annType) == null) continue;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, InvocationTargetException {
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        method.invoke(implObj, new Object[0]);
                        return null;
                    }
                });
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00104", e);
            }
            break;
        }
    }

    private boolean matchQNamePatterns(QName cfgQName, QName givenPattern) {
        if (givenPattern.getNamespaceURI().equals(cfgQName.getNamespaceURI())) {
            String expr = givenPattern.getLocalPart().replaceAll("\\*", ".*");
            return Pattern.matches(expr, cfgQName.getLocalPart());
        }
        return false;
    }

    private boolean patternsMatch(WebServiceHandlerChain hc, QName svcName, QName portName, String bindingId) {
        QName portPattern;
        QName svcPattern;
        if (hc.getServiceNamePattern() != null && svcName != null && !this.matchQNamePatterns(svcName, svcPattern = QName.valueOf(hc.getServiceNamePattern()))) {
            return false;
        }
        if (hc.getPortNamePattern() != null && portName != null && !this.matchQNamePatterns(portName, portPattern = QName.valueOf(hc.getPortNamePattern()))) {
            return false;
        }
        if (hc.getProtocolBindings() != null && bindingId != null) {
            String givenBindings = hc.getProtocolBindings();
            if (bindingId.equals("http://www.w3.org/2004/08/wsdl/http") && (givenBindings.indexOf("http://www.w3.org/2004/08/wsdl/http") != -1 || givenBindings.indexOf("##XML_HTTP") != -1)) {
                return true;
            }
            if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http") && (givenBindings.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http") != -1 || givenBindings.indexOf("##SOAP11_HTTP") != -1)) {
                return true;
            }
            if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") && (givenBindings.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/") != -1 || givenBindings.indexOf("##SOAP12_HTTP") != -1)) {
                return true;
            }
            if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") && (givenBindings.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") != -1 || givenBindings.indexOf("##SOAP11_HTTP_MTOM") != -1)) {
                return true;
            }
            if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") && (givenBindings.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") != -1 || givenBindings.indexOf("##SOAP12_HTTP_MTOM") != -1)) {
                return true;
            }
        }
        return true;
    }

    private List<Handler> processConfiguredHandlers(List<WebServiceHandler> handlersList, Set<String> roles) {
        ArrayList<Handler> handlerChain = new ArrayList<Handler>();
        for (WebServiceHandler h : handlersList) {
            Class<?> handlerClass;
            Handler handler = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                handlerClass = Class.forName(h.getHandlerClass(), true, loader);
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(logger.getResourceBundle().getString("AS-WSJSR109IMPL-00105"), h.getHandlerClass());
                logger.log(Level.SEVERE, msg, t);
                continue;
            }
            try {
                WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
                InjectionManager injManager = wscImpl.getInjectionManager();
                handler = (Handler)injManager.createManagedObject(handlerClass);
            }
            catch (InjectionException e) {
                logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00106", new Object[]{h.getHandlerClass(), e.getMessage()});
                continue;
            }
            Collection rolesColl = h.getSoapRoles();
            roles.addAll(rolesColl);
            handlerChain.add(handler);
        }
        return handlerChain;
    }

    public void configureJAXWSServiceHandlers(WebServiceEndpoint ep, String bindingId, WSBinding bindingObj) {
        if (!ep.hasHandlerChain()) {
            return;
        }
        LinkedList handlerChainList = ep.getHandlerChain();
        ArrayList<Handler> finalHandlerList = new ArrayList<Handler>();
        HashSet<String> roles = new HashSet<String>();
        for (WebServiceHandlerChain hc : handlerChainList) {
            if (!this.patternsMatch(hc, ep.getServiceName(), ep.getWsdlPort(), bindingId)) continue;
            List<Handler> handlerInfo = this.processConfiguredHandlers(hc.getHandlers(), roles);
            finalHandlerList.addAll(handlerInfo);
        }
        bindingObj.setHandlerChain(finalHandlerList);
        if (bindingObj instanceof SOAPBinding) {
            ((SOAPBinding)bindingObj).setRoles(roles);
        }
    }

    public void configureJAXWSClientHandlers(javax.xml.ws.Service svcClass, ServiceReferenceDescriptor desc) {
        HandlerResolverImpl resolver = new HandlerResolverImpl();
        HashSet<String> roles = new HashSet<String>();
        Iterator ports = svcClass.getPorts();
        while (ports.hasNext()) {
            QName nextPort = (QName)ports.next();
            LinkedList handlerChainList = desc.getHandlerChain();
            for (WebServiceHandlerChain hc : handlerChainList) {
                if (!this.patternsMatch(hc, desc.getServiceName(), nextPort, null)) continue;
                ArrayList<String> protocols = new ArrayList<String>();
                if (hc.getProtocolBindings() == null) {
                    protocols.add("http://www.w3.org/2004/08/wsdl/http");
                    protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http");
                    protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
                    protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
                    protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
                } else {
                    String specifiedProtocols = hc.getProtocolBindings();
                    if (specifiedProtocols.indexOf("http://www.w3.org/2004/08/wsdl/http") != -1 || specifiedProtocols.indexOf("##XML_HTTP") != -1) {
                        protocols.add("http://www.w3.org/2004/08/wsdl/http");
                    }
                    if (specifiedProtocols.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http") != -1 || specifiedProtocols.indexOf("##SOAP11_HTTP") != -1) {
                        protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http");
                    }
                    if (specifiedProtocols.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/") != -1 || specifiedProtocols.indexOf("##SOAP12_HTTP") != -1) {
                        protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
                    }
                    if (specifiedProtocols.indexOf("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") != -1 || specifiedProtocols.indexOf("##SOAP11_HTTP_MTOM") != -1) {
                        protocols.add("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
                    }
                    if (specifiedProtocols.indexOf("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") != -1 || specifiedProtocols.indexOf("##SOAP12_HTTP_MTOM") != -1) {
                        protocols.add("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
                    }
                }
                List handlersList = hc.getHandlers();
                for (WebServiceHandler thisOne : handlersList) {
                    Collection portNames = thisOne.getPortNames();
                    if (portNames.isEmpty() || portNames.contains(nextPort.getLocalPart())) continue;
                    handlersList.remove(thisOne);
                }
                List<Handler> handlerInfo = this.processConfiguredHandlers(handlersList, roles);
                Iterator s = protocols.iterator();
                while (s.hasNext()) {
                    PortInfoImpl portInfo = new PortInfoImpl(BindingID.parse((String)((String)s.next())), nextPort, desc.getServiceName());
                    resolver.setHandlerChain(portInfo, handlerInfo);
                }
            }
        }
        svcClass.setHandlerResolver((HandlerResolver)resolver);
    }

    public boolean getMtom(WebServiceEndpoint ep) {
        String currentBinding = ep.getProtocolBinding();
        if (ep.getMtomEnabled() == null && ("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(currentBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(currentBinding))) {
            return true;
        }
        return Boolean.valueOf(ep.getMtomEnabled()) != false && ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(currentBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(currentBinding) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(currentBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(currentBinding));
    }
}

