/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import org.glassfish.external.probe.provider.annotations.Probe;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.probe.provider.annotations.ProbeProvider;
import org.glassfish.webservices.JAXWSAdapterRegistry;
import org.glassfish.webservices.WebServiceContractImpl;
import org.glassfish.webservices.WsUtil;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;
import org.glassfish.webservices.monitoring.WebServiceTesterServlet;

@ProbeProvider(moduleProviderName="glassfish", moduleName="webservices", probeProviderName="servlet-109")
public class JAXWSServlet
extends HttpServlet {
    private static Logger logger = LogDomains.getLogger(JAXWSServlet.class, (String)"javax.enterprise.webservices");
    private WebServiceEndpoint endpoint;
    private String contextRoot;
    private WebServiceEngineImpl wsEngine_;
    private boolean wsdlExposed = true;
    private String urlPattern;

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            super.init(servletConfig);
            this.wsEngine_ = WebServiceEngineImpl.getInstance();
            this.doInit(servletConfig);
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        JAXWSServlet jAXWSServlet = this;
        synchronized (jAXWSServlet) {
            this.wsEngine_.removeHandler(this.endpoint);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Endpoint endpt;
        this.startedEvent(this.endpoint.getEndpointAddressPath());
        if ("Tester".equalsIgnoreCase(request.getQueryString()) && !"http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding()) && (endpt = this.wsEngine_.getEndpoint(request.getServletPath())) != null && Boolean.parseBoolean(endpt.getDescriptor().getDebugging())) {
            WebServiceTesterServlet.invoke(request, response, endpt.getDescriptor());
            this.endedEvent(this.endpoint.getEndpointAddressPath());
            return;
        }
        try {
            ServletAdapter targetEndpoint = (ServletAdapter)this.getEndpointFor(request);
            if (targetEndpoint == null) {
                throw new ServletException("Service not found");
            }
            targetEndpoint.handle(this.getServletContext(), request, response);
        }
        catch (Throwable t) {
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        }
        this.endedEvent(this.endpoint.getEndpointAddressPath());
    }

    @Probe(name="startedEvent")
    private void startedEvent(@ProbeParam(value="endpointAddress") String endpointAddress) {
    }

    @Probe(name="endedEvent")
    private void endedEvent(@ProbeParam(value="endpointAddress") String endpointAddress) {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("Tester".equalsIgnoreCase(request.getQueryString()) && !"http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding())) {
            Endpoint endpt = this.wsEngine_.getEndpoint(request.getServletPath());
            if (endpt != null && (endpt.getDescriptor().isSecure() || endpt.getDescriptor().getMessageSecurityBinding() != null || this.endpoint.hasSecurePipeline())) {
                String message = endpt.getDescriptor().getWebService().getName() + "is a secured web service; Tester feature is not supported for secured services";
                new WsUtil().writeInvalidMethodType(response, message);
                return;
            }
            if (endpt != null && Boolean.parseBoolean(endpt.getDescriptor().getDebugging())) {
                WebServiceTesterServlet.invoke(request, response, endpt.getDescriptor());
                return;
            }
        }
        if (!"WSDL".equalsIgnoreCase(request.getQueryString()) && "http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding())) {
            this.doPost(request, response);
            return;
        }
        try {
            ServletAdapter targetEndpoint = (ServletAdapter)this.getEndpointFor(request);
            if (targetEndpoint != null && this.wsdlExposed) {
                targetEndpoint.publishWSDL(this.getServletContext(), request, response);
            } else {
                String message = "Invalid wsdl request " + request.getRequestURL();
                new WsUtil().writeInvalidMethodType(response, message);
            }
        }
        catch (Throwable t) {
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        }
    }

    private void doInit(ServletConfig servletConfig) throws ServletException {
        String servletName = "unknown";
        try {
            String uri;
            WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
            ComponentEnvManager compEnvManager = wscImpl.getComponentEnvManager();
            JndiNameEnvironment jndiNameEnv = compEnvManager.getCurrentJndiNameEnvironment();
            WebBundleDescriptor webBundle = null;
            if (jndiNameEnv == null || !(jndiNameEnv instanceof WebBundleDescriptor)) {
                throw new WebServiceException("Cannot intialize the JAXWSServlet for " + jndiNameEnv);
            }
            webBundle = (WebBundleDescriptor)jndiNameEnv;
            servletName = servletConfig.getServletName();
            this.contextRoot = webBundle.getContextRoot();
            WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(servletName);
            if (webComponent == null) {
                throw new ServletException(servletName + " not found");
            }
            WebServicesDescriptor webServices = webBundle.getWebServices();
            Collection endpoints = webServices.getEndpointsImplementedBy(webComponent);
            this.endpoint = (WebServiceEndpoint)endpoints.iterator().next();
            if (!"http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding())) {
                this.wsEngine_.createHandler(this.endpoint);
            }
            if (this.endpoint.getWsdlExposed() != null) {
                this.wsdlExposed = Boolean.parseBoolean(this.endpoint.getWsdlExposed());
            }
            this.urlPattern = (uri = this.endpoint.getEndpointAddressUri()).startsWith("/") ? uri : "/" + uri;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Servlet web service endpoint '" + servletName + "' failure", t);
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        }
    }

    private Adapter getEndpointFor(HttpServletRequest request) {
        String path = request.getRequestURI().substring(request.getContextPath().length());
        return JAXWSAdapterRegistry.getInstance().getAdapter(this.contextRoot, this.urlPattern, path);
    }
}

