/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.model.Model;
import com.sun.xml.rpc.spi.model.Port;
import com.sun.xml.rpc.spi.model.Service;
import com.sun.xml.rpc.spi.tools.CompileTool;
import com.sun.xml.rpc.spi.tools.CompileToolDelegate;
import com.sun.xml.rpc.spi.tools.Configuration;
import com.sun.xml.rpc.spi.tools.HandlerChainInfo;
import com.sun.xml.rpc.spi.tools.HandlerInfo;
import com.sun.xml.rpc.spi.tools.ModelInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.glassfish.webservices.WsUtil;

public final class WsCompile
extends CompileToolDelegate {
    private Collection generatedFiles;
    private WebService webService;
    private ServiceReferenceDescriptor serviceRef;
    private WsUtil wsUtil = new WsUtil();
    private CompileTool wscompile;
    private JaxRpcObjectFactory rpcFactory;
    private ModelInfo modelInfo;
    private boolean error = false;

    public WsCompile(CompileTool compileTool, WebService webServiceDesc) {
        this.wscompile = compileTool;
        this.webService = webServiceDesc;
        this.rpcFactory = JaxRpcObjectFactory.newInstance();
    }

    public WsCompile(CompileTool compileTool, ServiceReferenceDescriptor serviceRefDesc) {
        this.wscompile = compileTool;
        this.serviceRef = serviceRefDesc;
        this.rpcFactory = JaxRpcObjectFactory.newInstance();
    }

    public void setModelInfo(ModelInfo info) {
        this.modelInfo = info;
    }

    public CompileTool getCompileTool() {
        return this.wscompile;
    }

    public Configuration createConfiguration() {
        Configuration configuration = null;
        if (this.modelInfo != null) {
            configuration = this.rpcFactory.createConfiguration(this.wscompile.getEnvironment());
            configuration.setModelInfo(this.modelInfo);
        }
        return configuration;
    }

    public void preOnError() {
        this.error = true;
    }

    public void postRegisterProcessorActions() {
        if (!this.error && this.webService != null) {
            this.setupServiceHandlerChain();
        }
    }

    public void postRun() {
        this.generatedFiles = new HashSet();
        if (!this.error) {
            Iterator iter = this.wscompile.getEnvironment().getGeneratedFiles();
            while (iter.hasNext()) {
                this.generatedFiles.add(iter.next());
            }
            if (this.webService != null) {
                this.doServicePostProcessing();
            } else if (this.serviceRef != null) {
                this.doClientPostProcessing();
            }
        }
    }

    public Collection getGeneratedFiles() {
        return this.generatedFiles;
    }

    private void setupServiceHandlerChain() {
        Model model = this.wscompile.getProcessor().getModel();
        Collection endpoints = this.webService.getEndpoints();
        for (WebServiceEndpoint nextEndpoint : endpoints) {
            if (!nextEndpoint.hasHandlers()) continue;
            Port port = this.wsUtil.getPortFromModel(model, nextEndpoint.getWsdlPort());
            if (port == null) {
                throw new IllegalStateException("Model port for endpoint " + nextEndpoint.getEndpointName() + " not found");
            }
            LinkedList handlerChain = nextEndpoint.getHandlers();
            HandlerChainInfo modelHandlerChain = port.getServerHCI();
            ArrayList<HandlerInfo> handlerInfoList = new ArrayList<HandlerInfo>();
            HandlerInfo preHandler = this.rpcFactory.createHandlerInfo();
            String handlerClassName = nextEndpoint.implementedByEjbComponent() ? "org.glassfish.webservices.EjbContainerPreHandler" : "org.glassfish.webservices.ServletPreHandler";
            preHandler.setHandlerClassName(handlerClassName);
            handlerInfoList.add(preHandler);
            HashSet soapRoles = new HashSet();
            for (WebServiceHandler nextHandler : handlerChain) {
                HandlerInfo handlerInfo = this.createHandlerInfo(nextHandler);
                handlerInfoList.add(handlerInfo);
                soapRoles.addAll(nextHandler.getSoapRoles());
            }
            HandlerInfo postHandler = this.rpcFactory.createHandlerInfo();
            handlerClassName = nextEndpoint.implementedByEjbComponent() ? "org.glassfish.webservices.EjbContainerPostHandler" : "org.glassfish.webservices.ServletPostHandler";
            postHandler.setHandlerClassName(handlerClassName);
            handlerInfoList.add(postHandler);
            modelHandlerChain.setHandlersList(handlerInfoList);
            Iterator roleIter = soapRoles.iterator();
            while (roleIter.hasNext()) {
                modelHandlerChain.addRole((String)roleIter.next());
            }
        }
    }

    private HandlerInfo createHandlerInfo(WebServiceHandler handler) {
        HandlerInfo handlerInfo = this.rpcFactory.createHandlerInfo();
        handlerInfo.setHandlerClassName(handler.getHandlerClass());
        for (QName next : handler.getSoapHeaders()) {
            handlerInfo.addHeaderName(next);
        }
        Map properties = handlerInfo.getProperties();
        for (NameValuePairDescriptor next : handler.getInitParams()) {
            properties.put(next.getName(), next.getValue());
        }
        return handlerInfo;
    }

    private void doServicePostProcessing() {
        Model model = this.wscompile.getProcessor().getModel();
        Collection endpoints = this.webService.getEndpoints();
        for (WebServiceEndpoint next : endpoints) {
            Service service = this.wsUtil.getServiceForPort(model, next.getWsdlPort());
            if (service == null) {
                service = (Service)model.getServices().next();
                System.out.println("Warning : Can't find Service for Endpoint '" + next.getEndpointName() + "' Port '" + next.getWsdlPort() + "'");
                System.out.println("Defaulting to " + service.getName());
            }
            QName serviceName = service.getName();
            next.setServiceNamespaceUri(serviceName.getNamespaceURI());
            next.setServiceLocalPart(serviceName.getLocalPart());
            Port port = this.wsUtil.getPortFromModel(model, next.getWsdlPort());
            if (port == null) {
                String msg = "Can't find model port for endpoint " + next.getEndpointName() + " with wsdl-port " + next.getWsdlPort();
                throw new IllegalStateException(msg);
            }
            String tieClassName = (String)port.getProperty("com.sun.xml.rpc.processor.model.TieClassName");
            if (tieClassName == null) {
                tieClassName = next.getServiceEndpointInterface() + "_Tie";
            }
            next.setTieClassName(tieClassName);
            if (next.implementedByWebComponent()) {
                this.wsUtil.updateServletEndpointRuntime(next);
            } else {
                this.wsUtil.validateEjbEndpoint(next);
            }
            String endpointAddressUri = next.getEndpointAddressUri();
            if (endpointAddressUri == null) {
                String msg = "Endpoint address uri must be set for endpoint " + next.getEndpointName();
                throw new IllegalStateException(msg);
            }
            if (endpointAddressUri.indexOf("*") >= 0) {
                String msg = "Endpoint address uri " + endpointAddressUri + " for endpoint " + next.getEndpointName() + " is invalid. It must not contain the '*' character";
                throw new IllegalStateException(msg);
            }
            if (!endpointAddressUri.endsWith("/")) continue;
            String msg = "Endpoint address uri " + endpointAddressUri + " for endpoint " + next.getEndpointName() + " is invalid. It must not end with '/'";
            throw new IllegalStateException(msg);
        }
    }

    private void doClientPostProcessing() {
        Model model = this.wscompile.getProcessor().getModel();
        Iterator serviceIter = model.getServices();
        Service service = null;
        if (this.serviceRef.hasServiceName()) {
            while (serviceIter.hasNext()) {
                Service next = (Service)serviceIter.next();
                if (!next.getName().equals(this.serviceRef.getServiceName())) continue;
                service = next;
                break;
            }
            if (service == null) {
                throw new IllegalStateException("Service " + this.serviceRef.getServiceName() + " for service-ref " + this.serviceRef.getName() + " not found");
            }
        } else if (serviceIter.hasNext()) {
            service = (Service)serviceIter.next();
            if (serviceIter.hasNext()) {
                throw new IllegalStateException("service ref " + this.serviceRef.getName() + " must specify" + " service name since its wsdl declares multiple" + " services");
            }
            QName sName = service.getName();
            this.serviceRef.setServiceNamespaceUri(sName.getNamespaceURI());
            this.serviceRef.setServiceLocalPart(sName.getLocalPart());
        } else {
            throw new IllegalStateException("service ref " + this.serviceRef.getName() + " WSDL must " + "define at least one Service");
        }
        String serviceImpl = service.getJavaIntf().getName() + "_Impl";
        this.serviceRef.setServiceImplClassName(serviceImpl);
    }
}

