/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.transaction.Transaction;
import javax.transaction.Transactional;
import javax.transaction.TransactionalException;
import org.glassfish.cdi.transaction.TransactionalInterceptorBase;
import org.glassfish.cdi.transaction.TransactionalInterceptorMandatory;

@Priority(value=1010)
@Interceptor
@Transactional(value=Transactional.TxType.NOT_SUPPORTED)
public class TransactionalInterceptorNotSupported
extends TransactionalInterceptorBase {
    private static Logger _logger = LogDomains.getLogger(TransactionalInterceptorMandatory.class, (String)"javax.enterprise.resource.jta");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object transactional(InvocationContext ctx) throws Exception {
        _logger.info("In NOT_SUPPORTED TransactionalInterceptor");
        if (this.isLifeCycleMethod(ctx)) {
            return this.proceed(ctx);
        }
        this.setTransactionalTransactionOperationsManger(true);
        try {
            Transaction transaction = null;
            if (this.getTransactionManager().getTransaction() != null) {
                _logger.info("Managed bean with Transactional annotation and TxType of NOT_SUPPORTED called inside a transaction context.  Suspending transaction...");
                try {
                    transaction = this.getTransactionManager().suspend();
                }
                catch (Exception exception) {
                    String messageString = "Managed bean with Transactional annotation and TxType of NOT_SUPPORTED called inside a transaction context.  Suspending transaction failed due to " + exception;
                    _logger.info(messageString);
                    throw new TransactionalException(messageString, (Throwable)exception);
                }
            }
            Object proceed = null;
            try {
                proceed = this.proceed(ctx);
            }
            finally {
                if (transaction != null) {
                    try {
                        this.getTransactionManager().resume(transaction);
                    }
                    catch (Exception exception) {
                        String messageString = "Managed bean with Transactional annotation and TxType of NOT_SUPPORTED encountered exception during resume " + exception;
                        throw new TransactionalException(messageString, (Throwable)exception);
                    }
                }
            }
            Object object = proceed;
            return object;
        }
        finally {
            this.resetTransactionOperationsManager();
        }
    }
}

