/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.hk2;

import java.util.HashMap;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import org.glassfish.cdi.hk2.CDISecondChanceResolver;
import org.glassfish.cdi.hk2.HK2CDIBean;
import org.glassfish.cdi.hk2.HK2IntegrationUtilities;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

public class HK2IntegrationExtension
implements Extension {
    private final HashMap<Long, ActiveDescriptor<?>> foundWithHK2 = new HashMap();
    private final ServiceLocator locator = HK2IntegrationUtilities.getApplicationServiceLocator();

    private <T> void injectionTargetObserver(@Observes ProcessInjectionTarget<T> pit) {
        InjectionTarget injectionTarget = pit.getInjectionTarget();
        Set injectionPoints = injectionTarget.getInjectionPoints();
        for (InjectionPoint injectionPoint : injectionPoints) {
            Injectee injectee = HK2IntegrationUtilities.convertInjectionPointToInjectee(injectionPoint);
            ActiveDescriptor descriptor = this.locator.getInjecteeDescriptor(injectee);
            if (descriptor == null) continue;
            this.foundWithHK2.put(descriptor.getServiceId(), descriptor);
        }
    }

    private void afterDiscoveryObserver(@Observes AfterBeanDiscovery abd) {
        for (ActiveDescriptor<?> descriptor : this.foundWithHK2.values()) {
            abd.addBean(new HK2CDIBean(this.locator, descriptor));
        }
    }

    private void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager manager) {
        CDISecondChanceResolver jit = new CDISecondChanceResolver(this.locator, manager);
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.locator, (Object)jit);
    }

    public String toString() {
        return "HK2IntegrationExtension(" + this.locator + "," + System.identityHashCode(this) + ")";
    }
}

