/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ResourceLoaderImpl
implements ResourceLoader {
    private ClassLoader classLoader;

    public ResourceLoaderImpl(ClassLoader cl) {
        this.classLoader = cl;
    }

    public Class<?> classForName(String name) {
        ClassLoader cl = this.getClassLoader();
        try {
            if (cl != null) {
                return cl.loadClass(name);
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException("Error loading class " + name, (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException("Error loading class " + name, (Throwable)e);
        }
        catch (TypeNotPresentException e) {
            throw new ResourceLoadingException("Error loading class " + name, (Throwable)e);
        }
    }

    public URL getResource(String name) {
        ClassLoader cl = this.getClassLoader();
        if (cl != null) {
            return cl.getResource(name);
        }
        return this.getClass().getResource(name);
    }

    public Collection<URL> getResources(String name) {
        ClassLoader cl = this.getClassLoader();
        try {
            if (cl != null) {
                return this.getCollection(cl.getResources(name));
            }
            return this.getCollection(this.getClass().getClassLoader().getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Error loading resource " + name, (Throwable)e);
        }
    }

    public void cleanup() {
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private Collection<URL> getCollection(Enumeration<URL> resources) {
        ArrayList<URL> urls = new ArrayList<URL>();
        while (resources.hasMoreElements()) {
            urls.add(resources.nextElement());
        }
        return urls;
    }
}

