/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.naming.NamingServiceMBean;
import org.apache.naming.resources.FileDirContext;

public final class NamingService
extends NotificationBroadcasterSupport
implements NamingServiceMBean,
MBeanRegistration {
    private static final Logger log = FileDirContext.logger;
    private static final String UNABLE_TO_RESTORE_ORIGINAL_SYS_PROPERTIES = "AS-WEB-NAMING-00024";
    private NamingServiceMBean.State state = NamingServiceMBean.State.STOPPED;
    private long sequenceNumber = 0L;
    private String oldUrlValue = "";
    private String oldIcValue = "";

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return new ObjectName(":service=Naming");
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.destroy();
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.destroy();
    }

    @Override
    public String getName() {
        return "Apache JNDI Naming Service";
    }

    @Override
    public NamingServiceMBean.State getState() {
        return this.state;
    }

    @Override
    public void start() throws Exception {
        AttributeChangeNotification notification = null;
        if (this.state != NamingServiceMBean.State.STOPPED) {
            return;
        }
        this.state = NamingServiceMBean.State.STARTING;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Starting Apache JNDI Naming Service", "State", "org.apache.naming.NamingServiceMBean$State", (Object)NamingServiceMBean.State.STOPPED, (Object)NamingServiceMBean.State.STARTING);
        this.sendNotification(notification);
        try {
            String value = "org.apache.naming";
            String oldValue = System.getProperty("java.naming.factory.url.pkgs");
            if (oldValue != null) {
                this.oldUrlValue = oldValue;
                value = oldValue + ":" + value;
            }
            System.setProperty("java.naming.factory.url.pkgs", value);
            oldValue = System.getProperty("java.naming.factory.initial");
            if (oldValue != null) {
                this.oldIcValue = oldValue;
            } else {
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            }
        }
        catch (Throwable t) {
            this.state = NamingServiceMBean.State.STOPPED;
            notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Apache JNDI Naming Service", "State", "org.apache.naming.NamingServiceMBean$State", (Object)NamingServiceMBean.State.STARTING, (Object)NamingServiceMBean.State.STOPPED);
            this.sendNotification(notification);
        }
        this.state = NamingServiceMBean.State.STARTED;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Started Apache JNDI Naming Service", "State", "org.apache.naming.NamingServiceMBean$State", (Object)NamingServiceMBean.State.STARTING, (Object)NamingServiceMBean.State.STARTED);
        this.sendNotification(notification);
    }

    @Override
    public void stop() {
        AttributeChangeNotification notification = null;
        if (this.state != NamingServiceMBean.State.STARTED) {
            return;
        }
        this.state = NamingServiceMBean.State.STOPPING;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopping Apache JNDI Naming Service", "State", "org.apache.naming.NamingServiceMBean$State", (Object)NamingServiceMBean.State.STARTED, (Object)NamingServiceMBean.State.STOPPING);
        this.sendNotification(notification);
        try {
            System.setProperty("java.naming.factory.url.pkgs", this.oldUrlValue);
            System.setProperty("java.naming.factory.initial", this.oldIcValue);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, UNABLE_TO_RESTORE_ORIGINAL_SYS_PROPERTIES, t);
        }
        this.state = NamingServiceMBean.State.STOPPED;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Apache JNDI Naming Service", "State", "org.apache.naming.NamingServiceMBean$State", (Object)NamingServiceMBean.State.STOPPING, (Object)NamingServiceMBean.State.STOPPED);
        this.sendNotification(notification);
    }

    @Override
    public void destroy() {
        if (this.getState() != NamingServiceMBean.State.STOPPED) {
            this.stop();
        }
    }
}

