/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import org.apache.catalina.Container;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.core.StandardContext;
import org.glassfish.web.ha.authenticator.HASessionData;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntryMetadata;

public class HASingleSignOnEntry
extends SingleSignOnEntry {
    protected long maxIdleTime;
    protected JavaEEIOUtils ioUtils;
    protected HASingleSignOnEntryMetadata metadata = null;

    public HASingleSignOnEntry() {
        this(null, null, null, null, null, 0L, 0L, 0L, null);
    }

    public HASingleSignOnEntry(Container container, HASingleSignOnEntryMetadata m, JavaEEIOUtils ioUtils) {
        this(m.getId(), null, m.getAuthType(), m.getUserName(), m.getRealmName(), m.getLastAccessTime(), m.getMaxIdleTime(), m.getVersion(), ioUtils);
        ByteArrayInputStream bais = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(m.getPrincipalBytes());
            bis = new BufferedInputStream(bais);
            ois = ioUtils.createObjectInputStream((InputStream)bis, true, ((Object)((Object)this)).getClass().getClassLoader());
            this.principal = (Principal)ois.readObject();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException ex) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ex) {}
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ex) {}
            }
        }
        for (HASessionData data : m.getHASessionDataSet()) {
            StandardContext context = (StandardContext)container.findChild(data.getContextPath());
            Session session = null;
            try {
                session = context.getManager().findSession(data.getSessionId());
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            this.sessions.add(session);
        }
    }

    public HASingleSignOnEntry(String id, Principal principal, String authType, String username, String realmName, long lastAccessTime, long maxIdleTime, long version, JavaEEIOUtils ioUtils) {
        super(id, version, principal, authType, username, realmName);
        this.lastAccessTime = lastAccessTime;
        this.maxIdleTime = maxIdleTime;
        this.ioUtils = ioUtils;
        this.metadata = new HASingleSignOnEntryMetadata(id, version, this.convertToByteArray(principal), authType, username, realmName, lastAccessTime, maxIdleTime);
    }

    public HASingleSignOnEntryMetadata getMetadata() {
        return this.metadata;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public synchronized boolean addSession(SingleSignOn sso, Session session) {
        boolean result = super.addSession(sso, session);
        if (result) {
            this.metadata.addHASessionData(new HASessionData(session.getId(), session.getManager().getContainer().getName()));
        }
        return result;
    }

    public synchronized void removeSession(Session session) {
        super.removeSession(session);
        this.metadata.removeHASessionData(new HASessionData(session.getId(), session.getManager().getContainer().getName()));
    }

    public void setLastAccessTime(long lastAccessTime) {
        super.setLastAccessTime(lastAccessTime);
        this.metadata.setLastAccessTime(lastAccessTime);
    }

    public long incrementAndGetVersion() {
        long ver = super.incrementAndGetVersion();
        this.metadata.setVersion(ver);
        return ver;
    }

    private byte[] convertToByteArray(Object obj) {
        ByteArrayOutputStream baos = null;
        BufferedOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            bos = new BufferedOutputStream(baos);
            oos = this.ioUtils.createObjectOutputStream((OutputStream)bos, true);
            oos.writeObject(obj);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception ex) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception ex) {}
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception ex) {}
            }
        }
        return baos.toByteArray();
    }
}

