/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.MemoryStrategyBuilder;
import com.sun.enterprise.web.PersistenceStrategyBuilder;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.session.PersistenceType;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;

public class PersistenceStrategyBuilderFactory {
    private static final Logger _logger = WebContainer.logger;
    @LogMessageInfo(message="PersistenceStrategyBuilderFactory>>createPersistenceStrategyBuilder: resolvedPersistenceType = {0}, resolvedPersistenceFrequency = {1} resolvedPersistenceScope = {2}", level="FINEST")
    public static final String CREATE_PERSISTENCE_STRATEGY_BUILDER_INFO = "AS-WEB-GLUE-00108";
    @LogMessageInfo(message="Could not find PersistentStrategyBuilder for persistenceType {0}", level="FINEST")
    public static final String PERSISTENT_STRATEGY_BUILDER_NOT_FOUND = "AS-WEB-GLUE-00109";
    @LogMessageInfo(message="PersistenceStrategyBuilderFactory>>createPersistenceStrategyBuilder: CandidateBuilderClassName = {0}", level="FINEST")
    public static final String CREATE_PERSISTENCE_STRATEGY_BUILDER_CLASS_NAME = "AS-WEB-GLUE-00110";
    @LogMessageInfo(message="resolvedPersistenceType = {0}", level="FINEST")
    public static final String ACCESS_LOG_DIRECTORY_SET = "AS-WEB-GLUE-00111";
    ServiceLocator services;

    public PersistenceStrategyBuilderFactory(ServerConfigLookup serverConfigLookup, ServiceLocator services) {
        this.services = services;
    }

    public PersistenceStrategyBuilder createPersistenceStrategyBuilder(String persistenceType, String frequency, String scope, Context ctx) {
        PersistenceStrategyBuilder builder;
        String resolvedPersistenceFrequency = null;
        String resolvedPersistenceScope = null;
        if (!(persistenceType.equalsIgnoreCase(PersistenceType.MEMORY.getType()) || persistenceType.equalsIgnoreCase(PersistenceType.FILE.getType()) || persistenceType.equalsIgnoreCase(PersistenceType.COOKIE.getType()))) {
            resolvedPersistenceFrequency = frequency;
            resolvedPersistenceScope = scope;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, CREATE_PERSISTENCE_STRATEGY_BUILDER_INFO, new Object[]{persistenceType, resolvedPersistenceFrequency, resolvedPersistenceScope});
        }
        if ((builder = (PersistenceStrategyBuilder)this.services.getService(PersistenceStrategyBuilder.class, persistenceType, new Annotation[0])) == null) {
            builder = new MemoryStrategyBuilder();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, PERSISTENT_STRATEGY_BUILDER_NOT_FOUND, persistenceType);
            }
        } else {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, CREATE_PERSISTENCE_STRATEGY_BUILDER_CLASS_NAME, builder.getClass());
            }
            builder.setPersistenceFrequency(frequency);
            builder.setPersistenceScope(scope);
            builder.setPassedInPersistenceType(persistenceType);
        }
        return builder;
    }

    public String getApplicationId(Context ctx) {
        if (ctx instanceof WebModule) {
            return ((WebModule)ctx).getID();
        }
        return ctx.getName();
    }
}

