/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.embed.impl;

import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.web.WebContainer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.ProcessingResult;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.internal.embedded.ScatteredArchive;
import org.glassfish.web.deployment.archivist.WebArchivist;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class EmbeddedWebArchivist
extends WebArchivist {
    private static final Logger _logger = WebContainer.logger;
    public static final String CANNOT_LOAD_CLASS = "AS-WEB-GLUE-00280";
    private final ModuleScanner scanner = new ModuleScanner(){
        final Set<Class> elements = new HashSet<Class>();

        public void process(ReadableArchive archiveFile, Object bundleDesc, ClassLoader classLoader, Parser parser) throws IOException {
            Enumeration entries = archiveFile.entries();
            while (entries.hasMoreElements()) {
                String entry = (String)entries.nextElement();
                if (!entry.endsWith(".class")) continue;
                try {
                    this.elements.add(classLoader.loadClass(this.toClassName(entry)));
                }
                catch (ClassNotFoundException e) {
                    deplLogger.log(Level.FINER, MessageFormat.format(_logger.getResourceBundle().getString(EmbeddedWebArchivist.CANNOT_LOAD_CLASS), entry), e);
                }
            }
        }

        private String toClassName(String entryName) {
            String name = entryName.substring("WEB-INF/classes/".length(), entryName.length() - ".class".length());
            return name.replaceAll("/", ".");
        }

        public void process(File archiveFile, Object bundleDesc, ClassLoader classLoader) throws IOException {
        }

        public Set getElements() {
            return this.elements;
        }
    };
    private static URL defaultWebXmlLocation = null;

    protected void setDefaultWebXml(URL defaultWebXml) {
        defaultWebXmlLocation = defaultWebXml;
    }

    @Override
    protected URL getDefaultWebXML() throws IOException {
        if (defaultWebXmlLocation != null) {
            return defaultWebXmlLocation;
        }
        URL defaultWebXml = super.getDefaultWebXML();
        return defaultWebXml == null ? ((Object)((Object)this)).getClass().getClassLoader().getResource("org/glassfish/web/embed/default-web.xml") : defaultWebXml;
    }

    protected ProcessingResult processAnnotations(RootDeploymentDescriptor bundleDesc, ModuleScanner scanner, ReadableArchive archive) throws AnnotationProcessorException, IOException {
        if (archive instanceof ScatteredArchive) {
            return super.processAnnotations(bundleDesc, this.scanner, archive);
        }
        return super.processAnnotations(bundleDesc, scanner, archive);
    }
}

