/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.util;

public class CookieTokenizer {
    private static final int MAX_COOKIE_TOKENS = 160;
    private String[] tokens = new String[160];
    private int numTokens = 0;

    private int parseNameValue(String cookies, int beginIndex) {
        int index;
        int length = cookies.length();
        block5: for (index = beginIndex; index < length; ++index) {
            switch (cookies.charAt(index)) {
                case ',': 
                case ';': {
                    this.tokens[this.numTokens] = cookies.substring(beginIndex, index).trim();
                    if (this.tokens[this.numTokens].length() > 0) {
                        ++this.numTokens;
                        this.tokens[this.numTokens] = null;
                        ++this.numTokens;
                    }
                    return index + 1;
                }
                case '=': {
                    this.tokens[this.numTokens] = cookies.substring(beginIndex, index).trim();
                    ++this.numTokens;
                    return this.parseValue(cookies, index + 1);
                }
                case '\"': {
                    while (cookies.charAt(++index) != '\"') {
                    }
                    continue block5;
                }
            }
        }
        if (index > beginIndex) {
            this.tokens[this.numTokens] = cookies.substring(beginIndex, index).trim();
            if (this.tokens[this.numTokens].length() > 0) {
                ++this.numTokens;
                this.tokens[this.numTokens] = null;
                ++this.numTokens;
            }
        }
        return index;
    }

    public int tokenize(String cookies) {
        this.numTokens = 0;
        if (cookies != null) {
            try {
                int length = cookies.length();
                int index = 0;
                while (index < length) {
                    index = this.parseNameValue(cookies, index);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return this.numTokens;
    }

    public int getNumTokens() {
        return this.numTokens;
    }

    public String tokenAt(int index) {
        return this.tokens[index];
    }

    private int parseValue(String cookies, int beginIndex) {
        int index;
        int length = cookies.length();
        block4: for (index = beginIndex; index < length; ++index) {
            switch (cookies.charAt(index)) {
                case ',': 
                case ';': {
                    this.tokens[this.numTokens] = cookies.substring(beginIndex, index).trim();
                    ++this.numTokens;
                    return index + 1;
                }
                case '\"': {
                    while (cookies.charAt(++index) != '\"') {
                    }
                    continue block4;
                }
            }
        }
        this.tokens[this.numTokens] = cookies.substring(beginIndex, index).trim();
        ++this.numTokens;
        return index;
    }
}

