/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.pwc.connector.coyote;

import com.sun.enterprise.web.pwc.PwcWebModule;
import com.sun.enterprise.web.session.WebSessionCookieConfig;
import com.sun.grizzly.util.http.ServerCookie;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;

public class PwcCoyoteRequest
extends Request {
    private static final Logger logger = LogDomains.getLogger(PwcCoyoteRequest.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle rb = logger.getResourceBundle();
    private boolean sunWebXmlChecked = false;
    private byte[] formData = null;
    private int formDataLen = 0;

    public void setContext(Context ctx) {
        if (ctx == null) {
            return;
        }
        super.setContext(ctx);
        Response response = (Response)this.getResponse();
        if (response != null) {
            String[] cacheControls = ((PwcWebModule)ctx).getCacheControls();
            for (int i = 0; cacheControls != null && i < cacheControls.length; ++i) {
                response.addHeader("Cache-Control", cacheControls[i]);
            }
        }
        this.sunWebXmlChecked = false;
    }

    public BufferedReader getReader() throws IOException {
        if (super.getCharacterEncoding() == null) {
            this.setRequestEncodingFromSunWebXml();
        }
        return super.getReader();
    }

    public String getCharacterEncoding() {
        String enc = super.getCharacterEncoding();
        if (enc != null) {
            return enc;
        }
        boolean encodingFound = this.setRequestEncodingFromSunWebXml();
        if (encodingFound) {
            return super.getCharacterEncoding();
        }
        return null;
    }

    public void configureSessionCookie(Cookie cookie) {
        super.configureSessionCookie(cookie);
        PwcWebModule wm = (PwcWebModule)this.getContext();
        WebSessionCookieConfig cookieConfig = (WebSessionCookieConfig)wm.getSessionCookieConfig();
        WebSessionCookieConfig.CookieSecureType type = cookieConfig.getSecure();
        if (WebSessionCookieConfig.CookieSecureType.TRUE == type) {
            cookie.setSecure(true);
        } else if (WebSessionCookieConfig.CookieSecureType.FALSE == type) {
            cookie.setSecure(false);
        } else {
            cookie.setSecure(this.isSecure());
        }
    }

    public void recycle() {
        super.recycle();
        this.formDataLen = 0;
        this.sunWebXmlChecked = false;
    }

    private boolean setRequestEncodingFromSunWebXml() {
        if (this.sunWebXmlChecked) {
            return false;
        }
        this.sunWebXmlChecked = true;
        PwcWebModule wm = (PwcWebModule)this.getContext();
        String encoding = this.getFormHintFieldEncoding(wm);
        if (encoding == null && (encoding = wm.getDefaultCharset()) == null && wm.hasLocaleToCharsetMapping()) {
            encoding = wm.mapLocalesToCharset(this.getLocales());
        }
        if (encoding != null) {
            try {
                this.setCharacterEncoding(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                String msg = rb.getString("request.unableToSetEncodingFromSunWebXml");
                msg = MessageFormat.format(msg, encoding, wm.getID());
                logger.log(Level.WARNING, msg, uee);
            }
        }
        return encoding != null;
    }

    private String getFormHintFieldEncoding(PwcWebModule wm) {
        String encoding = null;
        String formHintField = wm.getFormHintField();
        if (formHintField == null) {
            return null;
        }
        if ("POST".equalsIgnoreCase(this.getMethod())) {
            encoding = this.getPostDataEncoding(formHintField);
        } else {
            String query = this.getQueryString();
            if (query != null) {
                encoding = this.parseFormHintField(query, formHintField);
            }
        }
        return encoding;
    }

    private String getPostDataEncoding(String formHintField) {
        int semicolon;
        if (!this.getMethod().equalsIgnoreCase("POST")) {
            return null;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if (!"application/x-www-form-urlencoded".equals(contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim())) {
            return null;
        }
        int len = this.getContentLength();
        if (len <= 0) {
            return null;
        }
        int maxPostSize = ((Connector)this.connector).getMaxPostSize();
        if (maxPostSize > 0 && len > maxPostSize) {
            throw new IllegalStateException(rb.getString("request.postTooLarge"));
        }
        String encoding = null;
        try {
            this.formData = null;
            if (len < 8192) {
                if (this.postData == null) {
                    this.postData = new byte[8192];
                }
                this.formData = this.postData;
            } else {
                this.formData = new byte[len];
            }
            int actualLen = this.readPostBody(this.formData, len);
            if (actualLen == len) {
                this.formDataLen = actualLen;
                String formDataString = new String(this.formData, Charset.defaultCharset()).substring(0, len);
                encoding = this.parseFormHintField(formDataString, formHintField);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return encoding;
    }

    private String parseFormHintField(String paramsString, String formHintField) {
        String encoding = null;
        int index = paramsString.indexOf(formHintField = formHintField + "=");
        if (index != -1) {
            int endIndex = paramsString.indexOf(38, index);
            encoding = endIndex != -1 ? paramsString.substring(index + formHintField.length(), endIndex) : paramsString.substring(index + formHintField.length());
        }
        return encoding;
    }

    protected byte[] getPostBody() throws IOException {
        if (this.formDataLen > 0) {
            return this.formData;
        }
        return super.getPostBody();
    }

    protected Cookie makeCookie(ServerCookie scookie) {
        PwcWebModule wm = (PwcWebModule)this.getContext();
        boolean encodeCookies = false;
        if (wm != null && wm.getEncodeCookies()) {
            encodeCookies = true;
        }
        return this.makeCookie(scookie, encodeCookies);
    }
}

